package cn.com.duiba.nezha.alg.alg.alg;

import cn.com.duiba.nezha.alg.alg.adsupport.NewAdvertSupport;
import cn.com.duiba.nezha.alg.alg.vo.AdvertSupportInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import java.util.HashMap;
import java.util.Map;

/**
 *
 *
 *
 */
public class NewAdvertSupportAlg {

    /**
     * 广告位熔断
     */
    public static <T> Map<T, Double> circuitBreaker(Map<T, AdvertSupportInfoDo> supportAdvertMap) throws Exception {

        Map<T, Double> ret = new HashMap<>();
        if (AssertUtil.isEmpty(supportAdvertMap)) {
            return ret;
        }
        return NewAdvertSupport.circuitBreaker(supportAdvertMap);

    }

    /**
     * 扶持权重因子
     */
    public static <T> Map<T, Double> biddingFactor(Map<T, Double> supportAdvertCircuitBreakerMap,
                                                   Map<T, BudgetSmoothDo> budgetSmoothFactorMap,
                                                   Map<T, Double> statCVRMap,
                                                   Map<T, Double> preCVRMap) throws Exception {

        Map<T, Double> ret = new HashMap<>();
        if (AssertUtil.isAnyEmpty(supportAdvertCircuitBreakerMap, statCVRMap, preCVRMap)) {
            return ret;
        }
        return NewAdvertSupport.biddingFactor(supportAdvertCircuitBreakerMap, budgetSmoothFactorMap, statCVRMap, preCVRMap);

    }

}
