package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import java.util.HashMap;
import java.util.Map;

public class DeepBidControl {


    /**
     * 策略：双出价维稳
     *
     * @return
     */
    public static void deepControl(AdBidParamsDo adBidParamsDo, OcpxControlParams slotParams) {


        Long fee = adBidParamsDo.getFee();

        /**
         * 未开启双出价 直接返回
         */
        if (adBidParamsDo.getIsDeepControl() == null || !adBidParamsDo.getIsDeepControl()) {
            return;
        }

        /**
         * ABTest 实验组
         */
        if (adBidParamsDo.getDeepControlTestId() != null && adBidParamsDo.getDeepControlTestId().equals(1L)) {
            Double factor = OcpxControlParams.getDeepFactor(slotParams);
            if (factor != null) {

                Long feeNew = Math.round(fee * factor);

                adBidParamsDo.setDeepFactor(factor);
                adBidParamsDo.setFee(feeNew);

            }
        }


    }

}
