/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.correct;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.CorrectionInfo;
import cn.com.duiba.nezha.alg.alg.vo.NezhaStatDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.Arrays;
import java.util.List;

public class ModelPredRectifier {
    public static void getCorrectionFactor(List<CorrectionInfo> advertCorrectionInfoList) {
        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            if (info == null) continue;
            info.setCorrectionFactor(1.0);
            info.setReconstructionFactor(1.0);
            ModelPredRectifier.setCorrectionFactor(info);
        }
    }

    public static void getCorrectionFactor(CorrectionInfo advertCorrectionInfo) {
        if (AssertUtil.isEmpty((Object)advertCorrectionInfo)) {
            return;
        }
        advertCorrectionInfo.setCorrectionFactor(1.0);
        advertCorrectionInfo.setReconstructionFactor(1.0);
        ModelPredRectifier.setCorrectionFactor(advertCorrectionInfo);
    }

    public static void getCorrectionReconstructionFactor(List<CorrectionInfo> advertCorrectionInfoList) throws Exception {
        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            if (info == null) continue;
            info.setCorrectionFactor(1.0);
            info.setReconstructionFactor(1.0);
            ModelPredRectifier.setCorrectionFactor(info);
            ModelPredRectifier.setReconstructionFactor(info);
        }
    }

    public static void getCorrectionReconstructionFactor(CorrectionInfo advertCorrectionInfo) {
        if (AssertUtil.isEmpty((Object)advertCorrectionInfo)) {
            return;
        }
        advertCorrectionInfo.setCorrectionFactor(1.0);
        advertCorrectionInfo.setReconstructionFactor(1.0);
        ModelPredRectifier.setCorrectionFactor(advertCorrectionInfo);
        ModelPredRectifier.setReconstructionFactor(advertCorrectionInfo);
    }

    public static void setCorrectionFactor(CorrectionInfo info) {
        if (info == null) {
            return;
        }
        if (info.getCurrentPreValue() == null) {
            return;
        }
        if (info.getCurrentPreValue() < 1.0E-10) {
            return;
        }
        if (info.getNezhaStatDto() == null) {
            return;
        }
        Long type = info.getType();
        Double currentPreValue = info.getCurrentPreValue();
        NezhaStatDto nezhaStatDto = info.getNezhaStatDto();
        Double avgPreValue = null;
        Double avgFeedbackValue = null;
        Double vUpperLimit = null;
        Double vLowerLimit = null;
        Double fUpperLimit = null;
        Double fLowerLimit = null;
        Long launchCnt = 0L;
        if (type.equals(1L)) {
            avgPreValue = nezhaStatDto.getPreCtrAvg();
            avgFeedbackValue = nezhaStatDto.getStatCtrAvg();
            launchCnt = nezhaStatDto.getCtrLaunchCnt();
            vUpperLimit = 0.9999;
            vLowerLimit = 0.01;
            fUpperLimit = 3.0;
            fLowerLimit = 0.2;
        }
        if (type.equals(2L)) {
            avgPreValue = nezhaStatDto.getPreCvrAvg();
            avgFeedbackValue = nezhaStatDto.getStatCvrAvg();
            launchCnt = nezhaStatDto.getCvrLaunchCnt();
            vUpperLimit = 0.9999;
            vLowerLimit = 5.0E-4;
            fUpperLimit = 3.0;
            fLowerLimit = 0.2;
        }
        Double newCurrentPreValue = ModelPredRectifier.correctionValue(currentPreValue, avgPreValue, avgFeedbackValue, vLowerLimit, vUpperLimit);
        Double currentPreFactor = ModelPredRectifier.noiseSmoother(newCurrentPreValue / currentPreValue, fLowerLimit, fUpperLimit);
        info.setCorrectionFactor(currentPreFactor);
    }

    public static void setReconstructionFactor(CorrectionInfo info) {
        if (info == null) {
            return;
        }
        if (info.getCurrentPreValue() == null) {
            return;
        }
        if (info.getNezhaStatDto() == null) {
            return;
        }
        Long type = info.getType();
        Double currentPreValue = info.getCurrentPreValue();
        NezhaStatDto nezhaStatDto = info.getNezhaStatDto();
        Long launchCnt = 0L;
        Double avgFeedbackValue = null;
        Double lowerLimit = null;
        Double upperLimit = null;
        Double midVal = null;
        Double zoom = null;
        Double fBratio = null;
        boolean isCtr = true;
        if (type.equals(1L)) {
            avgFeedbackValue = nezhaStatDto.getStatCtrAvg();
            lowerLimit = 0.1;
            upperLimit = 1.0;
            midVal = 0.03;
            zoom = 40.0;
            fBratio = 0.1;
        }
        if (type.equals(2L)) {
            avgFeedbackValue = nezhaStatDto.getStatCvrAvg();
            lowerLimit = 0.1;
            upperLimit = 1.0;
            midVal = 0.03;
            zoom = 40.0;
            fBratio = 0.1;
            isCtr = false;
        }
        Double correctionFactor = info.getCorrectionFactor();
        Double newCurrentPreValue = currentPreValue * correctionFactor;
        Double reconstructionValue = ModelPredRectifier.reconstructionValue(isCtr, newCurrentPreValue, avgFeedbackValue, fBratio, zoom, midVal, lowerLimit, upperLimit);
        Double reconstructionFactor = ModelPredRectifier.noiseSmoother(reconstructionValue / newCurrentPreValue, 0.2, 1.5);
        info.setReconstructionFactor(reconstructionFactor);
    }

    public static Double noiseSmoother(Double point, Double lowerLimit, Double upperLimit) {
        Double ret = point;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{upperLimit, lowerLimit})) {
            return ret;
        }
        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }
        return ret;
    }

    public static Double correctionValue(Double currentPreValue, Double avgPreValue, Double avgFeedbackValue, Double lowerLimit, Double upperLimit) {
        Double ret = currentPreValue;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{currentPreValue, avgPreValue, avgFeedbackValue, upperLimit, lowerLimit})) {
            return ret;
        }
        if (currentPreValue > 0.0 && avgPreValue > 0.0 && avgFeedbackValue > 0.0) {
            Double lndValue = ModelPredRectifier.noiseSmoother(currentPreValue * avgFeedbackValue / avgPreValue, lowerLimit, upperLimit);
            Double ndValue = ModelPredRectifier.noiseSmoother(currentPreValue + avgFeedbackValue - avgPreValue, lowerLimit, upperLimit);
            ret = avgPreValue > avgFeedbackValue ? Double.valueOf(Math.max(lndValue, ndValue)) : Double.valueOf(Math.min(lndValue, ndValue));
            ret = 0.8 * ret + 0.19999999999999996 * currentPreValue;
        }
        return ret;
    }

    public static Double reconstructionValue(boolean isCtr, Double newCurrentPreValue, Double avgFeedbackValue, double fBratio, double zoom, double midVal, double lowerLimit, double upperLimit) {
        Double ret = newCurrentPreValue;
        Double absoluteFactor = 1.0;
        Double relativeFactor = 1.0;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{newCurrentPreValue, avgFeedbackValue})) {
            return ret;
        }
        if (newCurrentPreValue > 0.0 && avgFeedbackValue > 1.0E-4 && !isCtr) {
            Double ratio = (newCurrentPreValue + 0.001) / (avgFeedbackValue + 0.001);
            Double mergeVal = (1.0 - fBratio) * newCurrentPreValue + fBratio * avgFeedbackValue;
            if (newCurrentPreValue < 0.05 && ratio < 0.5) {
                absoluteFactor = MathBase.sigmoidWithZoomAndIntervalMap(newCurrentPreValue / 0.05 - 0.5, 0.7, 1.0, 8.0);
            } else if (newCurrentPreValue >= 0.5) {
                absoluteFactor = 1.05;
            }
            if (ratio < 1.0) {
                Double relativeFactor1 = MathBase.sigmoidWithZoomAndIntervalMap(ratio - 0.5, 0.1, 1.01, 8.0);
                Double relativeFactor2 = MathBase.sigmoidWithZoomAndIntervalMap(ratio - 0.5, 0.3, 1.01, 8.0);
                relativeFactor = newCurrentPreValue <= 0.1 ? relativeFactor1 : (newCurrentPreValue < 0.2 ? Double.valueOf(((0.2 - newCurrentPreValue) * relativeFactor1 + (newCurrentPreValue - 0.1) * relativeFactor2) / 0.1) : relativeFactor2);
            } else if (ratio > 2.0) {
                relativeFactor = 1.05;
            }
            ret = ret * relativeFactor * absoluteFactor;
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            NezhaStatDto nezhaStatDto = new NezhaStatDto();
            nezhaStatDto.setAdvertId(13675L);
            nezhaStatDto.setCtrLaunchCnt(1000000L);
            nezhaStatDto.setCvrLaunchCnt(1000000L);
            nezhaStatDto.setAlgType(206L);
            nezhaStatDto.setAppId(20453L);
            nezhaStatDto.setPreCtrAvg(0.15);
            nezhaStatDto.setStatCtrAvg(0.14);
            nezhaStatDto.setPreCvrAvg(0.16);
            nezhaStatDto.setStatCvrAvg(0.09);
            CorrectionInfo info = new CorrectionInfo();
            info.setAdvertId(13675L);
            info.setType(1L);
            info.setCurrentPreValue(0.059);
            info.setNezhaStatDto(nezhaStatDto);
            ModelPredRectifier.getCorrectionReconstructionFactor(Arrays.asList(info));
            System.out.println("testGetCorrectionFactor CTR info.getCorrectionFactor()" + info.getCorrectionFactor());
            System.out.println("testGetCorrectionFactor CTR info.getReconstructionFactor()" + info.getReconstructionFactor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

