package cn.com.duiba.nezha.alg.alg.recall.data;

import com.google.common.primitives.Longs;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class AdInputDto {

    /**
     * 广告ID
     */
    private Long advertId ;

    /**
     * 配置ID
     */
    private Long orientationId;

    /**
     * 控制策略
     */
    private Integer releaseTarget;  //1-稳定投放，2-抢量优先(中)， 3-抢量优先(高)， 4-人工定向， 5-成本优先

    /**
    * 对应的行业编号在nezha-service的
    * cn/com/duiba/nezha/engine/biz/enums/NewTradeIdEnum.java
    */
    private String newTradeTagId;//行业

    /**
     * 对应的转化目标编号在nezha-service的
     * cn/com/duiba/nezha/engine/biz/enums/AdvertStatisticsReportSubtypeEnum.java
     */
    private Integer cvrType;//转化目标

    private Boolean isPersist;

    public String getKey() {
        return this.advertId + "_" + this.orientationId;
    }
    //搞个方法传字符串既set好广告id也set好配置id
    public void setAdPkOnce(String adPk) {
        String[] adpkList=adPk.split("_");
        this.advertId= Longs.tryParse(adpkList[0]);
        this.orientationId=Longs.tryParse(adpkList[1]);
    }
}
