package cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan;

import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

@Data
public class AdxDirecetlyPriceDo {

    /**
     * 广告ID
     */
    private Long advertId;

    /**
     * 素材ID
     */
    private Long materialId;

    /**
     * 计划维度设置的目标分成比例
     */
    private Double advShareRate;

    /**
     * 广告线 发券CPC价格
     */
    private Double advPrice;

    /**
     * 广告线预估 CTR
     */
    private Double ctr;

    /**
     * 算法调整后的返回给媒体的出价
     */
    private Double adxPrice;

    /**
     * 维稳因子
     */
    private Double roiFactor;

    /**
     * CTR权重调节因子
     */
    private Double ctrFactor;


    public static Double getShareRate(AdxDirecetlyPriceDo adxDirecetlyPriceDo) {
        Double ret = null;
        if(adxDirecetlyPriceDo != null && adxDirecetlyPriceDo.getAdvShareRate() != null) {
            ret = adxDirecetlyPriceDo.getAdvShareRate() /100;
        }
        return ret;
    }

    public static Double getRankScore(AdxDirecetlyPriceDo adxDirecetlyPriceDo) {
        Double ret = 0.;
        Double priceLower = 40.0;
        Double priceUpper = 80.0;
        if(adxDirecetlyPriceDo != null) {
            ret = MathUtil.dotPow(adxDirecetlyPriceDo.getAdxPrice(), adxDirecetlyPriceDo.getCtr(),
                    adxDirecetlyPriceDo.getCtrFactor(), priceLower, priceUpper, 3);
        }
        return ret;
    }

}