package cn.com.duiba.nezha.alg.alg.vo.adx.rtb2;

import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;
import org.apache.commons.collections.MapUtils;

@Data
public class AdxStatBaseDo {

    /**
     * 竞价返回量级
     */
    private Long bid;

    /**
     * 曝光量级
     */
    private Long exp;

    /**
     * 点击量级
     */
    private Long click;

    /**
     * adx消耗(分*10^4/cpm)
     */
    private Long adxConsume;

    /**
     * 广告消耗(分)
     */
    private Long advertConsume;

    /**
     * 广告发券数
     */
    private Long advertLaunch;

    /**
     * 广告计费点击数
     */
    private Long advertClick;

    /**
     * 获取adx消耗（分-每次曝光）
     */
    public Double getAdxConsume2() {
       return MathUtil.division(adxConsume, 10000000., 3);
    }

    /**
     * 获取adx消耗（分-每千次曝光）
     *
     */
    public Double getAdxConsume3() {
        return MathUtil.division(adxConsume, 10000., 3);
    }

    /**
     * 判断消耗是否置信
     * @param adxStatBaseDo
     * @return
     */
    public static boolean isCostConfidence(AdxStatBaseDo adxStatBaseDo) {
        boolean ret = false;
        if(adxStatBaseDo != null) {
            if(adxStatBaseDo.getAdxConsume() != null && adxStatBaseDo.getAdxConsume2() > 3000) {
                ret = true;
            }
        }
        return ret;
    }

    /**
     * 判断曝光是否置信
     * @param adxStatBaseDo
     * @return
     */
    public static boolean isImpConfidence(AdxStatBaseDo adxStatBaseDo) {
        boolean ret = false;
        if(adxStatBaseDo != null) {
            if(adxStatBaseDo.getExp() != null && adxStatBaseDo.getExp() > 1000) {
                ret = true;
            }
        }
        return ret;
    }



    /**
     * 计算统计ctr
     * @param adxStatBaseDo
     * @return
     */
    public static Double getStatCtr(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if(AdxStatBaseDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division(adxStatBaseDo.getClick(), adxStatBaseDo.getExp(), 3);
        }
        return ret;
    }

    /**
     * 计算统计每pv发券
     */
    public static Double getStatLaunchPv(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if(AdxStatBaseDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division(adxStatBaseDo.getAdvertLaunch(), adxStatBaseDo.getClick(), 3);
        }
        return ret;
    }

    /**
     * 计算统计arpu值
     */
    public static Double getStatArpu(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if(AdxStatBaseDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division(adxStatBaseDo.getAdvertConsume(), adxStatBaseDo.getAdvertLaunch(), 3);
        }
        return ret;
    }

    /**
     * 计算统计cpm值
     */
    public static Double getStatCpm(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if(AdxStatBaseDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division(adxStatBaseDo.getAdxConsume3(), adxStatBaseDo.getExp(), 3);
        }
        return ret;
    }

    /**
     * 计算统计点击价值
     */
    public static Double getStatClickValue(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if(AdxStatBaseDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division(adxStatBaseDo.getAdvertConsume(), adxStatBaseDo.getClick(), 3);
        }
        return ret;
    }





}
