/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.coldstartandexplore;

import cn.com.duiba.nezha.alg.alg.vo.NdAdvertParams;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertResultV3Do;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertV3Info;
import cn.com.duiba.nezha.alg.alg.vo.NdFilterAppInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdAdvertSupportV3 {
    private static final Logger logger = LoggerFactory.getLogger(NdAdvertSupportV3.class);
    public static Comparator<RectifyNdAdvertResInfo> iComparator = new Comparator<RectifyNdAdvertResInfo>(){

        @Override
        public int compare(RectifyNdAdvertResInfo r1, RectifyNdAdvertResInfo r2) {
            return r2.rectifyBid - r1.rectifyBid >= 0.0 ? 1 : -1;
        }
    };

    public static List<NdAdvertResultV3Do> NDAdvertColdStartAndExpose(NdFilterAppInfo ndFilterAppInfo, NdAdvertParams ndAdvertParams, List<NdAdvertV3Info> ndAdvertInfoList, List<Long> ndAdvertBlackList) {
        ArrayList<NdAdvertResultV3Do> res = new ArrayList<NdAdvertResultV3Do>();
        PriorityQueue<RectifyNdAdvertResInfo> candis = new PriorityQueue<RectifyNdAdvertResInfo>(iComparator);
        HashSet<Long> tmpSet = new HashSet<Long>();
        int numOfBidNd = ndAdvertInfoList.size();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ndAdvertInfoList, ndFilterAppInfo, ndAdvertParams})) {
            return res;
        }
        Long hisAppConvert = ndFilterAppInfo.getHisAppConvert();
        Double hisAppCVR = ndFilterAppInfo.getHisAppCVR();
        Long hisAppConsume = ndFilterAppInfo.getHisAppConsume();
        if (hisAppConvert <= (long)ndAdvertParams.getAppConvertThreshold().intValue() || hisAppCVR <= ndAdvertParams.getAppCVRThreshold() || (double)hisAppConsume.longValue() <= ndAdvertParams.getAppConsumeThreshold()) {
            return res;
        }
        for (int i = 0; i < ndAdvertInfoList.size(); ++i) {
            Integer exposeConfidenceThreshold2;
            Double exposeConsumePercentThreshold;
            Integer exposeConfidenceThreshold;
            double curRectifyBid = 0.0;
            double exposureFactor = 1.0;
            NdAdvertV3Info curNdAdvertInfo = ndAdvertInfoList.get(i);
            Long curAdvert = curNdAdvertInfo.getAdvertId();
            RectifyNdAdvertResInfo rectifyNdAdvertResInfo = new RectifyNdAdvertResInfo();
            Long hisSlotAdvExpose = curNdAdvertInfo.getHisExpose();
            Long hisAdvertExploreConsume = curNdAdvertInfo.getHisAdvertExploreConsume();
            Long hisAdvertConsume = curNdAdvertInfo.getHisAdvertConsume();
            Map<String, Object> AdjustCVRRes = NdAdvertSupportV3.getAdjustCVR(ndAdvertParams, curNdAdvertInfo);
            double adjustWeight = (Double)AdjustCVRRes.get("adjustWeight");
            double adjustCvr = (Double)AdjustCVRRes.get("adjustCvr");
            String paramType = (Double)AdjustCVRRes.get("paramType") == 1.0 ? "firstSet" : "secondSet";
            String curNdAdvertLevel = (String)AdjustCVRRes.get("curNdAdvertLevel");
            double preCtr = curNdAdvertInfo.getPreCtr();
            Long bid = curNdAdvertInfo.getBid();
            if (paramType.equals("firstSet")) {
                exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThreshold();
                exposeConsumePercentThreshold = ndAdvertParams.getExposeConsumePercentThreshold();
                exposeConfidenceThreshold2 = ndAdvertParams.getExposeConfidenceThreshold2();
            } else {
                exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThresholdSet3();
                exposeConsumePercentThreshold = ndAdvertParams.getExposeConsumePercentThresholdSet2();
                exposeConfidenceThreshold2 = ndAdvertParams.getExposeConfidenceThresholdSet5();
            }
            if (!(!CollectionUtils.isEmpty(ndAdvertBlackList) && ndAdvertBlackList.contains(curAdvert) || hisSlotAdvExpose > (long)exposeConfidenceThreshold.intValue() && !((double)hisAdvertExploreConsume.longValue() <= exposeConsumePercentThreshold * (double)hisAdvertConsume.longValue()))) {
                if (hisSlotAdvExpose <= (long)exposeConfidenceThreshold2.intValue()) {
                    exposureFactor = NdAdvertSupportV3.functionOfExpose(hisSlotAdvExpose, ndAdvertParams, paramType);
                    curRectifyBid = preCtr * adjustCvr * (double)bid.longValue() * exposureFactor;
                } else {
                    curRectifyBid = preCtr * adjustCvr * (double)bid.longValue();
                    tmpSet.add(curNdAdvertInfo.getAdvertId());
                }
                rectifyNdAdvertResInfo.ndAdvertResult = NdAdvertSupportV3.fillData(curNdAdvertInfo, 1.0, 1.0, adjustWeight, preCtr, adjustCvr, exposureFactor, numOfBidNd, 1, curNdAdvertLevel);
                rectifyNdAdvertResInfo.rectifyBid = curRectifyBid;
                candis.add(rectifyNdAdvertResInfo);
                continue;
            }
            res.add(NdAdvertSupportV3.fillData(curNdAdvertInfo, 1.0, 1.0, adjustWeight, preCtr, adjustCvr, 1.0, numOfBidNd, -1, null));
        }
        int lengthOfCandis = candis.size();
        List<Double> functionOfRectifyFacList = NdAdvertSupportV3.functionOfRectifyFac(lengthOfCandis, ndAdvertParams);
        for (int idx = 0; idx < lengthOfCandis; ++idx) {
            double curFactor = functionOfRectifyFacList.get(idx);
            RectifyNdAdvertResInfo curRectifyNdAdvertResInfo = (RectifyNdAdvertResInfo)candis.poll();
            if (tmpSet.contains(curRectifyNdAdvertResInfo.ndAdvertResult.getAdvertId())) {
                curRectifyNdAdvertResInfo.ndAdvertResult.setAdjustFactor(1.0);
            } else {
                curRectifyNdAdvertResInfo.ndAdvertResult.setAdjustFactor(curFactor);
            }
            curRectifyNdAdvertResInfo.ndAdvertResult.setRankOfCurNdInCandis(idx + 1);
            res.add(curRectifyNdAdvertResInfo.ndAdvertResult);
        }
        return res;
    }

    public static Map<String, Object> getAdjustCVR(NdAdvertParams ndAdvertParams, NdAdvertV3Info ndAdvertInfo) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ndAdvertParams, ndAdvertInfo})) {
            return null;
        }
        Double preCvr = ndAdvertInfo.getPreCvr();
        Long hisClick = ndAdvertInfo.getHisClick();
        Long hisConvert = ndAdvertInfo.getHisConvert();
        Double staCvr = Optional.ofNullable(MathUtil.division((Long)hisConvert, (Long)hisClick, (int)6)).orElse(0.0);
        Long advTradeSlotDayClick = ndAdvertInfo.getAdvTradeSlotDayStats().getClick();
        Long advTradeAppDayClick = ndAdvertInfo.getAdvTradeAppDayStats().getClick();
        Long advTradeAppTradeDayClick = ndAdvertInfo.getAdvTradeAppTradeDayStats().getClick();
        Long advTradeSlotTriDayClick = ndAdvertInfo.getAdvTradeSlotTriDayStats().getClick();
        Long advTradeAppTriDayClick = ndAdvertInfo.getAdvTradeAppTriDayStats().getClick();
        Long advTradeAppTradeTriDayClick = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getClick();
        Long advTradeSlotDayConvert = ndAdvertInfo.getAdvTradeSlotDayStats().getConvert();
        Long advTradeAppDayConvert = ndAdvertInfo.getAdvTradeAppDayStats().getConvert();
        Long advTradeAppTradeDayConvert = ndAdvertInfo.getAdvTradeAppTradeDayStats().getConvert();
        Long advTradeSlotTriDayConvert = ndAdvertInfo.getAdvTradeSlotTriDayStats().getConvert();
        Long advTradeAppTriDayConvert = ndAdvertInfo.getAdvTradeAppTriDayStats().getConvert();
        Long advTradeAppTradeTriDayConvert = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getConvert();
        Double advTradeSlotDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeSlotDayConvert, (Long)advTradeSlotDayClick, (int)6)).orElse(0.0);
        Double advTradeAppDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppDayConvert, (Long)advTradeAppDayClick, (int)6)).orElse(0.0);
        Double advTradeAppTradeDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppTradeDayConvert, (Long)advTradeAppTradeDayClick, (int)6)).orElse(0.0);
        Double advTradeSlotTriDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeSlotTriDayConvert, (Long)advTradeSlotTriDayClick, (int)6)).orElse(0.0);
        Double advTradeAppTriDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppTriDayConvert, (Long)advTradeAppTriDayClick, (int)6)).orElse(0.0);
        Double advTradeAppTradeTriDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppTradeTriDayConvert, (Long)advTradeAppTradeTriDayClick, (int)6)).orElse(0.0);
        List<Long> clickList = Arrays.asList(advTradeSlotDayClick, advTradeAppDayClick, advTradeAppTradeDayClick, advTradeSlotTriDayClick, advTradeAppTriDayClick, advTradeAppTradeTriDayClick);
        List<Double> cvrList = Arrays.asList(advTradeSlotDayCvr, advTradeAppDayCvr, advTradeAppTradeDayCvr, advTradeSlotTriDayCvr, advTradeAppTriDayCvr, advTradeAppTradeTriDayCvr);
        double adjustWeight = 1.0;
        String paramType = "firstSet";
        paramType = Collections.max(cvrList) < ndAdvertParams.getMinDimStatsCvrThreshold() ? "secondSet" : "firstSet";
        HashMap<String, Object> AdjustWeightRes = NdAdvertSupportV3.getAdjustWeight(ndAdvertParams, clickList, cvrList, paramType, hisClick, staCvr);
        adjustWeight = (Double)AdjustWeightRes.get("adjustWeight");
        String curNdAdvertLevel = (String)AdjustWeightRes.get("curNdAdvertLevel");
        double adjustCvr = preCvr;
        if (hisClick >= (long)(paramType.equals("firstSet") ? ndAdvertParams.getSepStageThreshold() : ndAdvertParams.getSepStageThresholdSet2()).intValue() && staCvr >= Math.pow(10.0, -8.0)) {
            adjustWeight = 1.0;
        } else {
            adjustCvr *= adjustWeight;
        }
        res.put("adjustWeight", adjustWeight);
        res.put("adjustCvr", adjustCvr);
        res.put("paramType", paramType.equals("firstSet") ? 1.0 : 2.0);
        res.put("curNdAdvertLevel", curNdAdvertLevel);
        return res;
    }

    public static Double getMinDimsStatCvr(NdAdvertParams ndAdvertParams, List<Long> clickList, List<Double> cvrList, String paramType) {
        Double minDimsStatCvr = 0.0;
        if (clickList.get(clickList.size() - 1) <= (long)(paramType.equals("secondSet") ? ndAdvertParams.getClickConfidenceThresholdSet2() : ndAdvertParams.getClickConfidenceThreshold()).intValue()) {
            minDimsStatCvr = cvrList.get(clickList.size() - 1);
        } else {
            for (int index = 0; index < clickList.size(); ++index) {
                if (clickList.get(index) < (long)(paramType.equals("secondSet") ? ndAdvertParams.getClickConfidenceThresholdSet2() : ndAdvertParams.getClickConfidenceThreshold()).intValue()) continue;
                minDimsStatCvr = cvrList.get(index);
                break;
            }
        }
        return minDimsStatCvr;
    }

    public static HashMap<String, Object> getAdjustWeight(NdAdvertParams ndAdvertParams, List<Long> clickList, List<Double> cvrList, String paramType, Long hisClick, Double staCvr) {
        Integer coldStartThreshold3;
        Integer coldStartThreshold2;
        Integer coldStartThreshold1;
        Integer sepStageThreshold;
        HashMap<String, Object> res = new HashMap<String, Object>();
        double adjustWeight = 1.0;
        String curNdAdvertLevel = "level1";
        double minDimsStatCvr = NdAdvertSupportV3.getMinDimsStatCvr(ndAdvertParams, clickList, cvrList, paramType);
        if (paramType.equals("firstSet")) {
            sepStageThreshold = ndAdvertParams.getSepStageThreshold();
            coldStartThreshold1 = ndAdvertParams.getColdStartThreshold1();
            coldStartThreshold2 = ndAdvertParams.getColdStartThreshold2();
            coldStartThreshold3 = ndAdvertParams.getColdStartThreshold3();
        } else {
            sepStageThreshold = ndAdvertParams.getSepStageThresholdSet2();
            coldStartThreshold1 = ndAdvertParams.getColdStartThresholdSet4();
            coldStartThreshold2 = ndAdvertParams.getColdStartThresholdSet5();
            coldStartThreshold3 = ndAdvertParams.getColdStartThresholdSet6();
        }
        if (hisClick < (long)sepStageThreshold.intValue()) {
            boolean b;
            boolean bl = b = staCvr <= Math.pow(10.0, -8.0) || staCvr < 0.4 * minDimsStatCvr;
            if ((long)coldStartThreshold1.intValue() <= hisClick && hisClick < (long)coldStartThreshold2.intValue()) {
                adjustWeight = b ? 0.9 : 1.0;
                curNdAdvertLevel = "level2";
            } else if ((long)coldStartThreshold2.intValue() <= hisClick && hisClick < (long)coldStartThreshold3.intValue()) {
                adjustWeight = b ? 0.8 : (staCvr < 0.7 * minDimsStatCvr ? 0.9 : 1.0);
                curNdAdvertLevel = "level3";
            } else if (hisClick >= (long)coldStartThreshold3.intValue()) {
                adjustWeight = b ? 0.7 : (staCvr < 0.7 * minDimsStatCvr ? 0.8 : 1.0);
                curNdAdvertLevel = "level4";
            } else {
                adjustWeight = 1.0;
            }
        } else {
            adjustWeight = staCvr <= Math.pow(10.0, -8.0) ? 0.1 : 0.3 + 0.4 * Math.min(1.0, MathUtil.division((double)hisClick.longValue(), (int)2000, (int)6));
            curNdAdvertLevel = "level5";
        }
        res.put("adjustWeight", adjustWeight);
        res.put("curNdAdvertLevel", curNdAdvertLevel);
        return res;
    }

    public static double functionOfExpose(Long exposeCnt, NdAdvertParams ndAdvertParams, String paramType) {
        double res = 1.0;
        double k = 1.0;
        double b = 1.0;
        Integer exposeConfidenceThreshold = 600;
        if (paramType.equals("firstSet")) {
            k = ndAdvertParams.getExposureK1();
            b = ndAdvertParams.getExposureUpperBound1();
            exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThreshold2();
        } else {
            k = ndAdvertParams.getExposureK2();
            b = ndAdvertParams.getExposureUpperBound2();
            exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThresholdSet5();
        }
        if (exposeCnt <= (long)exposeConfidenceThreshold.intValue()) {
            res = k * (double)exposeCnt.longValue() + b;
        }
        return res;
    }

    public static List<Double> functionOfRectifyFac(int size, NdAdvertParams ndAdvertParams) {
        ArrayList<Double> res = new ArrayList<Double>();
        double weight = 1.0;
        double rankUpperBound = ndAdvertParams.getRankUpperBound();
        if (rankUpperBound <= 1.0) {
            for (int i = 0; i < size; ++i) {
                res.add(1.0);
            }
        } else {
            double inflectionPoint1 = rankUpperBound;
            double inflectionPoint2 = 0.4 * rankUpperBound + 0.6;
            Map<String, Double> KBMap1 = NdAdvertSupportV3.calculateKAndB(0, (int)(0.1 * (double)size), inflectionPoint1, inflectionPoint2);
            Map<String, Double> KBMap2 = NdAdvertSupportV3.calculateKAndB((int)(0.1 * (double)size), (int)(0.2 * (double)size), inflectionPoint2, 1.0);
            double k1 = KBMap1.get("K");
            double k2 = KBMap2.get("K");
            double b1 = KBMap1.get("B");
            double b2 = KBMap1.get("B");
            for (int i = 0; i < size; ++i) {
                weight = i <= (int)(0.1 * (double)size) ? k1 * (double)i + b1 : ((int)(0.1 * (double)size) < i && i <= (int)(0.2 * (double)size) ? k2 * (double)i + b2 : 1.0);
                weight = (double)Math.round(weight * 1000000.0) / 1000000.0;
                res.add(Math.max(weight, 1.0));
            }
        }
        return res;
    }

    private static Map<String, Double> calculateKAndB(int x0, int x1, double y0, double y1) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        double k = MathUtil.division((double)(y1 - y0), (int)(x1 - x0), (int)6);
        double b = y0 - k * (double)x0;
        res.put("K", k);
        res.put("B", b);
        return res;
    }

    private static NdAdvertResultV3Do fillData(NdAdvertV3Info ndAdvertInfo, double adjustFactor, double ctrRectifyFactor, double cvrRectifyFactor, double rectifyCtr, double rectifyCvr, double exposureFactor, int numOfBidNd, int rankOfCurNdInCandis, String curNdAdvertLevel) {
        NdAdvertResultV3Do ndAdvertRes = new NdAdvertResultV3Do();
        ndAdvertRes.setAdvertId(ndAdvertInfo.getAdvertId());
        ndAdvertRes.setPlanId(ndAdvertInfo.getPlanId());
        ndAdvertRes.setSlotId(ndAdvertInfo.getSlotId());
        ndAdvertRes.setAppId(ndAdvertInfo.getAppId());
        ndAdvertRes.setAdvertType(ndAdvertInfo.getAdvertType());
        ndAdvertRes.setAdjustFactor(adjustFactor);
        ndAdvertRes.setCtrRectifyFactor(ctrRectifyFactor);
        ndAdvertRes.setCvrRectifyFactor(cvrRectifyFactor);
        ndAdvertRes.setRectifyCtr(rectifyCtr);
        ndAdvertRes.setRectifyCvr(rectifyCvr);
        ndAdvertRes.setExposureFactor(exposureFactor);
        ndAdvertRes.setNumOfBidNd(numOfBidNd);
        ndAdvertRes.setRankOfCurNdInCandis(rankOfCurNdInCandis);
        ndAdvertRes.setLevel(curNdAdvertLevel);
        return ndAdvertRes;
    }

    static class RectifyNdAdvertResInfo {
        double rectifyBid = 0.0;
        NdAdvertResultV3Do ndAdvertResult;

        RectifyNdAdvertResInfo() {
        }
    }
}

