package cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter;


import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 实时统计指标
 */
@Data
public class AdxIndexStatDo implements Serializable {

    private static final long serialVersionUID = 4481088624505592801L;

    /**
     * 竞价返回量级
     */
    private Long bid;

    /**
     * 竞价成功量级
     */
    private Long bidSuc;

    /**
     * 曝光量级
     */
    private Long exp;

    /**
     * 点击量级
     */
    private Long click;

    /**
     * adx消耗(分*10^4/cpm)
     */
    private Long adxConsume;

    /**
     * 广告消耗(分)
     */
    private Long advertConsume;

    /**
     * 广告发券数
     */
    private Long advertLaunch;

    /**
     * 活动访问次数
     */
    private Long activityRequest;

    /**
     * 活动参与次数
     */
    private Long activiyJoin;

    /**
     * 广告曝光次数
     */
    private Long advertExposure;

    /**
     * 广告计费点击数
     */
    private Long advertClick;

    /**
     * 预估点击价值总和
     */
    private Double preClickValue;

    public static Double getStatCtr(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if(adxIndexStatDo != null && adxIndexStatDo.getExp() != null && adxIndexStatDo.getExp() > 1000) {
            ret = DataUtil.division(adxIndexStatDo.getClick(), adxIndexStatDo.getExp(), 3);
        }
        return ret;
    }

    public static Double getStatLaunchPv(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if(adxIndexStatDo != null && adxIndexStatDo.getClick() != null && adxIndexStatDo.getClick() > 100) {
            ret = DataUtil.division(adxIndexStatDo.getAdvertLaunch(), adxIndexStatDo.getClick(), 3);
        }
        return ret;
    }
}
