package cn.com.duiba.nezha.alg.alg.vo.adx.rtb2;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class AdxFactorDo {

    /**
     * 创意 维稳参数
     */
    Map<Long, AdxFactorSubDo> ideaFactorSubDoMap = new HashMap<>();

    /**
     * 资源位 维稳参数
     */
    Map<Long, AdxFactorSubDo> resFactorSubDoMap = new HashMap<>();


    /**
     * 获取维稳参数: 0-创意维度、1-资源位维度
     * @param id
     * @return
     */
    public AdxFactorSubDo getFactorSubDo(Long id, int type) {
        AdxFactorSubDo ret = new AdxFactorSubDo();
        Map<Long, AdxFactorSubDo> factorSubDoMap = type == 0 ? ideaFactorSubDoMap : resFactorSubDoMap;
        if(factorSubDoMap != null && factorSubDoMap.get(id) != null) {
            ret = factorSubDoMap.get(id);
        }
        return ret;
    }

    /**
     * 更新维稳参数：0-创意维度、1-资源位维度
     * @param id
     * @param adxFactorSubDo
     */
    public void putFactorSubDo(Long id, AdxFactorSubDo adxFactorSubDo, int type) {
        if(AssertUtil.isAllNotEmpty(id, adxFactorSubDo)) {
            if(type == 0) {
                ideaFactorSubDoMap.put(id, adxFactorSubDo);
            }else{
                resFactorSubDoMap.put(id, adxFactorSubDo);
            }
        }
    }

    public AdxFactorBaseDo getFactorBaseDo(Long ideaId, String appId, int type) {
        AdxFactorBaseDo adxFactorBaseDo = new AdxFactorBaseDo();

        if(AssertUtil.isAllEmpty(ideaId, appId)) {
            return adxFactorBaseDo;
        }

        AdxFactorSubDo factorSubDo = getFactorSubDo(ideaId, type);

        //app维度
        AdxFactorBaseDo factorBaseDo = factorSubDo.getAppFactor(appId);

        //创意、资源位维度
        if(!factorBaseDo.isConfidence()) {
            factorBaseDo = factorSubDo.getFactorBaseDo();
        }

        adxFactorBaseDo = factorBaseDo;

        return adxFactorBaseDo;

    }

    public AdxFactorBaseDo getFactorBaseDo(Long resId, Long ideaId, String appId) {

        AdxFactorBaseDo adxFactorBaseDo = getFactorBaseDo(ideaId, appId, 0);

        if(!adxFactorBaseDo.isConfidence()) {
            adxFactorBaseDo = getFactorBaseDo(resId, appId, 1);
        }
        return adxFactorBaseDo;
    }

}
