package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

@Data
public class Model {
    private static final Logger logger = LoggerFactory.getLogger(Model.class);

    private IModel ctrModel;
    private IModel launchPvCoder;
    private IModel ARPUCoder;
    private LocalTFModel launchPvTFModel;  // launchPvCoder对应的TF model
    private LocalTFModel arpuTFModel;   // ARPUCoder对应的TF model
    private LocalTFModel localTFModel;

    public Map<FeatureIndex, Double> predictCtr(Map<FeatureIndex, FeatureMapDo> featureMap) throws Exception {
        try {
            Map<FeatureIndex, Double> ret;
            ret = ctrModel.predictsNew(featureMap);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictCtr featureMap{} error{} ctrModel{}", featureMap, e, ctrModel);
        }
        return null;
    }

    public Map<FeatureIndex, Double> predictLaunchPv(Map<FeatureIndex, FeatureMapDo> featureMap) throws Exception {
        try {
            Map<FeatureIndex, Double> ret;
//        logger.info("featureMap{}, launchPvTFModel{}", JSONObject.toJSON(featureMap), JSONObject.toJSON(launchPvTFModel));
            ret = launchPvCoder.predictWithLocalTFNew(featureMap, launchPvTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictLaunchPv featureMap{}, error{}, launchPvCoder{}, launchPvTFModel{}", featureMap, e, launchPvCoder, launchPvTFModel);
        }
        return null;
    }

    public Map<FeatureIndex, Double> predictARPU(Map<FeatureIndex, FeatureMapDo> featureMap) throws Exception {
        try {
            Map<FeatureIndex, Double> ret;
            ret = ARPUCoder.predictWithLocalTFNew(featureMap, arpuTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictARPU featureMap{}, error{}, ARPUCoder{}, arpuTFModel{}", featureMap, e, ARPUCoder, arpuTFModel);
        }
        return null;
    }


}
