package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Data
public class OcpxControlModel {


    /**
     * 配置数据 常规模式
     * <p>
     * Map<广告ID，Map<配置ID，参数>>
     */
    Map<Long, Map<Long, OcpxControlSubModel>> ocpxControlSubModelMap = new HashMap<>();


    /**
     * 广告数据 冷启动使用
     * <p>
     * Map<广告ID，参数>>
     */
    Map<Long, AdControlParams> adControlParamsMap = new HashMap<>();


    /**
     * 广告数据 冷启动数据
     * <p>
     * Map<广告ID，Map<广告位ID，参数>>
     */
    Map<Long, Map<Long, AdControlParams>> adSlotControlParamsHashMap = new HashMap<>();


    /**
     * 广告位 数据 冷启动使用
     * <p>
     * <p>
     * Map<广告位ID，参数>
     */

    Map<Long, SlotControlParams> slotControlParamsMap = new HashMap<>();



    String updateTime;




    public OcpxControlSubModel getOcpxControlSubModel(Long adId, Long pkId) {

        if (!ocpxControlSubModelMap.containsKey(adId)) {
            ocpxControlSubModelMap.put(adId, new HashMap<>());
        }


        if (ocpxControlSubModelMap.get(adId).get(pkId) == null) {
            ocpxControlSubModelMap.get(adId).put(pkId, new OcpxControlSubModel());
        }


        return ocpxControlSubModelMap.get(adId).get(pkId);
    }

    public void putOcpxControlSubModel(Long adId, Long pkId, OcpxControlSubModel ocpxControlSubModel) {

        if (!ocpxControlSubModelMap.containsKey(adId)) {
            ocpxControlSubModelMap.put(adId, new HashMap<>());
        }
        ocpxControlSubModelMap.get(adId).put(pkId, ocpxControlSubModel);

    }


    /**
     * 广告参数
     *
     * @param adId
     * @return
     */
    public AdControlParams getAdSlotControlParams(Long adId, Long slotId) {


        if (!adSlotControlParamsHashMap.containsKey(adId)) {
            adSlotControlParamsHashMap.put(adId, new HashMap<>());
        }

        if (adSlotControlParamsHashMap.get(adId).get(slotId) == null) {
            adSlotControlParamsHashMap.get(adId).put(slotId, new AdControlParams());
        }

        return adSlotControlParamsHashMap.get(adId).get(slotId);
    }


    /**
     * 广告参数
     *
     * @param adId
     * @return
     */
    public void putAdSlotControlParams(Long adId, Long slotId, AdControlParams adControlParams) {


        if (!adSlotControlParamsHashMap.containsKey(adId)) {
            adSlotControlParamsHashMap.put(adId, new HashMap<>());
        }

        adSlotControlParamsHashMap.get(adId).put(slotId, adControlParams);
    }


    /**
     * 广告参数
     *
     * @param adId
     * @return
     */
    public AdControlParams getAdControlParams(Long adId) {


        if (adControlParamsMap.get(adId) == null) {
            adControlParamsMap.put(adId, new AdControlParams());
        }

        return adControlParamsMap.get(adId);
    }


    /**
     * 广告参数
     *
     * @param adId
     * @return
     */
    public void putAdControlParams(Long adId, AdControlParams adControlParams) {

        adControlParamsMap.put(adId, adControlParams);
    }

    /**
     * 广告位参数
     *
     * @param slotId
     * @return
     */
    public SlotControlParams getSlotControlParams(Long slotId) {

        if (slotControlParamsMap.get(slotId) == null) {
            slotControlParamsMap.put(slotId, new SlotControlParams());
        }
        return slotControlParamsMap.get(slotId);
    }

    /**
     * 广告位参数
     *
     * @param slotId
     * @return
     */
    public void putSlotControlParams(Long slotId, SlotControlParams slotControlParams) {

        slotControlParamsMap.put(slotId, slotControlParams);
    }
}
