package cn.com.duiba.nezha.alg.api.facade.recall;

import cn.com.duiba.nezha.alg.api.dto.base.BaseAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.base.BaseRequestDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.facade.AbstractTemplateFacade;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

/**
 * 召回通道接口抽象类实现
 * @author lijicong
 * @since 2021-08-18
 */
@Slf4j
public abstract class AbstractRecallChanelFacade<Advert extends BaseAdvertDTO, Request extends BaseRequestDTO>
        extends AbstractTemplateFacade<Advert, Request, RecallChannelResult>
        implements RecallChannelFacade<Advert, Request> {

    @Override
    public RecallChannelResult execute(Advert advert, Request request) {
        try {
            return doRecall(advert, request);
        } catch (Exception e) {
            log.warn("调用召回通道异常 type={}, advert={}, request={}", getType(), JSON.toJSONString(advert), JSON.toJSONString(request), e);
        }
        return null;
    }

    /**
     * 召回通道具体实现
     * @param advert
     * @param request
     * @return 返回结果中的key拼劲规则：advert_id+*
     */
    protected RecallChannelResult doRecall(Advert advert, Request request) {
        return null;
    }
}
