package cn.com.duiba.nezha.alg.api.facade.recall.channel;

import cn.com.duiba.nezha.alg.api.dto.recall.HeatAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.HeatRequest;
import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.enums.RecallEnums.RecallChannelType;
import cn.com.duiba.nezha.alg.api.facade.recall.AbstractRecallChanelFacade;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * 热度召回
 * @author lijicong
 * @since 2021-08-18
 */
@Slf4j
public class HeatRecallChannelFacadeImpl extends AbstractRecallChanelFacade<HeatAdvertDTO, HeatRequest>
        implements HeatRecallChannelFacade {

    @Override
    public RecallChannelType getType() {
        return RecallChannelType.Heat;
    }

    @Override
    public Map<String, RecallChannelResult> execute(Map<String, HeatAdvertDTO> adverts, HeatRequest heatRequest) {
        return super.execute(adverts, heatRequest);
    }
}
