/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDircetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecrtlyPriceReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorSubDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxDirectlyBidding {
    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyBidding.class);

    public static List<AdxDirecetlyPriceDo> getAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        List<Object> ret = new ArrayList();
        ret = adxDirecrtlyPriceReqDo != null && adxDirecrtlyPriceReqDo.getBillType() != null && adxDirecrtlyPriceReqDo.getBillType().equals(1) ? AdxDirectlyBidding.getCpmAlgoPrice(adxDirecrtlyPriceReqDo) : AdxDirectlyBidding.getCpcAlgoPrice(adxDirecrtlyPriceReqDo);
        return ret;
    }

    public static List<AdxDirecetlyPriceDo> getCpmAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        ArrayList<AdxDirecetlyPriceDo> ret = new ArrayList<AdxDirecetlyPriceDo>();
        List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = (adxDirecrtlyPriceReqDo = Optional.ofNullable(adxDirecrtlyPriceReqDo).orElse(new AdxDirecrtlyPriceReqDo())).getAdxDirecetlyPriceDos();
        if (adxDirecetlyPriceDos == null || adxDirecetlyPriceDos.size() < 1) {
            logger.warn("MeiTuan getCpmAlgoPrice: the list of adxDirecetlyPriceDos is empty");
            return ret;
        }
        Double slotShareRate = AdxDirecrtlyPriceReqDo.getShareRate(adxDirecrtlyPriceReqDo);
        slotShareRate = Optional.ofNullable(slotShareRate).orElse(1.0);
        AdxMeiTuanFactorDo adxMeiTuanFactorDo = Optional.ofNullable(adxDirecrtlyPriceReqDo.getAdxMeiTuanFactorDo()).orElse(new AdxMeiTuanFactorDo());
        AdxMeiTuanFactorSubDo slotFactorDo = adxMeiTuanFactorDo.getSlotFactorDo();
        Double slotFactor = Optional.ofNullable(slotFactorDo.getRoiFactor()).orElse(1.0);
        for (AdxDirecetlyPriceDo adxDirecetlyPriceDo : adxDirecetlyPriceDos) {
            Double advPrice = adxDirecetlyPriceDo.getAdvPrice();
            Double advCtr = adxDirecetlyPriceDo.getCtr();
            if (advPrice == null || advPrice <= 0.0 || advCtr == null || advCtr <= 0.0) continue;
            Double advShareRate = AdxDirecetlyPriceDo.getShareRate(adxDirecetlyPriceDo);
            if (advShareRate == null || advShareRate < 0.0) {
                advShareRate = slotShareRate;
            }
            Long advertId = adxDirecetlyPriceDo.getAdvertId();
            AdxMeiTuanFactorSubDo advFactorDo = Optional.ofNullable(AdxMeiTuanFactorDo.getAdvFactorSubDo(adxMeiTuanFactorDo, advertId)).orElse(new AdxMeiTuanFactorSubDo());
            Double advFactor = advFactorDo.getRoiFactor();
            if (!advFactorDo.isConfident()) {
                advFactor = slotFactor;
            }
            double price = advPrice * advCtr * advShareRate * advFactor;
            adxDirecetlyPriceDo.setAdxPrice(price);
            adxDirecetlyPriceDo.setRoiFactor(advFactor);
            ret.add(adxDirecetlyPriceDo);
        }
        return ret;
    }

    public static List<AdxDirecetlyPriceDo> getCpcAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        Double sucFactor;
        ArrayList<AdxDirecetlyPriceDo> ret = new ArrayList();
        ArrayList lowPriceAdv = new ArrayList();
        Double priceThreshold = 80.0;
        Integer groupTag = adxDirecrtlyPriceReqDo.getGroupTag();
        if (groupTag == null) {
            logger.error("adxDirecrtlyPriceReqDo groupTag is null");
            groupTag = 0;
        }
        Double floorPrice = Optional.ofNullable(adxDirecrtlyPriceReqDo.getFloorPrice()).orElse(0.0);
        Integer advertCnt = adxDirecrtlyPriceReqDo.getAdvertCnt();
        Double slotShareRate = AdxDirecrtlyPriceReqDo.getShareRate(adxDirecrtlyPriceReqDo);
        if (slotShareRate == null) {
            slotShareRate = 1.0;
        }
        List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = adxDirecrtlyPriceReqDo.getAdxDirecetlyPriceDos();
        AdxMeiTuanFactorDo adxMeiTuanFactorDo = Optional.ofNullable(adxDirecrtlyPriceReqDo.getAdxMeiTuanFactorDo()).orElse(new AdxMeiTuanFactorDo());
        AdxMeiTuanFactorSubDo slotFactorDo = adxMeiTuanFactorDo.getSlotFactorDo();
        Double slotFactor = slotFactorDo.getRoiFactor();
        if (slotFactor == null) {
            slotFactor = 1.0;
        }
        if ((sucFactor = slotFactorDo.getSucFactor()) == null) {
            sucFactor = 0.0;
        }
        AdxMeiTuanFactorSubDo advFactorDo = new AdxMeiTuanFactorSubDo();
        Double advFactor = 1.0;
        Double adAvgPrice = 30.0;
        Double advShareRate = null;
        if (advertCnt == null) {
            advertCnt = 5;
        }
        Long reqCnt = adxDirecrtlyPriceReqDo.getReqCnt();
        Long reqThreshold = adxDirecrtlyPriceReqDo.getReqThreshold();
        if (reqThreshold == null) {
            reqThreshold = 1L;
        }
        for (AdxDirecetlyPriceDo adxDirecetlyPriceDo : adxDirecetlyPriceDos) {
            double price;
            Long advertId = adxDirecetlyPriceDo.getAdvertId();
            advShareRate = AdxDirecetlyPriceDo.getShareRate(adxDirecetlyPriceDo);
            Double advPrice = adxDirecetlyPriceDo.getAdvPrice();
            if (advPrice == null) continue;
            advFactorDo = AdxMeiTuanFactorDo.getAdvFactorSubDo(adxMeiTuanFactorDo, advertId);
            if (advFactorDo != null) {
                advFactor = advFactorDo.getRoiFactor();
                adAvgPrice = advFactorDo.getCpcPrice();
            }
            if (advShareRate == null || advShareRate < 0.0) {
                advShareRate = slotShareRate;
            }
            if (advFactorDo == null || !advFactorDo.isConfident()) {
                advFactor = slotFactor;
            }
            if (advFactor == null) {
                advFactor = 1.0;
            }
            if (adAvgPrice == null) {
                adAvgPrice = 40.0;
            }
            if ((price = advPrice * advShareRate * advFactor) <= priceThreshold && sucFactor > 0.1) {
                double priceLimit = price * 1.25;
                price += (priceThreshold - price) * sucFactor;
                price = Math.min(price, priceLimit);
            }
            double minPrice = advPrice * advShareRate * 0.75;
            double maxPrice = Math.max(advPrice * advShareRate * (advShareRate + 0.5), advPrice);
            if (price < (adAvgPrice = Double.valueOf(MathUtil.stdwithBoundary((double)adAvgPrice, (double)40.0, (double)80.0)))) {
                price += (adAvgPrice - price) * (advFactor - 0.75);
            }
            if (reqCnt != null && reqCnt < reqThreshold && price < priceThreshold) {
                price += (priceThreshold - price) * (advFactor - 0.75);
            }
            price = MathUtil.stdwithBoundary((double)price, (double)minPrice, (double)maxPrice);
            if (reqCnt != null && reqCnt >= 2L && reqCnt <= 4L) {
                double liftFactor = AdxDirecrtlyPriceReqDo.getLiftFactor1(adxDirecrtlyPriceReqDo);
                double realFloorPrice = AdxDirecrtlyPriceReqDo.getRealFloorPrice1(adxDirecrtlyPriceReqDo);
                if (groupTag == 1) {
                    if (price > 0.31) {
                        if ((price *= liftFactor) < 0.31) {
                            price = 0.31;
                        }
                        adxDirecetlyPriceDo.setLiftFactor(liftFactor);
                        logger.info("groupTag{}, liftFactor{}, liftPrice{}, reqCnt{}", new Object[]{groupTag, liftFactor, price, reqCnt});
                    }
                } else if (groupTag == 2) {
                    if (price > realFloorPrice && price < 0.31) {
                        price = 0.31;
                        adxDirecetlyPriceDo.setRealFloorPrice(realFloorPrice);
                        logger.info("groupTag{}, realFloor{}, price{}, reqCnt{}", new Object[]{groupTag, realFloorPrice, price, reqCnt});
                    }
                } else if (groupTag == 3) {
                    if (price > 0.31) {
                        if ((price *= liftFactor) < 0.31) {
                            price = 0.31;
                        }
                        adxDirecetlyPriceDo.setLiftFactor(liftFactor);
                        logger.info("groupTag{}, liftFactor{}, liftPrice{}, reqCnt{}", new Object[]{groupTag, liftFactor, price, reqCnt});
                    } else if (price > realFloorPrice && price < 0.31) {
                        price = 0.31;
                        adxDirecetlyPriceDo.setRealFloorPrice(realFloorPrice);
                        logger.info("groupTag{}, realFloor{}, price{}, reqCnt{}", new Object[]{groupTag, realFloorPrice, price, reqCnt});
                    }
                }
            }
            if (price < floorPrice) {
                logger.info("MeiTuan floorPrice Filter, advertId:{},price:{}", (Object)advertId, (Object)price);
                continue;
            }
            adxDirecetlyPriceDo.setAdxPrice(price);
            adxDirecetlyPriceDo.setRoiFactor(advFactor);
            ret.add(adxDirecetlyPriceDo);
        }
        List reRankRet = ret.stream().sorted(Comparator.comparing(AdxDirecetlyPriceDo::getRankScore).reversed()).collect(Collectors.toList());
        advertCnt = Math.min(advertCnt, reRankRet.size());
        ret = reRankRet.subList(0, advertCnt);
        return ret;
    }

    public static AdxDircetlyPriceDo getAlgoPrice(AdxDirectlyIdeaDo directlyIdeaInfo, AdxDirectlyFactorDo directlyFactorInfo) {
        AdxDircetlyPriceDo ret = new AdxDircetlyPriceDo();
        try {
            Double roiFactor = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Long algoPrice = 0L;
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_TWO.getCode();
            Long ideaBidCntMs = 0L;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{directlyIdeaInfo})) {
                AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(directlyIdeaInfo.getIdeaIndexMap());
                ideaBidCntMs = AdxStatData.nullToMinDefault(interIndexStatMs.getBidCnt(), 0L);
            }
            if (AssertUtil.isNotEmpty((Object)directlyFactorInfo) && ideaBidCntMs != 0L) {
                Map<String, Double> factorMap = directlyFactorInfo.getFactorExploreMap();
                Map<String, Double> FlowRateMap = directlyFactorInfo.getFactorFlowRateMap();
                Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, factorMap, 1.0);
                level = result.get("level");
                roiFactor = AdxStatData.getNormalValue(DataUtil.string2Double((String)result.get("factor")), 1.0, lowerLimit, upperLimit);
            }
            if (AssertUtil.isNotEmpty((Object)directlyIdeaInfo)) {
                Double minRoi = AdxStatData.nullToMinDefault(directlyIdeaInfo.getMinRoi(), 1.0);
                Double cpcPrice = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyCpcPrice(), 0.0);
                Double preCtr = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyPreCtr(), 0.0);
                algoPrice = Math.round(Math.floor(DataUtil.division((Double)(cpcPrice * preCtr * 1000.0), (Double)(minRoi * roiFactor))));
            }
            ret.setAdxAlgoPrice(algoPrice);
            ret.setStrategy(strategy);
            ret.setLevel(level);
        }
        catch (Exception e) {
            logger.error("AdxDirectlyBidding.getAlgoPrice error:" + e);
        }
        return ret;
    }
}

