/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.api.facade.recall.channel;

import cn.com.duiba.nezha.alg.api.dto.base.BaseResult;
import cn.com.duiba.nezha.alg.api.dto.recall.RandomAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.RandomRequest;
import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.enums.RecallEnums;
import cn.com.duiba.nezha.alg.api.facade.recall.AbstractRecallChanelFacade;
import cn.com.duiba.nezha.alg.api.facade.recall.channel.RandomRecallChannelFacade;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class RandomRecallChannelFacadeImpl
extends AbstractRecallChanelFacade<RandomAdvertDTO, RandomRequest>
implements RandomRecallChannelFacade {
    public RecallEnums.RecallChannelType getType() {
        return RecallEnums.RecallChannelType.Random;
    }

    @Override
    public Map<String, RecallChannelResult> execute(Map<String, RandomAdvertDTO> adverts, RandomRequest randomRequest) {
        if (MapUtils.isEmpty(adverts)) {
            return Collections.emptyMap();
        }
        List advertIds = randomRequest.getAdvertIds();
        Integer nums = randomRequest.getNum().getOrDefault("0", 5);
        if (CollectionUtils.isNotEmpty((Collection)advertIds) && nums != null && nums > 0) {
            List retained = adverts.values().stream().filter(pkg -> pkg != null && advertIds.contains(pkg.getAdvertId())).collect(Collectors.toList());
            int max = Math.max(retained.size(), nums);
            int random = ThreadLocalRandom.current().nextInt(max);
            return retained.stream().limit(random).map(this::newResult).collect(Collectors.toMap(BaseResult::buildKey, e -> e));
        }
        return Collections.emptyMap();
    }
}

