/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.dpa;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonInterval;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.DPAActFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.CandidateActivityDo;
import cn.com.duiba.nezha.alg.feature.vo.DPAActFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActRcmder.class);
    static double[] pCpmBucket = new double[]{0.4, 0.6, 0.85, 0.95, 0.99, 1.0};
    static double[] pCpmWeight = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 85.0};

    public static Map<String, String> featureParse(DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) {
        Map DPAFeatureMap = DPAActFeatureParse.generateFeatureMapStatic((DPAActFeatureDo)dpa);
        Map DPADynamicFeatureMap = DPAActFeatureParse.generateFeatureMapDynamic((DPAActFeatureDo)dpa);
        Map slotActFeatureMap = DPAActFeatureParse.generateFeatureMapSlotAct((SlotActFeature)slotActFeature);
        Map userProfileFeatureMap = DPAActFeatureParse.generateFeatureMapUserProfile((UserProfileFeature)userProfileFeature);
        Map featureMap = DPAActFeatureParse.generateFeatureMapBase((FeatureDo)featureDo);
        Map userActFeatureMap = DPAActFeatureParse.generateFeatureMapUserAct((UserActFeature)userActFeature);
        DPAFeatureMap.putAll(DPADynamicFeatureMap);
        DPAFeatureMap.putAll(slotActFeatureMap);
        DPAFeatureMap.putAll(userProfileFeatureMap);
        DPAFeatureMap.putAll(featureMap);
        DPAFeatureMap.putAll(userActFeatureMap);
        return DPAFeatureMap;
    }

    public static List<ActRcmdDo> recRank(CODER coderModel, LocalTFModel ltfModel, List<CandidateActivityDo> candidateActivityDos, List<ActivityMatchInfo> activityMatchInfos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        List<ActRcmdDo> rets = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{candidateActivityDos, dpa})) {
            logger.error("Actcmder recRank input params is null");
            return rets;
        }
        Map<String, String> staticFeatureMap = ActRcmder.featureParse(dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        for (ActivityMatchInfo activityMatchInfo : activityMatchInfos) {
            CandidateActivityDo candidateActivityDo = new CandidateActivityDo();
            candidateActivityDo.setActivityId(Long.valueOf(activityMatchInfo.getActivityId()));
            double matchScore = ActRcmder.getMatchScore(activityMatchInfo);
            candidateActivityDo.setActivityMatchScore(Double.valueOf(matchScore));
            candidateActivityDo.setActPackageType(Integer.valueOf(0));
            candidateActivityDos.add(candidateActivityDo);
        }
        HashMap<CandidateActivityDo, FeatureMapDo> featureDoMap = new HashMap<CandidateActivityDo, FeatureMapDo>();
        HashMap<CandidateActivityDo, ActRcmdDo> retMap = new HashMap<CandidateActivityDo, ActRcmdDo>();
        for (CandidateActivityDo candidateActivityDo : candidateActivityDos) {
            ActRcmdDo actRcmdDo = new ActRcmdDo();
            actRcmdDo.setCandidateActivityDo(candidateActivityDo);
            actRcmdDo.setActPackageType(candidateActivityDo.getActPackageType());
            actRcmdDo.setAppId(dpa.getAppId());
            actRcmdDo.setSlotId(dpa.getSlotId());
            actRcmdDo.setRid(dpa.getRid());
            actRcmdDo.setDeviceId(dpa.getDeviceId());
            actRcmdDo.setImei(dpa.getImei());
            actRcmdDo.setUa(dpa.getUa());
            actRcmdDo.setAreaCode(dpa.getAreaCode());
            actRcmdDo.setPriceSection(dpa.getPriceSection());
            DPAActFeatureDo dpaActFeatureDo = new DPAActFeatureDo();
            dpaActFeatureDo.setCandidateActivityDo(candidateActivityDo);
            Map dynamicFeatureMap = DPAActFeatureParse.generateFeatureMapDynamic((DPAActFeatureDo)dpaActFeatureDo);
            HashMap<String, String> retFeatureMap = new HashMap<String, String>();
            retFeatureMap.putAll(staticFeatureMap);
            retFeatureMap.putAll(dynamicFeatureMap);
            actRcmdDo.setFeatureMap(retFeatureMap);
            retMap.put(candidateActivityDo, actRcmdDo);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(candidateActivityDo, featureMapDo);
        }
        Map pRpmMap = new HashMap();
        if (ActRcmder.validModel(coderModel, ltfModel).booleanValue()) {
            pRpmMap = coderModel.predictWithLocalTFNew(featureDoMap, ltfModel);
        }
        HashMap featureMap = new HashMap();
        for (Map.Entry pRmp : pRpmMap.entrySet()) {
            CandidateActivityDo candidateActivityDo = (CandidateActivityDo)pRmp.getKey();
            Double pcpm = (Double)pRmp.getValue();
            ActRcmdDo actRcmdDo = (ActRcmdDo)retMap.get(candidateActivityDo);
            actRcmdDo.setpCpm(pcpm);
            retMap.put(candidateActivityDo, actRcmdDo);
        }
        rets = retMap.values().stream().filter(e -> e.getpCpm() != null).sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed()).collect(Collectors.toList());
        return rets;
    }

    public static ActRcmdDo recEE(CODER coderModel, LocalTFModel ltfModel, List<CandidateActivityDo> candidateActivityDos, List<ActivityMatchInfo> activityMatchInfos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = ActRcmder.recRank(coderModel, ltfModel, candidateActivityDos, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.error("Actcmder recEE input params is null");
            return ret;
        }
        List<ActRcmdDo> packages = rets.stream().filter(e -> e.getActPackageType() == 0).collect(Collectors.toList());
        List<ActRcmdDo> acts = rets.stream().filter(e -> e.getActPackageType() == 1).collect(Collectors.toList());
        ret = packages != null && Math.random() < 0.2 ? ActRcmder.ActRoulette(packages) : (acts != null ? ActRcmder.ActRoulette(acts) : ActRcmder.ActRoulette(rets));
        return ret;
    }

    public static ActRcmdDo recSort(CODER coderModel, LocalTFModel ltfModel, List<CandidateActivityDo> candidateActivityDos, List<ActivityMatchInfo> activityMatchInfos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        return ActRcmder.recEE(coderModel, ltfModel, candidateActivityDos, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    public static List<ActRcmdDo> recRank(CODER coderModel, LocalTFModel ltfModel, List<ActivityMatchInfo> activityMatchInfos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        List<ActRcmdDo> rets = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{dpa})) {
            logger.error("Actcmder recRank common input params is null");
            return rets;
        }
        ArrayList<Object> candidateActivityDos = new ArrayList<Object>();
        Map<String, String> staticFeatureMap = ActRcmder.featureParse(dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        for (ActivityMatchInfo activityMatchInfo : activityMatchInfos) {
            CandidateActivityDo candidateActivityDo = new CandidateActivityDo();
            candidateActivityDo.setActivityId(Long.valueOf(activityMatchInfo.getActivityId()));
            double d = ActRcmder.getMatchScore(activityMatchInfo);
            candidateActivityDo.setActivityMatchScore(Double.valueOf(d));
            candidateActivityDo.setActPackageType(Integer.valueOf(0));
            candidateActivityDos.add(candidateActivityDo);
        }
        HashMap<CandidateActivityDo, FeatureMapDo> featureDoMap = new HashMap<CandidateActivityDo, FeatureMapDo>();
        HashMap<CandidateActivityDo, ActRcmdDo> retMap = new HashMap<CandidateActivityDo, ActRcmdDo>();
        for (CandidateActivityDo candidateActivityDo : candidateActivityDos) {
            ActRcmdDo actRcmdDo = new ActRcmdDo();
            actRcmdDo.setCandidateActivityDo(candidateActivityDo);
            actRcmdDo.setActPackageType(candidateActivityDo.getActPackageType());
            actRcmdDo.setAppId(dpa.getAppId());
            actRcmdDo.setSlotId(dpa.getSlotId());
            actRcmdDo.setRid(dpa.getRid());
            actRcmdDo.setDeviceId(dpa.getDeviceId());
            actRcmdDo.setImei(dpa.getImei());
            actRcmdDo.setUa(dpa.getUa());
            actRcmdDo.setAreaCode(dpa.getAreaCode());
            actRcmdDo.setPriceSection(dpa.getPriceSection());
            DPAActFeatureDo dpaActFeatureDo = new DPAActFeatureDo();
            dpaActFeatureDo.setCandidateActivityDo(candidateActivityDo);
            Map dynamicFeatureMap = DPAActFeatureParse.generateFeatureMapDynamic((DPAActFeatureDo)dpaActFeatureDo);
            HashMap<String, String> retFeatureMap = new HashMap<String, String>();
            retFeatureMap.putAll(staticFeatureMap);
            retFeatureMap.putAll(dynamicFeatureMap);
            actRcmdDo.setFeatureMap(retFeatureMap);
            retMap.put(candidateActivityDo, actRcmdDo);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(candidateActivityDo, featureMapDo);
        }
        Map pRpmMap = new HashMap();
        if (ActRcmder.validModel(coderModel, ltfModel).booleanValue()) {
            pRpmMap = coderModel.predictWithLocalTFNew(featureDoMap, ltfModel);
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry pRmp : pRpmMap.entrySet()) {
            CandidateActivityDo candidateActivityDo = (CandidateActivityDo)pRmp.getKey();
            Double pcpm = (Double)pRmp.getValue();
            ActRcmdDo actRcmdDo = (ActRcmdDo)retMap.get(candidateActivityDo);
            actRcmdDo.setpCpm(pcpm);
            retMap.put(candidateActivityDo, actRcmdDo);
        }
        rets = retMap.values().stream().filter(e -> e.getpCpm() != null).sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed()).collect(Collectors.toList());
        return rets;
    }

    public static ActRcmdDo recEE(CODER coderModel, LocalTFModel ltfModel, List<ActivityMatchInfo> activityMatchInfos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = ActRcmder.recRank(coderModel, ltfModel, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.error("Actcmder reEE common input params is null");
            return ret;
        }
        ret = ActRcmder.ActRoulette(rets);
        return ret;
    }

    public static ActRcmdDo recSort(CODER coderModel, LocalTFModel ltfModel, List<ActivityMatchInfo> activityMatchInfos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        return ActRcmder.recEE(coderModel, ltfModel, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    public static Double getMatchScore(ActivityMatchInfo activityMatchInfo) throws Exception {
        Double matchScore = 0.0;
        double slotScore = WilsonInterval.wilsonCalc((double)(activityMatchInfo.getHisRequest().slotVal / 100.0), (double)activityMatchInfo.getHisRequest().slotVal).lowerBound;
        double globalScore = WilsonInterval.wilsonCalc((double)(activityMatchInfo.getHisRequest().globalVal / 100.0), (double)activityMatchInfo.getHisRequest().globalVal).lowerBound;
        double appScore = WilsonInterval.wilsonCalc((double)(activityMatchInfo.getHisRequest().appVal / 100.0), (double)activityMatchInfo.getHisRequest().appVal).lowerBound;
        double sconfidence = Math.min(activityMatchInfo.getHisRequest().slotVal / 100.0, 1.0);
        double aconfidence = Math.min(activityMatchInfo.getHisRequest().appVal / 100.0, 1.0);
        double gconfidence = Math.min(activityMatchInfo.getHisRequest().globalVal / 100.0 * 10.0, 1.0);
        matchScore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
        return matchScore;
    }

    public static ActRcmdDo ActRoulette(List<ActRcmdDo> actRcmdDos) throws Exception {
        Double weight;
        ActRcmdDo actRcmdDo = null;
        if (actRcmdDos == null) {
            return actRcmdDo;
        }
        Double bestCpm = null;
        CandidateActivityDo bestCpmKey = null;
        if (actRcmdDos.size() == 1) {
            return actRcmdDos.get(0);
        }
        for (ActRcmdDo rcmdDo : actRcmdDos) {
            Double cpm = rcmdDo.getpCpm();
            if (cpm == null || bestCpm != null && !(bestCpm < cpm)) continue;
            bestCpm = cpm;
            bestCpmKey = rcmdDo.getCandidateActivityDo();
        }
        HashMap<ActRcmdDo, Double> weightMap = new HashMap<ActRcmdDo, Double>();
        Double weightSum = 0.0;
        for (ActRcmdDo actRcmdDo2 : actRcmdDos) {
            Double cpm = actRcmdDo2.getpCpm();
            weight = ActRcmder.getCpmWeight(cpm, bestCpm);
            if (weight == null) {
                weight = 1.0;
            }
            weightSum = weightSum + weight;
            weightMap.put(actRcmdDo2, weight);
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            ActRcmdDo rcmdDo = (ActRcmdDo)entry.getKey();
            weight = (Double)entry.getValue();
            if (bestCpmKey == null || !bestCpmKey.equals(rcmdDo.getCandidateActivityDo()) || !(weight < weightSum * 0.8)) continue;
            Double weightOther = weightSum - weight;
            weight = weightOther * 0.8 / 0.19999999999999996;
            weightSum = weightOther + weight;
            weightMap.put(rcmdDo, weight);
        }
        actRcmdDo = (ActRcmdDo)Roulette.doubleMap(weightMap);
        return actRcmdDo;
    }

    private static Boolean validModel(CODER coderModel, LocalTFModel ltfModel) {
        Boolean ret = true;
        if (ltfModel == null || coderModel == null) {
            logger.error("ActRcmder.rcmd() input valid ,params ltfModel is null or coder is null");
            ret = false;
        }
        return ret;
    }

    private static Double getCpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            if (bestRpm >= 0.0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }
        return ret;
    }
}

