package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.*;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.*;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.model.ocpxControl.PidController;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;


public class AdxRcmdAlg {

    private static final Logger logger = LoggerFactory.getLogger(AdxRcmdAlg.class);

    public static final int LAST_20_MIN = 1;
    public static final int LAST_1_HOUR = 2;
    public static final int LAST_1_DAY = 3;
    public static final int LAST_3_DAY = 4;
    public static final int LAST_7_DAY = 5;

    public static final int IDEA_RECALL_SIZE = 20;
    public static final double IDEA_COLD_RATE = 0.25;

    public static final int ADIDEA_RECALL_SIZE = 40;
    public static final double ADIDEA_COLD_RATE = 0.25;


    /**
     * 资源位下选创意：按比例区间分类， 获取资源位下：冷启动池–-(近7d)入口曝光<1000次， 优选池--广告ecpm top30
     * 描述：每个比例区间下，召回创意--冷启动池（top5），优选池（top15）
     */
    public static AdxRecallRetDo recallIdeaRun(AdxRecallReqDo recallReqDo) {

        if(!recallIdeaReqValid(recallReqDo)) {
            return null;
        }

        String print = "RecallIdeaRun, resId = " + recallReqDo.getResId();

        //1.计算统计指标
        List<IdeaUnitDo> ideaUnitDos = recallReqDo.getIdeaUnitDos();
        ideaUnitDos.stream().forEach(ideaUnitDo -> {
            ideaUnitDo.setIsNew(IdeaUnitDo.getNewStatus(ideaUnitDo));
            ideaUnitDo.setLt7DExp(IdeaUnitDo.countExpCnt(ideaUnitDo, LAST_7_DAY));
            ideaUnitDo.setLt7DAdCost(IdeaUnitDo.countAdCost(ideaUnitDo, LAST_7_DAY));
            ideaUnitDo.setAdEcpm(IdeaUnitDo.mergeStatAdEcpm(ideaUnitDo, 10L, 1));
        });

        //2.按比例区间聚合
        Map<Integer, List<IdeaUnitDo>> ideaUnitMap = AdxRcmdBase.aggregateByRatioType(ideaUnitDos);
        List<IdeaUnitDo> recallList = new ArrayList<>();
        for(Map.Entry<Integer, List<IdeaUnitDo>> entry: ideaUnitMap.entrySet()) {

            Integer ratioType = entry.getKey();
            List<IdeaUnitDo> subIdeaUnitDos = entry.getValue();

            //2.0召回池分配
            List<IdeaUnitDo> newList = subIdeaUnitDos.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew()).collect(Collectors.toList());
            List<IdeaUnitDo> oldList = subIdeaUnitDos.stream().filter(ideaUnitDo -> !ideaUnitDo.getIsNew()).collect(Collectors.toList());
            long coldSize = AdxRcmdBase.getRecallSize(newList, oldList, IDEA_RECALL_SIZE, IDEA_COLD_RATE, "COLD");
            long bestSize = AdxRcmdBase.getRecallSize(newList, oldList, IDEA_RECALL_SIZE, IDEA_COLD_RATE, "BEST");

            //2.1冷启动池
            List<IdeaUnitDo> coldList = newList.stream().sorted(Comparator.comparing(IdeaUnitDo::getLt7DExp)
                    .thenComparing(IdeaUnitDo::getIdeaUnitId, Comparator.reverseOrder())).limit(coldSize).collect(Collectors.toList());
            recallList.addAll(coldList);
            //2.2优选池
            List<IdeaUnitDo> bestList = oldList.stream().sorted(Comparator.comparing(IdeaUnitDo::getAdEcpm).reversed()
                    .thenComparing(IdeaUnitDo::getIdeaUnitId, Comparator.reverseOrder())).limit(bestSize).collect(Collectors.toList());
            recallList.addAll(bestList);

            //2.3日志打印
            List<Long> coldIds = coldList.stream().map(IdeaUnitDo::getIdeaUnitId).collect(Collectors.toList());
            List<Long> bestIds = bestList.stream().map(IdeaUnitDo::getIdeaUnitId).collect(Collectors.toList());
            print = print + "; {ratioType = " + ratioType + ", originalSize = " + subIdeaUnitDos.size()
                    + ", newList = " + newList.size() + ", oldList = " + oldList.size()
                    + ", coldSize = " + coldList.size() + ", coldList = " + JSON.toJSONString(coldIds)
                    + ", bestSize = " + bestList.size() + ", bestList = " + JSON.toJSONString(bestIds) + "}";
        }

        AdxRecallRetDo ret = new AdxRecallRetDo();
        ret.setIdeaUnitDos(recallList);
        ret.setPrintStr(print);
        return ret;

    }



    /**
     * 计划创意召回任务
     * 描述：获取每个可投计划下的冷启动池和优选池
     *
     * 按比例区间分类， 计算指标，
     * 冷启动池–-创意的入口曝光<阈值
     * 优选池--创意的广告ecpm top30
     * 部署：5min执行1次，不同资源位调用一次算法接口
     * 输出：按 资源位id 存redis，打印log
     *
     */
    public static AdxRecallRetDo recallAdIdeaRun(AdxRecallReqDo recallReqDo) {

        if(!recallAdIdeaReqValid(recallReqDo)) {
            return null;
        }

        String print = "RecallAdIdeaRun, resId=" + recallReqDo.getResId();

        AdxRecallRetDo ret = new AdxRecallRetDo();//出参
        List<AdIdeaDo> recallAdIdeaDos = new ArrayList<>();//出参-计划集合

        //1.获取<创意,统计数据>，统计数据维度：创意，资源位+创意
        List<IdeaUnitDo> ideaUnitDos = recallReqDo.getIdeaUnitDos();
        List<IdeaUnitDo> resoIdeaUnitDos = recallReqDo.getResoIdeaUnitDos();
        Map<Long, AdxStatsDo> ideaUnitStatMap = ideaUnitDos.stream().collect(Collectors.toMap(IdeaUnitDo::getIdeaUnitId, IdeaUnitDo::getAdxStatsDo));
        Map<Long, AdxStatsDo> resoIdeaUnitStatMap = resoIdeaUnitDos.stream().collect(Collectors.toMap(IdeaUnitDo::getIdeaUnitId, IdeaUnitDo::getAdxStatsDo));


        //2.创意分类：<计划，<比例区间, 创意集合>>
        List<IdeaUnitDo> adIdeaUnitDos = recallReqDo.getAdIdeaUnitDos();
        Map<Long, Map<Integer, List<IdeaUnitDo>>> ideaUnitMap = AdxRcmdBase.aggregateByAdRatioType(adIdeaUnitDos);
        for (Map.Entry<Long, Map<Integer, List<IdeaUnitDo>>> entry1 : ideaUnitMap.entrySet()) {

            List<IdeaUnitDo> recallIdeaUnitDos = new ArrayList<>();//出参-每个计划下的创意集合

            Long adIdeaId = entry1.getKey();
            print += "; {adIdea=" + adIdeaId;

            Map<Integer, List<IdeaUnitDo>> ratioTypeMap = entry1.getValue();
            for (Map.Entry<Integer, List<IdeaUnitDo>> entry2 : ratioTypeMap.entrySet()) {

                List<IdeaUnitDo> ideaUnitList = entry2.getValue();
                int size = ideaUnitList.size();
                Integer ratioType = entry2.getKey();
                print += "; [ratio=" + ratioType + ", size=" + size;
                if (size < 1) {continue;}

                //3.计算统计指标resultList
                List<IdeaUnitDo> resultList = new ArrayList<>();
                ideaUnitList.stream().forEach( ideaUnitDo -> {
                    Long ideaUnitId = ideaUnitDo.getIdeaUnitId();
                    AdxStatsDo ideaUnitStats = ideaUnitStatMap.get(ideaUnitId);//创意维度 当天/近3天/近7天
                    AdxStatsDo resoIdeaUnitStats = resoIdeaUnitStatMap.get(ideaUnitId);//资源位+创意维度 当天/近3天/近7天
                    AdxStatsDo adIdeaUnitStats = ideaUnitDo.getAdxStatsDo();//计划+创意维度 当天/近3天

                    IdeaUnitDo resultDo = new IdeaUnitDo();
                    resultDo.setIdeaUnitId(ideaUnitId);
//                    resultDo.setRatioType(ratioType);
                    resultDo.setIsNew(IdeaUnitDo.getNewStatus(ideaUnitStats, resoIdeaUnitStats));
                    resultDo.setLt7DExp(AdxStatsDo.getExpCnt(resoIdeaUnitStats, LAST_7_DAY));
                    resultDo.setAdEcpm(AdxStatsDo.mergeStatAdEcpm(resoIdeaUnitStats, adIdeaUnitStats));
                    resultList.add(resultDo);
                });

                //4.召回池分配recallList = coldList + bestList
                long coldSize = 10L, bestSize = 10L;
                List<IdeaUnitDo> recallList = new ArrayList<>();
                //冷启动池（按近7天 资源位+创意维度 曝光次数，升序截断）
                List<IdeaUnitDo> newList = resultList.stream().filter(resultDo -> resultDo.getIsNew()).collect(Collectors.toList());
                List<IdeaUnitDo> coldList = newList.stream().sorted(Comparator.comparing(IdeaUnitDo::getLt7DExp)).limit(coldSize).collect(Collectors.toList());
                recallList.addAll(coldList);
                //优选池（按近1/3天 计划/资源位+创意维度 广告ecpm，降序截断）
                List<IdeaUnitDo> oldList = resultList.stream().filter(resultDo -> !resultDo.getIsNew()).collect(Collectors.toList());
                List<IdeaUnitDo> bestList = oldList.stream().sorted(Comparator.comparing(IdeaUnitDo::getAdEcpm).reversed()).limit(bestSize).collect(Collectors.toList());
                recallList.addAll(bestList);

                recallIdeaUnitDos.addAll(recallList);

                print += ", nSize=" + newList.size() + ", oSize=" + oldList.size()
                        + ", cold=" + JSON.toJSONString(coldList) + ", best=" + JSON.toJSONString(bestList) + "];";

            }

            AdIdeaDo recallAdIdeaDo = new AdIdeaDo();
            recallAdIdeaDo.setIdeaId(adIdeaId);
            recallAdIdeaDo.setResId(recallReqDo.getResId());
            recallAdIdeaDo.setIdeaUnitDos(recallIdeaUnitDos);
            recallAdIdeaDos.add(recallAdIdeaDo);

            print += "}";
        }

        ret.setAdIdeaDos(recallAdIdeaDos);
        ret.setPrintStr(print);
        return ret;

    }


    /**
     * 计划控制参数任务
     * 描述：三种维度因子控制策略（计划，计划+联盟媒体，计划+联盟媒体行业）；
     *      计划冷启动探价控制；
     */
    public static AdxFactorDo adIdeaFactorRun(AdxFactorReqDo adxFactorReqDo) {

        AdxFactorDo ret = new AdxFactorDo();

        if(!adxFactorReqValid(adxFactorReqDo)) {
            return ret;
        }

        AdxIdeaDo adxIdeaDo = adxFactorReqDo.getAdxIdeaDo();
        Integer bidMode = adxIdeaDo.getBidMode();
        Double target = AdxIdeaDo.getTarget(adxIdeaDo);
        String appId = adxFactorReqDo.getAppId();
        String appTrade = adxFactorReqDo.getExtAppTrade();


        /*** 三种维度因子控制策略（计划，计划+联盟媒体，计划+联盟媒体行业）***/
        AdxFactorDo factorDo = Optional.ofNullable(adxFactorReqDo.getAdxFactorDo()).orElse(new AdxFactorDo());
        AdxStatsDo resoStatsDo = adxFactorReqDo.getResoStatsDo();

        String print = "adIdeaFactorRun, ideaId = " + adxIdeaDo.getIdeaId() + ", bidMode = " + bidMode + ", target = " + target
                + ", appTrade = " + appTrade + ", appId = " + appId + ", last updateTime = " + factorDo.getUpdateTime();

        AdxFactorBasePrintDo ad;
        AdxFactorBaseDo adFactorDo = new AdxFactorBaseDo();
        BeanUtils.copy(factorDo.getAdFactorBaseDo(), adFactorDo);
        AdxStatsDo adStatsDo = adxFactorReqDo.getAdxStatsDo();
        ad = factorRunWithPrint(print, adFactorDo, null, null, adStatsDo, resoStatsDo, bidMode, target, "ad");
        adFactorDo = ad.factorBaseDo;
        print = ad.printStr;

        AdxFactorBasePrintDo trade;
        AdxFactorBaseDo tradeFactorDo = new AdxFactorBaseDo();
        BeanUtils.copy(factorDo.getTradeFactorBaseDo(), tradeFactorDo);
        AdxStatsDo tradeStatsDo = adxFactorReqDo.getTradeStatsDo();
        if (adxFactorReqDo.getExtAppTrade() != null) {
            trade = factorRunWithPrint(print, tradeFactorDo, adFactorDo, factorDo.getAdFactorBaseDo(), tradeStatsDo, resoStatsDo, bidMode, target, "trade");
            tradeFactorDo = trade.factorBaseDo;
            print = trade.printStr;
        }

        AdxFactorBasePrintDo app;
        AdxFactorBaseDo appFactorDo = new AdxFactorBaseDo();
        BeanUtils.copy(factorDo.getAppFactorBaseDo(), appFactorDo);
        AdxStatsDo appStatsDo = adxFactorReqDo.getAppStatsDo();
        if (adxFactorReqDo.getAppId() != null) {
            app = factorRunWithPrint(print, appFactorDo, tradeFactorDo, factorDo.getTradeFactorBaseDo(), appStatsDo, resoStatsDo, bidMode, target, "app");
            appFactorDo = app.factorBaseDo;
            print = app.printStr;
        }


        /*** 计划冷启动探价控制 ***/
        ColdStartFactorDo coldStartFactor = factorDo.getColdStartFactorDo();
        if (adxIdeaDo.getIsColdStart() != null && adxIdeaDo.getIsColdStart()
                && adxIdeaDo.getColdStartFee() != null && adxIdeaDo.getColdStartFee() > 1L) {

            print = print + "; ColdStartFactorRun: isColdStart = " + adxIdeaDo.getIsColdStart() + ", coldStartFee = " + adxIdeaDo.getColdStartFee()
                    + ", {lastParams: isExplore = " + coldStartFactor.isExplore() + ", factor = " + coldStartFactor.getFactor() + "}";

            adColdStartFactorRun(coldStartFactor, adxIdeaDo, adxFactorReqDo.getColdStatsDo());

            print = print  + "; coldStatsDo = " + JSON.toJSONString(adxFactorReqDo.getColdStatsDo())
                    + "; {newParams: isExplore = " + coldStartFactor.isExplore() + ", factor = " + coldStartFactor.getFactor() + "}";

        }


        adFactorDo.setAdxIdeaDo(adxIdeaDo);
        ret.setAdFactorBaseDo(adFactorDo);
        ret.setTradeFactorBaseDo(tradeFactorDo);
        ret.setAppFactorBaseDo(appFactorDo);
        ret.setColdStartFactorDo(coldStartFactor);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));
        ret.setPrintStr(print);

        return ret;
    }



    /**
     * 三种维度因子控制策略
     */
    public static AdxFactorBasePrintDo factorRunWithPrint(String print, AdxFactorBaseDo params,
                                                          AdxFactorBaseDo baseParams, AdxFactorBaseDo lastBaseParams,
                                                          AdxStatsDo statsDo, AdxStatsDo resoStatsDo,
                                                          Integer bidMode, Double target, String dimType) {

        AdxFactorBasePrintDo ret = new AdxFactorBasePrintDo();
        print = print + "; dimType = " + dimType + "; {lastParams: conf = " + params.conf + ", factor = " + params.getFactor() + "}";

        /**
         * 1.计算统计数据
         */
        AdxIndexStatDo last20MinStat = AdxRcmdBase.getStatusVo(statsDo.getLast20MinStat(), bidMode, target);
        AdxIndexStatDo last1HourStat = AdxRcmdBase.getStatusVo(statsDo.getLast1HourStat(), bidMode, target); //上一小时
        AdxIndexStatDo last1DayStat = AdxRcmdBase.getStatusVo(statsDo.getLast1DayStat(), bidMode, target);
        print = print + "; data: {last1DayStat : " + JSON.toJSONString(last1DayStat)
                + "}; {last1HourStat : " + JSON.toJSONString(last1HourStat)
                + "}; {last20MinStat : " + JSON.toJSONString(last20MinStat) + "}";

        //更新统计指标
        AdxIndexStatDo last1DayResoStat = AdxRcmdBase.getStatusVo(resoStatsDo.getLast1DayStat(), bidMode, target);
        updateStatIndex(params, baseParams, last20MinStat, last1HourStat, last1DayStat, last1DayResoStat);


        /**
         * 2.数据不置信情况下，继承上一次base参数
         */
        if (!params.conf && lastBaseParams != null) {
            params.setFactor(lastBaseParams.getFactor());
        }
        Double factor = params.getFactor();


        /**
         * 3.无实时数据 或 数据不置信时，因子衰减
         */
        if (!AdxRcmdBase.isConfident(last1DayStat) || AdxIndexStatDo.getExpCnt(last20MinStat) < 10L) {

            params.setConf(false);
            factor = factor + (1 - factor) * 0.1;
            params.setFactor(DataUtil.formatDouble(factor, 4));
            print = print + "; {newParams: conf = " + params.conf + ", factor = " + params.getFactor() + "}";

            ret.setFactorBaseDo(params);
            ret.setPrintStr(print);
            return ret;
        }


        /**
         * 4.因子更新
         **/
        double biasTarget = 0.001;
        double factorAvg = last1DayStat.getAvgfactor();

        //PID更新
        PidController pidController = new PidController();
        double signal = pidController.update2(biasTarget, last20MinStat.bias, last1HourStat.bias, last1DayStat.bias, factor, 0.5);
        factor = 0.01 + 0.99 * (0.99 * factor + 0.01 * factorAvg) + signal;


        /**
         * 5. 特殊情况约束
         */
        // 约束：全天偏低时，需涨价，控制因子需上调，不小于1.0
        if (last1DayStat.bias < -0.03) {
            factor = Math.max(factor, 1.0);
        }
        // 约束：全天偏高时，需降价，控制因子需下调，不大于1.0
        if (last1DayStat.bias > 0.03) {
            factor = Math.min(factor, 1.0);
        }
        // 约束：成功率骤降，不小于1.0
        if (Math.max(last1HourStat.sucRate, last20MinStat.sucRate) < last1DayStat.sucRate * 0.1) {
            factor = Math.max(factor, 1.0);
        }

        factor = DataUtil.formatDouble(MathUtil.stdwithBoundary(factor, 0.2, 3.0), 4);
        params.setConf(true);
        params.setFactor(factor);

        print = print + "; {newParams: conf = " + params.conf + ", factor = " + params.getFactor() + "}";
        ret.setFactorBaseDo(params);
        ret.setPrintStr(print);
        return ret;
    }


    /**
     * 更新统计指标
     * 资源位数据作为兜底
     */
    public static void updateStatIndex(AdxFactorBaseDo params, AdxFactorBaseDo baseParams,
                                       AdxIndexStatDo last20MinStat, AdxIndexStatDo last1HourStat,
                                       AdxIndexStatDo last1DayStat, AdxIndexStatDo last1DayResoStat) {


        baseParams = Optional.ofNullable(baseParams).orElse(new AdxFactorBaseDo());
        if (!params.dataConf && !baseParams.dataConf && !last1DayStat.getIsConfident()) {
            params.setDataConf(false);
            params.setStatCtr(AdxRcmdBase.getStatCtr(last1DayResoStat));
            params.setLaunchPv(AdxRcmdBase.getStatPvLaunch(last1DayResoStat));
            params.setArpu(AdxRcmdBase.getStatArpu(last1DayResoStat));
            params.setCpm(AdxRcmdBase.getStatCpm(last1DayResoStat));
            params.setStatEcpm(AdxRcmdBase.getStatEcpm(last1DayResoStat));
            return;
        }

        Double statCtr = baseParams.getStatCtr();
        Double launchPv = baseParams.getLaunchPv();
        Double arpu = baseParams.getArpu();
        Double cpm = baseParams.getCpm();
        Double statEcpm = baseParams.getStatEcpm();
        if (params.dataConf || AssertUtil.isAnyEmpty(statCtr, launchPv, arpu)) {
            statCtr = params.getStatCtr();
            launchPv = params.getLaunchPv();
            arpu = params.getArpu();
            cpm = params.getCpm();
            statEcpm = params.getStatEcpm();
        }

        statCtr = AdxRcmdBase.getStatCtr(statCtr, last20MinStat, last1HourStat, last1DayStat);
        launchPv = AdxRcmdBase.getStatPvLaunch(launchPv, last20MinStat, last1HourStat, last1DayStat);
        arpu = AdxRcmdBase.getStatArpu(arpu, last20MinStat, last1HourStat, last1DayStat);
        cpm = AdxRcmdBase.getStatCpm(cpm, last20MinStat, last1HourStat, last1DayStat);
        statEcpm = AdxRcmdBase.getStatEcpm(statEcpm, last20MinStat, last1HourStat, last1DayStat);

        params.setDataConf(true);
        params.setStatCtr(statCtr);
        params.setLaunchPv(launchPv);
        params.setArpu(arpu);
        params.setCpm(cpm);
        params.setStatEcpm(statEcpm);
    }




    /**
     * 计划冷启动探价控制参数任务
     * 描述：计划冷启动探价控制；
     */
    public static void adColdStartFactorRun(ColdStartFactorDo params, AdxIdeaDo adxIdeaDo, AdxStatsDo coldStatsDo) {

        double factor = params.getFactor();
        double targetCost = adxIdeaDo.getColdStartFee();

        Long coldBidCnt = AdxStatsDo.getBidCnt(coldStatsDo, LAST_1_DAY);
        Long coldSucCnt = AdxStatsDo.getBidSucCnt(coldStatsDo, LAST_1_DAY);
        Long coldAdxCost = AdxStatsDo.getAdxCost(coldStatsDo, LAST_1_DAY);
        Long coldAdCost = AdxStatsDo.getAdCost(coldStatsDo, LAST_1_DAY);
        double roi = DataUtil.division((coldAdCost + 1000), (coldAdxCost + 1000), 4); //roi
        double sucRate = DataUtil.division((coldSucCnt + 100), (coldBidCnt + 100), 4); //suc

        // 冷启动无参竞 或 预算消耗完，则回归
        if(coldBidCnt == 0 || coldAdxCost >= targetCost) {
            factor = factor + (1 - factor) * 0.2;

            params.setIdeaId(adxIdeaDo.getIdeaId());
            params.setFactor(DataUtil.formatDouble(factor, 4));
            params.setExplore(false);
            params.setIsColdStart(false);
            params.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));
            return;
        }

        double p = 0.9;//目标消耗程度
        PidController pidController = new PidController();
        double signal = pidController.update(targetCost * p, coldAdxCost, 0.5, -0.1, 0.1);

        if (roi > 1.0 ) {
            signal = Math.max(signal, 0.01) * 1.5;
        }
        if (sucRate < 0.1 ) {
            signal = Math.max(signal, 0.01) * 1.5;
        }

        factor =  0.01 + 0.99 * factor + signal;
        params.setFactor(DataUtil.formatDouble(MathUtil.stdwithBoundary(factor, 1.1, 3.0), 4));


        params.setIdeaId(adxIdeaDo.getIdeaId());
        params.setExplore(true);
        params.setIsColdStart(true);
        params.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));

    }

    /**
     * 广告位控制参数任务
     * 描述：广告位探量控制
     */
    public static SlotFactorDo slotFactorRun(SlotFactorReqDo factorReqDo) {

        SlotFactorDo ret = new SlotFactorDo();

        if (!slotFactorReqValid(factorReqDo)) {
            return ret;
        }

        ret.setResId(factorReqDo.getResId());
        ret.setSlotId(factorReqDo.getSlotId());
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));
        SlotFactorDo lastFactorDo = Optional.ofNullable(factorReqDo.getSlotFactorDo()).orElse(new SlotFactorDo());
        String print = "slotFactorRun, resId = " + factorReqDo.getResId() + ", slotId = " + factorReqDo.getSlotId()
                + "; {lastParams: isExplore = " + lastFactorDo.isExplore() + ", factor = " + lastFactorDo.getFactor()
                + ", flowRatio = " + lastFactorDo.getFlowRatio() + ", updateTime = " + lastFactorDo.getUpdateTime() + "}";

        //1.广告位已探过量，不再开启
        if (!lastFactorDo.isExplore()) {
            ret.setExplore(false);
            print = print + "; {newParams: isExplore = " + ret.isExplore() + "}";
            ret.setPrintStr(print);
            return ret;
        }

        AdxStatsDo slotStatsDo = Optional.ofNullable(factorReqDo.getSlotStatsDo()).orElse(new AdxStatsDo());
        Long last7DayExpCnt = AdxStatsDo.getExpCnt(slotStatsDo, LAST_7_DAY);
        Long last7DayAdxCost = AdxStatsDo.getAdxCost(slotStatsDo, LAST_7_DAY);
        Long last7DayAdCost = AdxStatsDo.getAdCost(slotStatsDo, LAST_7_DAY);
        AdxStatsDo exploreStatsDo = Optional.ofNullable(factorReqDo.getSlotExploreStatsDo()).orElse(new AdxStatsDo());
        Long last7DayEExpCnt = AdxStatsDo.getExpCnt(exploreStatsDo, LAST_7_DAY);
        Long last7DayEAdxCost = AdxStatsDo.getAdxCost(exploreStatsDo, LAST_7_DAY);
        Long last7DayEAdCost = AdxStatsDo.getAdCost(exploreStatsDo, LAST_7_DAY);

        print = print + "; last7Day: expCnt = " + last7DayExpCnt + ", adxCost = " + last7DayAdxCost + ", adCost = " + last7DayAdCost
                + "; last7Day explore: expCnt = " + last7DayEExpCnt + ", adxCost = " + last7DayEAdxCost + ", adCost = " + last7DayEAdCost;

        //2.近7d的消耗>100元 或 曝光>10000次，广告位探量充分，不再开启
        Long adxCostLimit = 100 * 100L, expCntLimit = 10000L;
        if (last7DayAdxCost > adxCostLimit || last7DayExpCnt > expCntLimit) {
            ret.setExplore(false);
            print = print + "; {newParams: isExplore = " + ret.isExplore() + "}";
            ret.setPrintStr(print);
            return ret;
        }

        //3.广告位探量不充分，生成探量因子和探量比例
        updateSlotFactor(print, ret, lastFactorDo, adxCostLimit, expCntLimit, last7DayAdxCost, last7DayExpCnt, exploreStatsDo);
        print = print + "; {newParams: isExplore = " + ret.isExplore() + ", factor = " + ret.getFactor()
                + ", flowRatio = " + ret.getFlowRatio() + "}";

        ret.setPrintStr(print);
        return ret;

    }


    public static void updateSlotFactor(String print, SlotFactorDo params, SlotFactorDo lastParams,
                                        long targetCost, long targetExp, long actualCost, long actualExp,
                                        AdxStatsDo exploreStatsDo) {

        double p = 0.9;//目标消耗程度

        Long last7DayEExpCnt = AdxStatsDo.getExpCnt(exploreStatsDo, LAST_7_DAY);
        Long last7DayEAdCost = AdxStatsDo.getAdCost(exploreStatsDo, LAST_7_DAY);

        double factor = lastParams.getFactor();
        PidController pidController = new PidController();
        double signal1 = pidController.update(targetCost * p, actualCost, 0.2, -0.05, 0.05);
        double signal2 = pidController.update(targetExp * p, actualExp, 0.2, -0.05, 0.05);
        factor =  0.01 + 0.99 * factor + Math.min(signal1, signal2);
        params.setFactor(DataUtil.formatDouble(MathUtil.stdwithBoundary(factor, 1.05, 3.0), 4));

        double flowRatio = lastParams.getFlowRatio();
        double r = DataUtil.division(actualCost, targetCost);
        flowRatio += r < 0.2 ? 0.06 : (r < 0.5 ? 0.04 : (r < 0.8 ? 0.02 : 0.01)) ;
        params.setFlowRatio(DataUtil.formatDouble(MathUtil.stdwithBoundary(flowRatio, 0.1, 0.4), 4));

        params.setExplore(true);

    }


    public static boolean recallIdeaReqValid(AdxRecallReqDo recallReqDo) {

        if (recallReqDo == null) {
            logger.warn("recallIdeaRun recallReqDo is null");
            return false;
        }

        if (recallReqDo.getResId() == null) {
            logger.warn("recallIdeaRun resId is null");
            return false;
        }

        if (recallReqDo.getIdeaUnitDos() == null || recallReqDo.getIdeaUnitDos().size() < 1) {
            logger.warn("recallIdeaRun ideaUnitDos is null, resId = {}", recallReqDo.getResId());
            return false;
        }

        return true;
    }


    public static boolean recallAdIdeaReqValid(AdxRecallReqDo recallReqDo) {

        if (recallReqDo == null) {
            logger.warn("recallAdIdeaRun recallReqDo is null");
            return false;
        }

        if (recallReqDo.getResId() == null) {
            logger.warn("recallAdIdeaRun resId is null");
            return false;
        }

        if (recallReqDo.getAdIdeaUnitDos() == null || recallReqDo.getAdIdeaUnitDos().size() < 1) {
            logger.warn("recallAdIdeaRun adIdeaUnitDos is null, resId = {}", recallReqDo.getResId());
            return false;
        }

        if (recallReqDo.getIdeaUnitDos() == null || recallReqDo.getIdeaUnitDos().size() < 1) {
            logger.warn("recallAdIdeaRun ideaUnitDos is null, resId = {}, adIdeaId = {}", recallReqDo.getResId(), recallReqDo.getAdIdeaUnitDos().get(0).getAdIdeaId());
            return false;
        }

        if (recallReqDo.getResoIdeaUnitDos() == null || recallReqDo.getResoIdeaUnitDos().size() < 1) {
            logger.warn("recallAdIdeaRun resoIdeaUnitDos is null, resId = {}, adIdeaId = {}", recallReqDo.getResId(), recallReqDo.getAdIdeaUnitDos().get(0).getAdIdeaId());
            return false;
        }

        return true;
    }


    public static boolean adxFactorReqValid(AdxFactorReqDo adxFactorReqDo) {

        if (adxFactorReqDo == null) {
            logger.warn("adIdeaFactorRun adxFactorReqDo is null");
            return false;
        }

        if (adxFactorReqDo.getAdxIdeaDo() == null) {
            logger.warn("adIdeaFactorRun adxIdeaDo is null");
            return false;
        }

        AdxIdeaDo adxIdeaDo = adxFactorReqDo.getAdxIdeaDo();
        if (adxIdeaDo.getIdeaId() == null) {
            logger.warn("adIdeaFactorRun ideaId is null");
            return false;
        }
        if (adxIdeaDo.getBidMode() == null) {
            logger.warn("adIdeaFactorRun bidMode is null, adxIdeaDo = {}", JSON.toJSONString(adxIdeaDo));
            return false;
        }

        Double target = AdxIdeaDo.getTarget(adxIdeaDo);
        if(target == null) {
            logger.warn("AdxRoiFactor target is null, adxIdeaDo = {}", JSON.toJSONString(adxIdeaDo));
            return false;
        }

        return true;
    }


    public static boolean slotFactorReqValid(SlotFactorReqDo factorReqDo) {

        if (factorReqDo == null) {
            logger.warn("slotFactorRun factorReqDo is null");
            return false;
        }

        if (factorReqDo.getResId() == null) {
            logger.warn("slotFactorRun resId is null");
            return false;
        }

        if (factorReqDo.getSlotId() == null) {
            logger.warn("slotFactorRun slotId is null");
            return false;
        }

        return true;
    }


}
