package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


/**
 * adx入口素材召回入参
 */

@Data
public class AdxMaterialRecallReqDo implements Serializable {

    private static final long serialVersionUID = 6510392098202430780L;

    /**
     * 推广组id
     */
    private Long groupId;

    /**
     * 资源位id
     */
    private Long resourceId;

    /**
     * 素材尺寸比例区间ID
     */
    private Long adxRatioType;

    /**
     * 素材图片类型（1=图片，3=视频）
     */
    private Integer pictureType;

    /**
     * 可投放素材集合
     */
    private List<Long> materialList;

    /**
     * 素材，统计数据，近1h/当天/近3天/历史7天（key：素材id）
     * 历史7天：只set曝光、点击次数
     */
    private Map<Long, AdxStatsDo> materialStatInfo;

    /**
     * 资源位+素材，统计数据，近1h/当天/近3天（key：素材id）
     */
    private Map<Long, AdxStatsDo> resoMaterialStatInfo;

    /**
     * 资源位+素材标签，曝光、点击次数，历史7天（key：素材标签id）
     */
    private Map<Long, AdxStatsDo> resoTagStatInfo;

    /**
     * 素材id对应的素材标签id 集合
     * key：可投放素材id
     * value：素材标签id集合
     */
    private Map<Long, List<Long>> materialTagList;

}
