/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.adx.pd;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.Optional;

public class AdxStatsDo {
    private AdxIndexStatDo last20MinStat;
    private AdxIndexStatDo last1HourStat;
    private AdxIndexStatDo last1DayStat;
    private AdxIndexStatDo last3DayStat;
    private AdxIndexStatDo last7DayStat;

    public static Long getMergeAvgPrice(AdxStatsDo ideaStats) {
        Long ret = 200L;
        if (ideaStats != null) {
            AdxIndexStatsDo adxIndexStatsDoDay = AdxStatData.getAdxTimeIndex(ideaStats, "1day");
            AdxIndexStatsDo adxIndexStatsDoDayMin = AdxStatData.getAdxTimeIndex(ideaStats, "20min");
            Long price1 = AdxStatsDo.getAvgPrice(adxIndexStatsDoDay);
            Long price2 = AdxStatsDo.getAvgPrice(adxIndexStatsDoDayMin);
            ret = price1 == null ? price2 : (price2 == null ? price1 : Long.valueOf((long)(0.2 * (double)price1.longValue() + 0.8 * (double)price2.longValue())));
        }
        if (ret == null) {
            ret = 400L;
        }
        ret = (long)MathUtil.stdwithBoundary((double)ret.longValue(), (double)400.0, (double)800.0);
        return ret;
    }

    public static Long getAvgPrice(AdxIndexStatsDo adxIndexStatsDo) {
        Long ret = null;
        if (adxIndexStatsDo != null && adxIndexStatsDo.getExpCnt() != null && adxIndexStatsDo.getExpCnt() > 100L) {
            ret = MathUtil.division((Long)(adxIndexStatsDo.getAdxConsume() * 1000L), (Long)adxIndexStatsDo.getExpCnt());
        }
        return ret;
    }

    public static Double mergeStatAdEcpm(AdxStatsDo adxStatsDo, long limit, int mergeType) {
        double r1;
        adxStatsDo = Optional.ofNullable(adxStatsDo).orElse(new AdxStatsDo());
        AdxIndexStatDo last1HourStat = adxStatsDo.getLast1HourStat();
        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
        AdxIndexStatDo last3DayStat = adxStatsDo.getLast3DayStat();
        AdxIndexStatDo last7DayStat = adxStatsDo.getLast7DayStat();
        double mergeExpCnt = 0.0;
        double mergeAdCost = 0.0;
        if (mergeType == 1) {
            r1 = 0.5;
            double r2 = 0.3;
            double r3 = 0.2;
            mergeExpCnt = r1 * (double)AdxIndexStatDo.getExpCnt(last1DayStat).longValue() + r2 * (double)AdxIndexStatDo.getExpCnt(last3DayStat).longValue() + r3 * (double)AdxIndexStatDo.getExpCnt(last7DayStat).longValue();
            mergeAdCost = r1 * (double)AdxIndexStatDo.getAdCost(last1DayStat).longValue() + r2 * (double)AdxIndexStatDo.getAdCost(last3DayStat).longValue() + r3 * (double)AdxIndexStatDo.getAdCost(last7DayStat).longValue();
        } else if (mergeType == 2) {
            r1 = 0.2;
            double r2 = 0.5;
            double r3 = 0.3;
            mergeExpCnt = r1 * (double)AdxIndexStatDo.getExpCnt(last1HourStat).longValue() + r2 * (double)AdxIndexStatDo.getExpCnt(last1DayStat).longValue() + r3 * (double)AdxIndexStatDo.getExpCnt(last3DayStat).longValue();
            mergeAdCost = r1 * (double)AdxIndexStatDo.getAdCost(last1HourStat).longValue() + r2 * (double)AdxIndexStatDo.getAdCost(last1DayStat).longValue() + r3 * (double)AdxIndexStatDo.getAdCost(last3DayStat).longValue();
        } else if (mergeType == 3) {
            r1 = 0.7;
            double r2 = 0.3;
            mergeExpCnt = r1 * (double)AdxIndexStatDo.getExpCnt(last1DayStat).longValue() + r2 * (double)AdxIndexStatDo.getExpCnt(last3DayStat).longValue();
            mergeAdCost = r1 * (double)AdxIndexStatDo.getAdCost(last1DayStat).longValue() + r2 * (double)AdxIndexStatDo.getAdCost(last3DayStat).longValue();
        }
        Double ret = DataUtil.division((Double)((mergeAdCost + (double)(limit * 10L)) * 1000.0), (Double)(mergeExpCnt + (double)limit), (int)3);
        return ret;
    }

    public static Double mergeStatAdEcpm(AdxStatsDo resoStats, AdxStatsDo adStatsDo) {
        resoStats = Optional.ofNullable(resoStats).orElse(new AdxStatsDo());
        adStatsDo = Optional.ofNullable(adStatsDo).orElse(new AdxStatsDo());
        Double resoStatAdEcpm = AdxStatsDo.mergeStatAdEcpm(resoStats, 10L, 3);
        Double adStatAdEcpm = AdxStatsDo.mergeStatAdEcpm(adStatsDo, 10L, 3);
        Double ret = DataUtil.formatDouble((Double)MathUtil.mean((Double)resoStatAdEcpm, (Double)adStatAdEcpm, (Double)0.7), (int)3);
        return ret;
    }

    public static Double mergeStatClickValue(AdxStatsDo adxStatsDo, double dWeight, double hWeight, double mWeight) {
        adxStatsDo = Optional.ofNullable(adxStatsDo).orElse(new AdxStatsDo());
        AdxIndexStatDo last20MinStat = adxStatsDo.getLast20MinStat();
        AdxIndexStatDo last1HourStat = adxStatsDo.getLast1HourStat();
        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
        double mergeClickCnt = dWeight * (double)AdxIndexStatDo.getClickCnt(last1DayStat).longValue() + hWeight * (double)AdxIndexStatDo.getClickCnt(last1HourStat).longValue() + mWeight * (double)AdxIndexStatDo.getClickCnt(last20MinStat).longValue();
        double mergeAdCost = dWeight * (double)AdxIndexStatDo.getAdCost(last1DayStat).longValue() + hWeight * (double)AdxIndexStatDo.getAdCost(last1HourStat).longValue() + mWeight * (double)AdxIndexStatDo.getAdCost(last20MinStat).longValue();
        Double ret = null;
        if (mergeClickCnt > 50.0 || mergeAdCost > 2000.0) {
            ret = DataUtil.division((Double)mergeAdCost, (Double)mergeClickCnt, (int)5);
        }
        return ret;
    }

    public static Double mergeStatCtr(AdxStatsDo adxStatsDo, double dWeight, double hWeight, double mWeight) {
        adxStatsDo = Optional.ofNullable(adxStatsDo).orElse(new AdxStatsDo());
        AdxIndexStatDo last20MinStat = adxStatsDo.getLast20MinStat();
        AdxIndexStatDo last1HourStat = adxStatsDo.getLast1HourStat();
        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
        double mergeExpCnt = dWeight * (double)AdxIndexStatDo.getExpCnt(last1DayStat).longValue() + hWeight * (double)AdxIndexStatDo.getExpCnt(last1HourStat).longValue() + mWeight * (double)AdxIndexStatDo.getExpCnt(last20MinStat).longValue();
        double mergeClickCnt = dWeight * (double)AdxIndexStatDo.getClickCnt(last1DayStat).longValue() + hWeight * (double)AdxIndexStatDo.getClickCnt(last1HourStat).longValue() + mWeight * (double)AdxIndexStatDo.getClickCnt(last20MinStat).longValue();
        Double ret = null;
        if (mergeExpCnt > 100.0 || mergeClickCnt > 50.0) {
            ret = MathUtil.stdwithBoundary((double)DataUtil.division((Double)mergeClickCnt, (Double)mergeExpCnt, (int)5), (double)0.0, (double)1.0);
        }
        return ret;
    }

    public static Long getBidCnt(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;
        if (adxStatsDo != null) {
            AdxIndexStatDo statDo = new AdxIndexStatDo();
            if (timeType == 1) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == 2) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == 3) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == 4) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == 5) {
                statDo = adxStatsDo.getLast7DayStat();
            }
            ret = AdxIndexStatDo.getBidCnt(statDo);
        }
        return ret;
    }

    public static Long getBidSucCnt(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;
        if (adxStatsDo != null) {
            AdxIndexStatDo statDo = new AdxIndexStatDo();
            if (timeType == 1) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == 2) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == 3) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == 4) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == 5) {
                statDo = adxStatsDo.getLast7DayStat();
            }
            ret = AdxIndexStatDo.getBidSucCnt(statDo);
        }
        return ret;
    }

    public static Long getExpCnt(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;
        if (adxStatsDo != null) {
            AdxIndexStatDo statDo = new AdxIndexStatDo();
            if (timeType == 1) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == 2) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == 3) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == 4) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == 5) {
                statDo = adxStatsDo.getLast7DayStat();
            }
            ret = AdxIndexStatDo.getExpCnt(statDo);
        }
        return ret;
    }

    public static Long getAdCost(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;
        if (adxStatsDo != null) {
            AdxIndexStatDo statDo = new AdxIndexStatDo();
            if (timeType == 1) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == 2) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == 3) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == 4) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == 5) {
                statDo = adxStatsDo.getLast7DayStat();
            }
            ret = AdxIndexStatDo.getAdCost(statDo);
        }
        return ret;
    }

    public static Long getAdxCost(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;
        if (adxStatsDo != null) {
            AdxIndexStatDo statDo = new AdxIndexStatDo();
            if (timeType == 1) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == 2) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == 3) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == 4) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == 5) {
                statDo = adxStatsDo.getLast7DayStat();
            }
            ret = AdxIndexStatDo.getAdxCost(statDo);
        }
        return ret;
    }

    public AdxIndexStatDo getLast20MinStat() {
        return this.last20MinStat;
    }

    public void setLast20MinStat(AdxIndexStatDo last20MinStat) {
        this.last20MinStat = last20MinStat;
    }

    public AdxIndexStatDo getLast1HourStat() {
        return this.last1HourStat;
    }

    public void setLast1HourStat(AdxIndexStatDo last1HourStat) {
        this.last1HourStat = last1HourStat;
    }

    public AdxIndexStatDo getLast1DayStat() {
        return this.last1DayStat;
    }

    public void setLast1DayStat(AdxIndexStatDo last1DayStat) {
        this.last1DayStat = last1DayStat;
    }

    public AdxIndexStatDo getLast3DayStat() {
        return this.last3DayStat;
    }

    public AdxIndexStatDo getLast7DayStat() {
        return this.last7DayStat;
    }

    public void setLast3DayStat(AdxIndexStatDo last3DayStat) {
        this.last3DayStat = last3DayStat;
    }

    public void setLast7DayStat(AdxIndexStatDo last7DayStat) {
        this.last7DayStat = last7DayStat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdxStatsDo)) {
            return false;
        }
        AdxStatsDo other = (AdxStatsDo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdxIndexStatDo this$last20MinStat = this.getLast20MinStat();
        AdxIndexStatDo other$last20MinStat = other.getLast20MinStat();
        if (this$last20MinStat == null ? other$last20MinStat != null : !((Object)this$last20MinStat).equals(other$last20MinStat)) {
            return false;
        }
        AdxIndexStatDo this$last1HourStat = this.getLast1HourStat();
        AdxIndexStatDo other$last1HourStat = other.getLast1HourStat();
        if (this$last1HourStat == null ? other$last1HourStat != null : !((Object)this$last1HourStat).equals(other$last1HourStat)) {
            return false;
        }
        AdxIndexStatDo this$last1DayStat = this.getLast1DayStat();
        AdxIndexStatDo other$last1DayStat = other.getLast1DayStat();
        if (this$last1DayStat == null ? other$last1DayStat != null : !((Object)this$last1DayStat).equals(other$last1DayStat)) {
            return false;
        }
        AdxIndexStatDo this$last3DayStat = this.getLast3DayStat();
        AdxIndexStatDo other$last3DayStat = other.getLast3DayStat();
        if (this$last3DayStat == null ? other$last3DayStat != null : !((Object)this$last3DayStat).equals(other$last3DayStat)) {
            return false;
        }
        AdxIndexStatDo this$last7DayStat = this.getLast7DayStat();
        AdxIndexStatDo other$last7DayStat = other.getLast7DayStat();
        return !(this$last7DayStat == null ? other$last7DayStat != null : !((Object)this$last7DayStat).equals(other$last7DayStat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdxStatsDo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdxIndexStatDo $last20MinStat = this.getLast20MinStat();
        result = result * 59 + ($last20MinStat == null ? 43 : ((Object)$last20MinStat).hashCode());
        AdxIndexStatDo $last1HourStat = this.getLast1HourStat();
        result = result * 59 + ($last1HourStat == null ? 43 : ((Object)$last1HourStat).hashCode());
        AdxIndexStatDo $last1DayStat = this.getLast1DayStat();
        result = result * 59 + ($last1DayStat == null ? 43 : ((Object)$last1DayStat).hashCode());
        AdxIndexStatDo $last3DayStat = this.getLast3DayStat();
        result = result * 59 + ($last3DayStat == null ? 43 : ((Object)$last3DayStat).hashCode());
        AdxIndexStatDo $last7DayStat = this.getLast7DayStat();
        result = result * 59 + ($last7DayStat == null ? 43 : ((Object)$last7DayStat).hashCode());
        return result;
    }

    public String toString() {
        return "AdxStatsDo(last20MinStat=" + this.getLast20MinStat() + ", last1HourStat=" + this.getLast1HourStat() + ", last1DayStat=" + this.getLast1DayStat() + ", last3DayStat=" + this.getLast3DayStat() + ", last7DayStat=" + this.getLast7DayStat() + ")";
    }
}

