/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxFactorExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactorExploration {
    private static final Logger logger = LoggerFactory.getLogger(FactorExploration.class);

    public static AdxFactorExplorationDo getExploreFactor(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxFactorExplorationDo ret = new AdxFactorExplorationDo();
        try {
            Double defaultFactor = 1.0;
            Double defaultMinRoi = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Double[] stepList = new Double[]{-0.05, 0.0, 0.05};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3};
            Double baseValue = defaultFactor;
            Double[] baseFlowRate = new Double[]{0.2, 0.6, 0.2};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0};
            Double[] lastRealSucRate = new Double[]{0.0, 0.0, 0.0};
            HashMap<String, Double> factorMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastSucRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            Long tryLabel = 0L;
            Long lastTryLabel = 0L;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Object uppSuc;
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyThiMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyThiDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategyThiMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategyThiMs, minRoi);
                Map<String, Double> roiLevelMs = StrategyBid.getRoiFactorRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);
                roiMs = StrategyBid.getRoi(strategyThiMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategyThiMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategyThiDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategyThiDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                if (bidCntMs == 0L) {
                    tryLabel = 2L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 2000000000L) {
                    tryLabel = 1L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 2000000000L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < minRoi * 0.95) {
                    tryLabel = 1L;
                }
                baseValue = defaultFactor;
                Double lowValue = baseValue + 0.05;
                Double uppValue = baseValue - 0.05;
                Double diff = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || bidCntDay == 0L) {
                    baseValue = defaultFactor;
                } else {
                    Double incre1 = 1.0;
                    AdxFactorExplorationDo lastFactorDoInfo = adxRoiControlDoInfo.getLastFactorExplorationDo();
                    if (AssertUtil.isNotEmpty((Object)lastFactorDoInfo)) {
                        Map<String, Double> lastFactorMap = lastFactorDoInfo.getFactorExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        lastTryLabel = lastFactorDoInfo.getTryLabel();
                        if (AssertUtil.isNotEmpty(lastFactorMap)) {
                            if (lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                baseValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                lowValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                                uppValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                            }
                            if (lastFactorMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division((Double)lastFactorMap.get(bestLevel), (Double)baseValue, (int)3);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double baseDiff = baseValue - defaultFactor;
                        baseValue = baseValue - baseDiff * 0.2;
                    } else {
                        Double weight1 = 1.0;
                        weight1 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0)));
                        Double incre2 = 1.0;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((Double)(minRoi * 0.98), (Double)roiMs, (int)3);
                            if (feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.97);
                                incre2 = DataUtil.division((Double)(minRoi * 0.98), (Double)roiStable, (int)3);
                            }
                        }
                        Double weight2 = 1.0;
                        weight2 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                        Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                        incre1 = StrategyBid.getNormalValue(incre1, 1.0, 0.9, 1.1);
                        incre2 = StrategyBid.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
                        Double incre = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
                        if (weight1 == 0.0) {
                            incre = 1.0 + (incre2 - 1.0) * weight2;
                        }
                        Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);
                        if (tryLabel == 0L) {
                            baseValue = StrategyBid.getNormalValue(baseValue * incre, defaultFactor, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff));
                        }
                        if (lastTryLabel == 1L && tryLabel == 0L) {
                            baseValue = uppValue;
                        }
                        baseValue = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(baseValue, defaultFactor, lowerLimit, upperLimit), (int)6);
                    }
                }
                if (tryLabel == 2L) {
                    Double uppDiff = uppValue - defaultFactor;
                    stepList[0] = uppValue - uppDiff * 0.2 - baseValue;
                    Double lowDiff = lowValue - defaultFactor;
                    stepList[2] = lowValue - lowDiff * 0.2 - baseValue;
                } else if (tryLabel == 1L) {
                    stepList[2] = lowValue - baseValue;
                    uppSuc = DataUtil.division((Double)sucRateLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)Math.max(resoSucRateMs, 0.1), (int)3);
                    Double stepSuc = (Double)uppSuc < 0.1 ? 0.15 : ((Double)uppSuc < 0.3 ? 0.12 : ((Double)uppSuc < 0.5 ? 0.08 : ((Double)uppSuc < 0.7 ? -0.08 : ((Double)uppSuc < 0.9 ? -0.12 : -0.15))));
                    Double uppDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)minRoi, (int)3);
                    Double stepRoi = uppDiff < 0.8 ? -0.1 : (uppDiff < 0.95 ? -0.07 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? 0.07 : 0.1)));
                    if (adxConsumeMs == 0.0) {
                        stepSuc = 0.15;
                        stepRoi = 0.15;
                    }
                    stepList[0] = Math.min(uppValue - baseValue - (0.5 * stepSuc + 0.5 * stepRoi), 0.0);
                } else {
                    uppSuc = stepList;
                    Double.valueOf(uppSuc[0] - (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
                    uppSuc = stepList;
                    Double.valueOf((Double)uppSuc[2] + (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
                }
                if (tryLabel == 2L) {
                    baseFlowRate[0] = 0.2;
                    baseFlowRate[2] = 0.2;
                } else if (tryLabel == 1L) {
                    Double tryDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)minRoi, (int)3);
                    baseFlowRate[0] = StrategyBid.getTryFlowRate(tryDiff, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()));
                    baseFlowRate[2] = 0.2;
                } else if (diff < 0.9) {
                    baseFlowRate[0] = 0.1;
                    baseFlowRate[2] = diff < 0.8 ? 0.3 : 0.2;
                } else if (diff > 1.1) {
                    baseFlowRate[0] = diff < 1.2 ? 0.2 : 0.3;
                    baseFlowRate[2] = 0.1;
                } else if (diff > 0.95 && diff < 1.05) {
                    baseFlowRate[0] = 0.1;
                    baseFlowRate[2] = 0.1;
                } else {
                    baseFlowRate[0] = 0.15;
                    baseFlowRate[2] = 0.15;
                }
                baseFlowRate[1] = DataUtil.formatDouble((Double)(1.0 - baseFlowRate[2] - baseFlowRate[0]), (int)3);
                for (int i = 1; i < AdxLevel.values().length; ++i) {
                    lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                    lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String((Integer)i));
                }
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double factor = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(baseValue + stepList[i - 1], defaultFactor, lowerLimit, upperLimit), (int)6);
                Double flowRate = DataUtil.formatDouble((Double)baseFlowRate[i - 1], (int)3);
                Double lastRoi = lastRealRoi[i - 1];
                Double lastSucRate = lastRealSucRate[i - 1];
                factorMap.put(key, factor);
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
                lastSucRateMap.put(key, lastSucRate);
            }
            ret.setFactorExploreMap(factorMap);
            ret.setFactorFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("FactorExploration.getExploreFactor error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setBasePrice(900.0);
            String str = "{\"adxFlowRateDo\":{\"firFlowRate\":0.19,\"secFlowRate\":0.331,\"thiFlowRate\":0.48},\"adxRoiFactorDo\":{\"advertConsumeDay\":3432.0,\"advertConsumeMs\":129.0,\"adxConsumeDay\":4123.89,\"adxConsumeMs\":102.01,\"adxRoiFactor\":1.509677,\"bidCntDay\":2544586,\"bidCntMs\":13611,\"lastRealRoi\":1.264658,\"roiDay\":0.832226,\"roiMs\":1.264658,\"sucBidCntDay\":177024,\"sucBidCntMs\":4366,\"sucDay\":0.069569,\"sucMs\":0.32077},\"defaultPrice\":26,\"factorExplorationDo\":{\"advertConsumeDay\":5609.0,\"advertConsumeMs\":65.0,\"adxConsumeDay\":4779.32,\"adxConsumeMs\":10.41,\"bidCntDay\":3375095,\"bidCntMs\":103087,\"factorExploreMap\":{\"1\":0.96891,\"2\":1.10391,\"3\":1.12391},\"factorFlowRateMap\":{\"1\":0.697,\"2\":0.104,\"3\":0.201},\"lastRealRoiMap\":{\"1\":1.703579,\"2\":2.129036,\"3\":2.200097},\"lastSucRateMap\":{\"1\":0.006748,\"2\":0.011131,\"3\":0.006783},\"roiDay\":1.173599,\"roiMs\":2.234915,\"sucBidCntDay\":232275,\"sucBidCntMs\":727,\"sucDay\":0.068821,\"sucMs\":0.007053,\"tryLabel\":1},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":5562,\"advertConsume\":423,\"adxConsume\":1205840000,\"bid\":68196,\"exp\":5547,\"click\":31},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":3432.0,\"advertConsumeMs\":129.0,\"adxConsumeDay\":4123.89,\"adxConsumeMs\":102.01,\"adxRoiFactor\":1.509677,\"bidCntDay\":2544586,\"bidCntMs\":13611,\"lastRealRoi\":1.264658,\"roiDay\":0.832226,\"roiMs\":1.264658,\"sucBidCntDay\":177024,\"sucBidCntMs\":4366,\"sucDay\":0.069569,\"sucMs\":0.32077},\"lastFactorExplorationDo\":{\"advertConsumeDay\":5609.0,\"advertConsumeMs\":65.0,\"adxConsumeDay\":4779.32,\"adxConsumeMs\":10.41,\"bidCntDay\":3375095,\"bidCntMs\":103087,\"factorExploreMap\":{\"1\":0.96891,\"2\":1.10391,\"3\":1.12391},\"factorFlowRateMap\":{\"1\":0.697,\"2\":0.104,\"3\":0.201},\"lastRealRoiMap\":{\"1\":1.703579,\"2\":2.129036,\"3\":2.200097},\"lastSucRateMap\":{\"1\":0.006748,\"2\":0.011131,\"3\":0.006783},\"roiDay\":1.173599,\"roiMs\":2.234915,\"sucBidCntDay\":232275,\"sucBidCntMs\":727,\"sucDay\":0.068821,\"sucMs\":0.007053,\"tryLabel\":1},\"lastMinRoi\":1.4,\"lastPriceExplorationDo\":{\"advertConsumeDay\":4055.0,\"advertConsumeMs\":19.0,\"adxConsumeDay\":4437.41,\"adxConsumeMs\":12.89,\"bidCntDay\":3276164,\"bidCntMs\":75197,\"lastRealRoiMap\":{\"1\":1.375824,\"2\":1.963558,\"3\":1.041345},\"lastSucRateMap\":{\"1\":0.011124,\"2\":0.01292,\"3\":0.012876},\"priceExploreMap\":{\"1\":11.244,\"2\":11.475,\"3\":13.654},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.033,\"3\":0.769},\"roiDay\":0.913823,\"roiMs\":1.415216,\"sucBidCntDay\":219360,\"sucBidCntMs\":942,\"sucDay\":0.066957,\"sucMs\":0.012528,\"tryLabel\":1},\"maxPrice\":1000,\"minPrice\":10,\"minRoi\":1.4,\"priceExplorationDo\":{\"advertConsumeDay\":4055.0,\"advertConsumeMs\":19.0,\"adxConsumeDay\":4437.41,\"adxConsumeMs\":12.89,\"bidCntDay\":3276164,\"bidCntMs\":75197,\"lastRealRoiMap\":{\"1\":1.375824,\"2\":1.963558,\"3\":1.041345},\"lastSucRateMap\":{\"1\":0.011124,\"2\":0.01292,\"3\":0.012876},\"priceExploreMap\":{\"1\":11.244,\"2\":11.475,\"3\":13.654},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.033,\"3\":0.769},\"roiDay\":0.913823,\"roiMs\":1.415216,\"sucBidCntDay\":219360,\"sucBidCntMs\":942,\"sucDay\":0.066957,\"sucMs\":0.012528,\"tryLabel\":1},\"resourceIndexMap\":{\"bidSuc\":66657,\"advertConsume\":3505,\"adxConsume\":19205280000,\"bid\":731487,\"exp\":66424,\"click\":333},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":177024,\"advertConsume\":3432,\"adxConsume\":41238830000,\"bid\":2544586,\"exp\":176441,\"click\":540}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":21941,\"advertConsume\":571,\"adxConsume\":4328710000,\"bid\":603288,\"exp\":21887,\"click\":53}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":61451,\"advertConsume\":815,\"adxConsume\":12992760000,\"bid\":1020494,\"exp\":61277,\"click\":175}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":136406,\"advertConsume\":2700,\"adxConsume\":27113230000,\"bid\":1673336,\"exp\":135901,\"click\":460}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":121627,\"advertConsume\":3025,\"adxConsume\":24957520000,\"bid\":1573171,\"exp\":121223,\"click\":404}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":85055,\"advertConsume\":2131,\"adxConsume\":17870530000,\"bid\":1202442,\"exp\":84790,\"click\":319}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":26513,\"advertConsume\":716,\"adxConsume\":5130120000,\"bid\":634142,\"exp\":26405,\"click\":87}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":4366,\"advertConsume\":129,\"adxConsume\":1020040000,\"bid\":13611,\"exp\":4357,\"click\":20}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":76,\"advertConsume\":2,\"adxConsume\":8350000,\"bid\":4865,\"exp\":76,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":29,\"advertConsume\":15,\"adxConsume\":4060000,\"bid\":693,\"exp\":29,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":364,\"advertConsume\":31,\"adxConsume\":52450000,\"bid\":18508,\"exp\":365,\"click\":4}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":706,\"advertConsume\":263,\"adxConsume\":129790000,\"bid\":24779,\"exp\":707,\"click\":8}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":69,\"advertConsume\":21,\"adxConsume\":11800000,\"bid\":3338,\"exp\":69,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":151,\"advertConsume\":24,\"adxConsume\":24570000,\"bid\":6740,\"exp\":151,\"click\":0}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo3 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastFactorExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo3.getLastFactorExplorationDo()));
            AdxFactorExplorationDo ret3 = FactorExploration.getExploreFactor(adxRoiControlDoInfo3);
            System.out.println("ret3:" + JSON.toJSONString((Object)ret3));
            System.out.println("ret3:" + JSON.toJSONString((Object)DataUtil.double2Long((double)35.0, (Long)1L)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

