/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxPriceExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceExploration {
    private static final Logger logger = LoggerFactory.getLogger(PriceExploration.class);

    public static AdxPriceExplorationDo getExplorePrice(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxPriceExplorationDo ret = new AdxPriceExplorationDo();
        try {
            Double defaultPrice = 10.0;
            Double defaultMinRoi = 1.0;
            Double[] stepList = new Double[]{0.95, 1.0, 1.05};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3};
            Double baseValue = defaultPrice;
            Double[] baseFlowRate = new Double[]{0.2, 0.6, 0.2};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0};
            Double[] lastRealSucRate = new Double[]{0.0, 0.0, 0.0};
            HashMap<String, Double> priceMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastSucRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            Long tryLabel = 0L;
            Double upLimitBidFee = null;
            Long lastTryLabel = 0L;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategySecMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategySecDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategySecMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategySecMs, minRoi);
                Map<String, Double> roiLevelMs = StrategyBid.getRoiPriceRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);
                roiMs = StrategyBid.getRoi(strategySecMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategySecMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategySecDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategySecDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                defaultPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(), 10L));
                Double minPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinPrice(), 1L));
                Double maxPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMaxPrice(), DataUtil.double2Long((Double)defaultPrice) + 1L));
                Double basePrice = adxRoiControlDoInfo.getBasePrice();
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                if (bidCntMs == 0L) {
                    tryLabel = 2L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < 2000000000L) {
                    tryLabel = 1L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 2000000000L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < minRoi * 0.95) {
                    tryLabel = 1L;
                }
                baseValue = defaultPrice;
                Double lowValue = baseValue * 0.95;
                Double uppValue = baseValue * 1.05;
                Double diff = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || bidCntDay == 0L) {
                    baseValue = defaultPrice;
                } else {
                    Object uppSuc;
                    Double incre1 = 1.0;
                    AdxPriceExplorationDo lastPriceDoInfo = adxRoiControlDoInfo.getLastPriceExplorationDo();
                    if (AssertUtil.isNotEmpty((Object)lastPriceDoInfo)) {
                        Map<String, Double> lastPriceMap = lastPriceDoInfo.getPriceExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        lastTryLabel = lastPriceDoInfo.getTryLabel();
                        if (AssertUtil.isNotEmpty(lastPriceMap)) {
                            if (lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                baseValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                lowValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                                uppValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                            }
                            upLimitBidFee = StrategyBid.selectUpLimitFee(lastPriceMap, sucRateLevelMs, lastPriceDoInfo.getUpLimitBidFee());
                            if (lastPriceMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division((Double)lastPriceMap.get(bestLevel), (Double)baseValue, (int)3);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double baseDiff = DataUtil.division((Double)baseValue, (Double)defaultPrice) - 1.0;
                        baseValue = baseValue - defaultPrice * baseDiff * 0.2;
                    } else {
                        Double weight1 = 1.0;
                        weight1 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0)));
                        Double incre2 = 1.0;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((Double)roiMs, (Double)(minRoi * 0.98), (int)3);
                            if (upLimitBidFee != null && feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.98);
                                incre2 = DataUtil.division((Double)roiStable, (Double)(minRoi * 0.98), (int)3);
                            }
                            Double weight2 = 1.0;
                            weight2 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                            Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                            incre1 = StrategyBid.getNormalValue(incre1, 1.0, 0.9, 1.1);
                            incre2 = StrategyBid.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
                            Double incre = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
                            if (weight1 == 0.0 || diff > 1.3) {
                                incre = 1.0 + (incre2 - 1.0) * weight2;
                            }
                            Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);
                            if (tryLabel == 0L) {
                                Double MojiRoiLimit = StrategyBid.getMojiRoiLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                                baseValue = upLimitBidFee != null && feeType != null && feeType == 1 ? (StrategyBid.getBaseLevelConfident(resoSucRateMs, sucRateLevelMs, adxConsumeLevelMs) == 1L && roiMs >= minRoi * MojiRoiLimit && roiMs <= minRoi ? Double.valueOf(Math.max(upLimitBidFee, baseValue)) : StrategyBid.getNormalValue(baseValue * incre, defaultPrice, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff))) : StrategyBid.getNormalValue(baseValue * incre, defaultPrice, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff));
                            }
                            if (lastTryLabel == 1L && tryLabel == 0L) {
                                baseValue = uppValue;
                            }
                            if (basePrice != null && basePrice > 0.0 && diff > 1.3) {
                                baseValue = Math.max(basePrice, baseValue);
                            }
                            if (upLimitBidFee != null && feeType != null && feeType == 1) {
                                if (lastTryLabel == 1L && tryLabel == 1L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) > minRoi * 0.95) {
                                    baseValue = uppValue;
                                }
                                baseValue = Math.min(upLimitBidFee, baseValue);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double uppDiff = DataUtil.division((Double)uppValue, (Double)defaultPrice) - 1.0;
                        stepList[2] = DataUtil.division((Double)(uppValue - defaultPrice * uppDiff * 0.2), (Double)baseValue);
                        Double lowDiff = DataUtil.division((Double)lowValue, (Double)defaultPrice) - 1.0;
                        stepList[0] = DataUtil.division((Double)(lowValue - defaultPrice * lowDiff * 0.2), (Double)baseValue);
                    } else if (tryLabel == 1L) {
                        stepList[0] = DataUtil.division((Double)lowValue, (Double)baseValue);
                        uppSuc = DataUtil.division((Double)sucRateLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)Math.max(resoSucRateMs, 0.1), (int)3);
                        Double stepSuc = (Double)uppSuc < 0.1 ? 0.1 : ((Double)uppSuc < 0.3 ? 0.08 : ((Double)uppSuc < 0.5 ? 0.05 : ((Double)uppSuc < 0.7 ? -0.05 : ((Double)uppSuc < 0.9 ? -0.08 : -0.1))));
                        Double uppDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)minRoi, (int)3);
                        Double stepRoi = uppDiff < 0.8 ? -0.08 : (uppDiff < 0.95 ? -0.06 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? 0.06 : 0.08)));
                        if (adxConsumeMs == 0.0) {
                            stepSuc = 0.1;
                            stepRoi = 0.1;
                        }
                        stepList[2] = Math.max(DataUtil.division((Double)uppValue, (Double)baseValue) + 0.5 * stepSuc + 0.5 * stepRoi, 1.0);
                    } else {
                        uppSuc = stepList;
                        Double.valueOf(uppSuc[2] + (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
                        uppSuc = stepList;
                        Double.valueOf((Double)uppSuc[0] - (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
                    }
                    if (upLimitBidFee != null) {
                        stepList[2] = Math.min(stepList[2], DataUtil.division((Double)upLimitBidFee, (Double)baseValue));
                    }
                    if (basePrice != null && basePrice > 0.0) {
                        stepList[2] = Math.max(stepList[2], DataUtil.division((Double)basePrice, (Double)baseValue));
                    }
                    if (tryLabel == 2L) {
                        baseFlowRate[2] = 0.2;
                        baseFlowRate[0] = 0.2;
                    } else if (tryLabel == 1L) {
                        Double tryDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)minRoi, (int)3);
                        baseFlowRate[2] = StrategyBid.getTryFlowRate(tryDiff, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                        baseFlowRate[0] = 0.2;
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {
                            Double tmpDiff1 = DataUtil.division((Double)roiDay, (Double)minRoi, (int)3);
                            Double tmpFlowRate1 = tmpDiff1 < 0.95 ? 0.2 : (tmpDiff1 < 0.98 ? 0.25 : (tmpDiff1 < 1.1 ? 0.3 : 0.35));
                            Double tmpDiff2 = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                            Double tmpFlowRate2 = tmpDiff2 < 0.95 ? 0.2 : (tmpDiff2 < 0.98 ? 0.25 : (tmpDiff2 < 1.1 ? 0.3 : 0.35));
                            baseFlowRate[2] = DataUtil.formatDouble((Double)(0.3 * tmpFlowRate1 + 0.7 * tmpFlowRate2), (int)3);
                            baseFlowRate[0] = 0.0;
                        }
                    } else {
                        if (diff < 0.9) {
                            baseFlowRate[2] = 0.1;
                            baseFlowRate[0] = diff < 0.8 ? 0.3 : 0.2;
                        } else if (diff > 1.1) {
                            baseFlowRate[2] = diff < 1.2 ? 0.2 : 0.3;
                            baseFlowRate[0] = 0.1;
                        } else if (diff > 0.95 && diff < 1.05) {
                            baseFlowRate[2] = 0.1;
                            baseFlowRate[0] = 0.1;
                        } else {
                            baseFlowRate[2] = 0.15;
                            baseFlowRate[0] = 0.15;
                        }
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {
                            Double tmpDiff1 = DataUtil.division((Double)roiDay, (Double)minRoi, (int)3);
                            Double tmpFlowRate1 = tmpDiff1 < 0.95 ? 0.1 : (tmpDiff1 < 0.98 ? 0.15 : (tmpDiff1 < 1.1 ? 0.2 : 0.25));
                            Double tmpDiff2 = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                            Double tmpFlowRate2 = tmpDiff2 < 0.95 ? 0.1 : (tmpDiff2 < 0.98 ? 0.15 : (tmpDiff2 < 1.1 ? 0.2 : 0.25));
                            baseFlowRate[2] = DataUtil.formatDouble((Double)(0.3 * tmpFlowRate1 + 0.7 * tmpFlowRate2), (int)3);
                            baseFlowRate[0] = 0.0;
                        }
                    }
                    baseFlowRate[1] = DataUtil.formatDouble((Double)(1.0 - baseFlowRate[0] - baseFlowRate[2]), (int)3);
                    for (int i = 1; i < AdxLevel.values().length; ++i) {
                        lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                        lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String((Integer)i));
                    }
                }
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double price = DataUtil.formatDouble((Double)(baseValue * stepList[i - 1]), (int)3);
                Double flowRate = DataUtil.formatDouble((Double)baseFlowRate[i - 1], (int)3);
                Double lastRoi = lastRealRoi[i - 1];
                Double lastSucRate = lastRealSucRate[i - 1];
                priceMap.put(key, price);
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
                lastSucRateMap.put(key, lastSucRate);
            }
            ret.setPriceExploreMap(priceMap);
            ret.setPriceFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setUpLimitBidFee(upLimitBidFee);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("PriceExploration.getExplorePrice error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setDefaultPrice(1400L);
            adxRoiControlDoInfo1.setMinPrice(1000L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setStrategy("1");
            adxRoiControlDoInfo1.setLastMinRoi(1.2);
            adxRoiControlDoInfo1.setMinRoi(1.2);
            HashMap<String, Long> ideaIndexMap1 = new HashMap<String, Long>();
            ideaIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            ideaIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            ideaIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            ideaIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            ideaIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800000000L);
            ideaIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);
            HashMap<String, Long> resourceIndexMap1 = new HashMap<String, Long>();
            resourceIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            resourceIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            resourceIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            resourceIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            resourceIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800000000L);
            resourceIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);
            adxRoiControlDoInfo1.setIdeaIndexMap(ideaIndexMap1);
            adxRoiControlDoInfo1.setResourceIndexMap(resourceIndexMap1);
            String str = "{\"adxFlowRateDo\":{\"firFlowRate\":0.34,\"secFlowRate\":0.181,\"thiFlowRate\":0.48},\"adxRoiFactorDo\":{\"advertConsumeDay\":104977.0,\"advertConsumeMs\":5965.0,\"adxConsumeDay\":72334.45,\"adxConsumeMs\":4047.41,\"adxRoiFactor\":0.466874,\"bidCntDay\":93489,\"bidCntMs\":3949,\"lastRealRoi\":1.473787,\"roiDay\":1.451274,\"roiMs\":1.473787,\"sucBidCntDay\":54901,\"sucBidCntMs\":3091,\"sucDay\":0.587246,\"sucMs\":0.78273},\"basePrice\":1400.0,\"defaultPrice\":1400,\"factorExplorationDo\":{\"advertConsumeDay\":159252.0,\"advertConsumeMs\":3333.0,\"adxConsumeDay\":111867.77,\"adxConsumeMs\":2374.41,\"bidCntDay\":91844,\"bidCntMs\":2103,\"factorExploreMap\":{\"1\":0.602227,\"2\":0.622227,\"3\":0.642227},\"factorFlowRateMap\":{\"1\":0.101,\"2\":0.802,\"3\":0.101},\"lastRealRoiMap\":{\"1\":1.256646,\"2\":1.300541,\"3\":2.07033},\"lastSucRateMap\":{\"1\":0.990951,\"2\":0.968529,\"3\":0.587562},\"roiDay\":1.423574,\"roiMs\":1.403724,\"sucBidCntDay\":85400,\"sucBidCntMs\":1809,\"sucDay\":0.929838,\"sucMs\":0.8602,\"tryLabel\":0},\"feeType\":1,\"ideaIndexMap\":{\"bidSuc\":8792,\"advertConsume\":15828,\"adxConsume\":115542000000,\"bid\":11304,\"exp\":8253,\"click\":1505},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":104977.0,\"advertConsumeMs\":5965.0,\"adxConsumeDay\":72334.45,\"adxConsumeMs\":4047.41,\"adxRoiFactor\":0.466874,\"bidCntDay\":93489,\"bidCntMs\":3949,\"lastRealRoi\":1.473787,\"roiDay\":1.451274,\"roiMs\":1.473787,\"sucBidCntDay\":54901,\"sucBidCntMs\":3091,\"sucDay\":0.587246,\"sucMs\":0.78273},\"lastFactorExplorationDo\":{\"advertConsumeDay\":159252.0,\"advertConsumeMs\":3333.0,\"adxConsumeDay\":111867.77,\"adxConsumeMs\":2374.41,\"bidCntDay\":91844,\"bidCntMs\":2103,\"factorExploreMap\":{\"1\":0.602227,\"2\":0.622227,\"3\":0.642227},\"factorFlowRateMap\":{\"1\":0.101,\"2\":0.802,\"3\":0.101},\"lastRealRoiMap\":{\"1\":1.256646,\"2\":1.300541,\"3\":2.07033},\"lastSucRateMap\":{\"1\":0.990951,\"2\":0.968529,\"3\":0.587562},\"roiDay\":1.423574,\"roiMs\":1.403724,\"sucBidCntDay\":85400,\"sucBidCntMs\":1809,\"sucDay\":0.929838,\"sucMs\":0.8602,\"tryLabel\":0},\"lastMinRoi\":1.45,\"lastPriceExplorationDo\":{\"advertConsumeDay\":146164.0,\"advertConsumeMs\":917.0,\"adxConsumeDay\":102258.68,\"adxConsumeMs\":772.8,\"bidCntDay\":93816,\"bidCntMs\":3781,\"lastRealRoiMap\":{\"1\":5.989355,\"2\":5.510206,\"3\":0.893894},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.004925,\"3\":0.998121},\"priceExploreMap\":{\"1\":1162.42,\"2\":1263.5,\"3\":1400.0},\"priceFlowRateMap\":{\"1\":0.0,\"2\":0.772,\"3\":0.231},\"roiDay\":1.429357,\"roiMs\":1.186596,\"sucBidCntDay\":78364,\"sucBidCntMs\":547,\"sucDay\":0.835295,\"sucMs\":0.144671,\"tryLabel\":1,\"upLimitBidFee\":1400.0},\"maxPrice\":1800,\"minPrice\":500,\"minRoi\":1.45,\"priceExplorationDo\":{\"advertConsumeDay\":146164.0,\"advertConsumeMs\":917.0,\"adxConsumeDay\":102258.68,\"adxConsumeMs\":772.8,\"bidCntDay\":93816,\"bidCntMs\":3781,\"lastRealRoiMap\":{\"1\":5.989355,\"2\":5.510206,\"3\":0.893894},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.004925,\"3\":0.998121},\"priceExploreMap\":{\"1\":1162.42,\"2\":1263.5,\"3\":1400.0},\"priceFlowRateMap\":{\"1\":0.0,\"2\":0.772,\"3\":0.231},\"roiDay\":1.429357,\"roiMs\":1.186596,\"sucBidCntDay\":78364,\"sucBidCntMs\":547,\"sucDay\":0.835295,\"sucMs\":0.144671,\"tryLabel\":1,\"upLimitBidFee\":1400.0},\"resourceIndexMap\":{\"bidSuc\":28614,\"advertConsume\":52745,\"adxConsume\":374500000000,\"bid\":31983,\"exp\":26750,\"click\":5014},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":54901,\"advertConsume\":104977,\"adxConsume\":723344400000,\"bid\":93489,\"exp\":51650,\"click\":10756}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":60685,\"advertConsume\":114018,\"adxConsume\":791825900000,\"bid\":77757,\"exp\":56531,\"click\":11532}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":18153,\"advertConsume\":33013,\"adxConsume\":237116900000,\"bid\":18238,\"exp\":16923,\"click\":3285}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":15422,\"advertConsume\":27636,\"adxConsume\":202565640000,\"bid\":16847,\"exp\":14452,\"click\":2772}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":63185,\"advertConsume\":119068,\"adxConsume\":827402470000,\"bid\":66203,\"exp\":59085,\"click\":11818}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":11897,\"advertConsume\":21093,\"adxConsume\":155713510000,\"bid\":13990,\"exp\":11120,\"click\":2251}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":3091,\"advertConsume\":5965,\"adxConsume\":40474000000,\"bid\":3949,\"exp\":2891,\"click\":530}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":15,\"adxConsume\":154000000,\"bid\":1609,\"exp\":11,\"click\":4}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":445,\"advertConsume\":785,\"adxConsume\":5810000000,\"bid\":447,\"exp\":415,\"click\":83}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":501,\"advertConsume\":571,\"adxConsume\":6538000000,\"bid\":505,\"exp\":467,\"click\":63}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":4276,\"advertConsume\":7198,\"adxConsume\":56210000000,\"bid\":4345,\"exp\":4015,\"click\":726}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":503,\"advertConsume\":1323,\"adxConsume\":6650000000,\"bid\":521,\"exp\":475,\"click\":91}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastPriceExplorationDo()));
            AdxPriceExplorationDo ret2 = PriceExploration.getExplorePrice(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

