/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.cost;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.BackendAdvertStatDo;
import cn.com.duiba.nezha.alg.alg.vo.BackendFactor;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.StatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;

public class BackendCostOptimizer {
    public static Map<String, Double> backendTypePriorityMap = new HashMap<String, Double>();

    public static Map<Long, BackendAdvertStatDo> getBackendAdvertStatInfo(Map<Long, StatDo> appAdvertStatMap, Map<Long, StatDo> globalAdvertStatMap) {
        HashMap<Long, BackendAdvertStatDo> ret = new HashMap<Long, BackendAdvertStatDo>();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{globalAdvertStatMap})) {
            if (appAdvertStatMap == null) {
                appAdvertStatMap = new HashMap<Long, StatDo>();
            }
            for (Map.Entry<Long, StatDo> entry : globalAdvertStatMap.entrySet()) {
                Long advertId = entry.getKey();
                StatDo globalStatDo = entry.getValue();
                StatDo appStatDo = appAdvertStatMap.get(advertId);
                String type = BackendCostOptimizer.getTaskBackendType(globalStatDo);
                if (type == null) continue;
                BackendAdvertStatDo backendAdvertStatDo = new BackendAdvertStatDo();
                backendAdvertStatDo.setAdvertId(advertId);
                backendAdvertStatDo.setBackendType(type);
                backendAdvertStatDo.setAvgBackendCvr(BackendCostOptimizer.getTaskBackendCvr(globalStatDo, type));
                Double currentBCvr = BackendCostOptimizer.getTaskBackendCvr(appStatDo, type);
                if (currentBCvr == null) {
                    currentBCvr = BackendCostOptimizer.getTaskBackendCvr(globalStatDo, type);
                }
                backendAdvertStatDo.setCBackendCvr(currentBCvr);
                ret.put(advertId, backendAdvertStatDo);
            }
        }
        return ret;
    }

    public static <T> Map<T, BackendFactor> getBackendAdvertInfo(Map<T, Double> advertPreInfo, Map<T, BackendAdvertStatDo> advertStatInfo, Map<T, BudgetSmoothDo> advertBudgetInfo) {
        HashMap<T, BackendFactor> ret = new HashMap<T, BackendFactor>();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{advertPreInfo, advertStatInfo})) {
            if (advertBudgetInfo == null) {
                advertBudgetInfo = new HashMap<T, BudgetSmoothDo>();
            }
            for (Map.Entry<T, BackendAdvertStatDo> entry : advertStatInfo.entrySet()) {
                T advertId = entry.getKey();
                BackendAdvertStatDo backendAdvertStatDo = entry.getValue();
                Double preBackendCvr = advertPreInfo.get(advertId);
                BudgetSmoothDo budgetSmoothDo = advertBudgetInfo.get(advertId);
                if (backendAdvertStatDo == null || preBackendCvr == null) continue;
                Double mergeCvr = BackendCostOptimizer.getMergeBackendCvr(backendAdvertStatDo.getCBackendCvr(), preBackendCvr);
                BackendFactor optFactor = BackendCostOptimizer.getBackendOptFactor(mergeCvr, backendAdvertStatDo.getAvgBackendCvr(), budgetSmoothDo);
                ret.put(advertId, optFactor);
            }
        }
        return ret;
    }

    public static BackendFactor getBackendOptFactor(Double mergeCvr, Double avgCvr, BudgetSmoothDo budgetSmoothDo) {
        if (budgetSmoothDo == null) {
            budgetSmoothDo = new BudgetSmoothDo();
        }
        BackendFactor backendFactor = new BackendFactor();
        backendFactor.setBudgetRatio(budgetSmoothDo.getRatio());
        backendFactor.setBudgetType(budgetSmoothDo.getType());
        Double ret = 1.0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{mergeCvr, avgCvr})) {
            Double absoluteFactor = 1.0;
            Double relativeFactor = 1.0;
            Double ratio = (mergeCvr + 0.001) / (avgCvr + 0.001);
            Double budgetSmoothRatio = null;
            if (budgetSmoothDo != null) {
                budgetSmoothRatio = budgetSmoothDo.getRatio();
            }
            if (mergeCvr <= 0.05 && ratio <= 0.7) {
                absoluteFactor = MathBase.sigmoidWithZoomAndIntervalMap(mergeCvr / 0.05 - 0.5, 0.9, 1.0, 8.0);
            } else if (mergeCvr > 0.5) {
                absoluteFactor = 1.02;
            }
            if (mergeCvr <= 0.7 && ratio <= 0.99) {
                Double relativeFactor1 = MathBase.sigmoidWithZoomAndIntervalMap(ratio - 0.4, 0.4, 1.0, 8.0);
                Double relativeFactor2 = MathBase.sigmoidWithZoomAndIntervalMap(ratio - 0.5, 0.4, 1.0, 8.0);
                if (mergeCvr <= 0.05) {
                    relativeFactor = relativeFactor1;
                } else if (mergeCvr < 0.2) {
                    relativeFactor = ((0.2 - mergeCvr) * relativeFactor1 + (mergeCvr - 0.1) * relativeFactor2) / 0.1;
                } else if (mergeCvr < 0.4) {
                    relativeFactor = relativeFactor2;
                }
            } else if (ratio > 1.5) {
                relativeFactor = 1.02;
            }
            if (budgetSmoothRatio != null && budgetSmoothRatio > 1.0 && avgCvr < 0.8) {
                ret = absoluteFactor * relativeFactor;
                double smoothFactor = MathBase.sigmoidWithZoomAndIntervalMap(budgetSmoothRatio - 1.0, 0.1, 1.3, 8.0);
                ret = BackendCostOptimizer.getBudgetSmooth(ret, smoothFactor);
                ret = DataUtil.formatDouble((Double)ret, (int)4);
            }
            System.out.println("mergeCvr=" + mergeCvr + ",avgCvr=" + avgCvr + ",ratio=" + ratio + ",budgetratio=" + budgetSmoothDo.getRatio() + ",absoluteFactor=" + absoluteFactor + ",relativeFactor=" + relativeFactor + ",smoothFactor=");
        }
        backendFactor.setBackendFactor(ret);
        return backendFactor;
    }

    public static Double getBudgetSmooth(Double factor, Double weight) {
        Double ret = 1.0;
        if (factor != null && weight != null) {
            ret = (factor - 1.0) * weight + 1.0;
        }
        return ret;
    }

    public static Double getMergeBackendCvr(Double statCvr, Double preCvr) {
        Double ret = null;
        if (statCvr != null && preCvr != null) {
            ret = 0.3 * statCvr + 0.7 * preCvr;
        }
        return ret;
    }

    public static Double getTaskBackendCvr(StatDo statDo, String backendType) {
        Double ret = null;
        if (statDo != null && backendType != null) {
            Long cnt;
            Long actClickCnt = statDo.getActClickCnt();
            Map<String, Long> backendCntMap = statDo.getBackendCntMap();
            if (actClickCnt != null && actClickCnt >= 50L && AssertUtil.isNotEmpty(backendCntMap) && (cnt = backendCntMap.get(backendType)) != null) {
                ret = DataUtil.division((Long)cnt, (Long)actClickCnt, (int)4);
                ret = Math.min(ret, 1.01);
            }
        }
        return ret;
    }

    public static String getTaskBackendType(StatDo statDo) {
        String ret = null;
        if (statDo != null) {
            Long actClickCnt = statDo.getActClickCnt();
            Map<String, Long> backendCntMap = statDo.getBackendCntMap();
            if (actClickCnt != null && actClickCnt >= 50L && AssertUtil.isNotEmpty(backendCntMap)) {
                HashMap<String, Double> filterMap = new HashMap<String, Double>();
                for (Map.Entry<String, Long> entry : backendCntMap.entrySet()) {
                    String type = entry.getKey();
                    Long cnt = entry.getValue();
                    Double weight = backendTypePriorityMap.get(type);
                    if (cnt == null || cnt < 10L || weight == null) continue;
                    filterMap.put(type, (double)cnt.longValue() * weight);
                }
                ret = BackendCostOptimizer.getValueTopOneFromMap(filterMap);
            }
        }
        return ret;
    }

    public static String getValueTopOneFromMap(Map<String, Double> map) {
        String ret = null;
        if (AssertUtil.isNotEmpty(map)) {
            Double maxValue = 1.0;
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                Double val = entry.getValue();
                if (val == null || !(val > maxValue)) continue;
                maxValue = val;
                ret = entry.getKey();
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        StatDo statDo = new StatDo();
        statDo.setAdvertId(1L);
        statDo.setActClickCnt(90L);
        HashMap<String, Long> bcMap = new HashMap<String, Long>();
        bcMap.put("1", 10L);
        statDo.setBackendCntMap(bcMap);
        HashMap<Long, StatDo> appAdvertStatMap = new HashMap<Long, StatDo>();
        appAdvertStatMap.put(1L, statDo);
        StatDo statDo2 = new StatDo();
        statDo2.setAdvertId(1L);
        statDo2.setActClickCnt(300L);
        HashMap<String, Long> bcMap2 = new HashMap<String, Long>();
        bcMap2.put("1", 50L);
        statDo2.setBackendCntMap(bcMap2);
        HashMap<Long, StatDo> globalAdvertStatMap = new HashMap<Long, StatDo>();
        globalAdvertStatMap.put(1L, statDo2);
        Map<Long, BackendAdvertStatDo> ret1 = BackendCostOptimizer.getBackendAdvertStatInfo(appAdvertStatMap, globalAdvertStatMap);
        System.out.println("ret1=" + JSON.toJSONString(ret1));
        HashMap<Long, Double> advertPreInfo = new HashMap<Long, Double>();
        advertPreInfo.put(1L, 0.1);
        HashMap<Long, BudgetSmoothDo> advertBudgetInfo = new HashMap<Long, BudgetSmoothDo>();
        BudgetSmoothDo bdo1 = new BudgetSmoothDo();
        bdo1.setRatio(1.9);
        advertBudgetInfo.put(1L, bdo1);
        Map<Long, BackendFactor> ret2 = BackendCostOptimizer.getBackendAdvertInfo(advertPreInfo, ret1, advertBudgetInfo);
        System.out.println("ret2=" + JSON.toJSONString(ret2));
    }

    static {
        backendTypePriorityMap.put("1", 1.0);
        backendTypePriorityMap.put("2", 1.0);
        backendTypePriorityMap.put("3", 1.0);
        backendTypePriorityMap.put("4", 1.0);
        backendTypePriorityMap.put("5", 0.9);
        backendTypePriorityMap.put("6", 0.7);
        backendTypePriorityMap.put("7", 0.5);
        backendTypePriorityMap.put("8", 0.3);
    }
}

