/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.budget;

import cn.com.duiba.nezha.alg.alg.alg.BudgetSmoothAlg;
import cn.com.duiba.nezha.alg.alg.vo.BudgetDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetInfo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public class BudgetSmooth {
    public static double[] reqDist = new double[]{0.0, 3.0, 4.5, 5.5, 6.5, 7.5, 9.5, 13.0, 17.5, 22.0, 27.0, 32.0, 37.0, 43.0, 48.5, 53.5, 58.5, 63.5, 68.5, 74.0, 79.5, 85.5, 91.0, 96.0, 100.0};

    public static <T> Map<T, BudgetSmoothDo> getBudgetRatio(Map<T, BudgetInfo> advertBudgetInfoMap) {
        HashMap ret = new HashMap();
        if (AssertUtil.isNotEmpty(advertBudgetInfoMap)) {
            advertBudgetInfoMap.forEach((advert, budgetInfo) -> ret.put(advert, BudgetSmooth.getRatio(budgetInfo)));
        }
        return ret;
    }

    public static BudgetSmoothDo getRatio(BudgetInfo advertBudget) {
        BudgetSmoothDo ret = null;
        BudgetSmoothDo ret2 = null;
        if (advertBudget != null) {
            ret = BudgetSmooth.getMaxRatio(ret, BudgetSmooth.getBudgetSmooth(advertBudget.getAccountBudgetInfo(), false, 1L));
            ret = BudgetSmooth.getMaxRatio(ret, BudgetSmooth.getBudgetSmooth(advertBudget.getAdvertBudgetInfo(), false, 2L));
            ret2 = BudgetSmooth.getMaxRatio(ret2, BudgetSmooth.getBudgetSmooth(advertBudget.getOrientationBudgetInfo(), false, 3L));
            ret2 = BudgetSmooth.getMaxRatio(ret2, BudgetSmooth.getBudgetSmooth(advertBudget.getOrientationAndAppBudgetInfo(), false, 4L));
            ret2 = BudgetSmooth.getMaxRatio(ret2, BudgetSmooth.getBudgetSmooth(advertBudget.getOrientationAndTimeBudgetInfo(), true, 5L));
            if (ret == null) {
                ret = ret2;
            }
            if (ret2 != null && ret2.getRatio() != null) {
                ret = ret2;
            }
        }
        return ret;
    }

    public static BudgetSmoothDo getMaxRatio(BudgetSmoothDo cMaxRatio, BudgetSmoothDo nRatio) {
        BudgetSmoothDo ret = cMaxRatio;
        if (nRatio != null) {
            if (cMaxRatio == null) {
                ret = nRatio;
            } else {
                if (cMaxRatio.getRatio() == null && nRatio.getRatio() != null) {
                    ret = nRatio;
                }
                if (cMaxRatio.getRatio() != null && nRatio.getRatio() != null) {
                    ret = cMaxRatio.getRatio() > nRatio.getRatio() ? cMaxRatio : nRatio;
                }
            }
        }
        return ret;
    }

    public static BudgetSmoothDo getMaxRatio(Map<Long, BudgetSmoothDo> ratioMap) {
        BudgetSmoothDo ret = null;
        if (AssertUtil.isNotEmpty(ratioMap)) {
            for (long i = 1L; i <= 5L; ++i) {
                BudgetSmoothDo cBSD = ratioMap.get(i);
                if (cBSD == null || cBSD.getRatio() == null) continue;
                ret = cBSD;
            }
        }
        return ret;
    }

    public static BudgetSmoothDo getBudgetSmooth(BudgetDo budget, boolean isHour, Long type) {
        BudgetSmoothDo ret = null;
        if (budget != null) {
            ret = new BudgetSmoothDo();
            Double timeRatio = null;
            Double budgetRatio = null;
            timeRatio = isHour ? BudgetSmooth.getTimeRatio(budget.getTime(), budget.getStartTime(), budget.getEndTime()) : BudgetSmooth.getTimeRatio(budget.getTime());
            budgetRatio = BudgetSmooth.getBudgetRatio(budget.getBudget(), budget.getConsumeTotal());
            Double ratio = BudgetSmooth.getRatio(budgetRatio, timeRatio);
            ret.setBudgetDo(budget);
            ret.setBudgetRatio(budgetRatio);
            ret.setTimeRatio(timeRatio);
            ret.setType(type);
            if (!BudgetSmooth.isDelay(budget.getTime())) {
                ret.setRatio(ratio);
            }
        }
        return ret;
    }

    public static Double getRatio(Double budgetRatio, Double timeRatio) {
        Double ret = null;
        if (budgetRatio != null && timeRatio != null && timeRatio > 0.0 && budgetRatio > 0.0) {
            ret = DataUtil.division((Double)budgetRatio, (Double)timeRatio, (int)5);
        }
        return ret;
    }

    public static Double getBudgetRatio(Long budget, Long consumeTotal) {
        Double ret = null;
        if (budget != null && consumeTotal != null && budget > 10L) {
            Long consume = Math.max(1L, consumeTotal);
            ret = DataUtil.division((Long)consume, (Long)budget, (int)5);
            ret = Math.min(ret, 1.0);
        }
        return ret;
    }

    public static Double getTimeRatio(String updateTime, String startHour, String endHour) {
        Double ret = null;
        LocalTime updateTimeLT = LocalDateUtil.getLocalTime((String)updateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        if (updateTimeLT != null) {
            LocalTime startHourLT = LocalDateUtil.getLocalTime((String)startHour, (String)DateStyle.HH_MM.getValue());
            LocalTime endHourLT = LocalDateUtil.getLocalTime((String)endHour, (String)DateStyle.HH_MM.getValue());
            Long totalMinutes = LocalDateUtil.getBetweenSeconds((LocalTime)startHourLT, (LocalTime)endHourLT);
            Long usedMinutes = LocalDateUtil.getBetweenSeconds((LocalTime)startHourLT, (LocalTime)updateTimeLT);
            if (totalMinutes != null && usedMinutes != null && totalMinutes >= 30L) {
                ret = ((double)usedMinutes.longValue() + 1.0) / ((double)totalMinutes.longValue() + 1.0);
            }
        }
        return DataUtil.formatDouble(ret, (int)5);
    }

    public static boolean isDelay(String updateTime) {
        boolean ret = true;
        LocalDateTime updateTimeLocal = LocalDateUtil.getLocalDateTime((String)updateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        LocalDateTime currentTimeLocal = LocalDateTime.now();
        if (updateTimeLocal != null) {
            Duration duration = LocalDateUtil.getBetweenDuration((LocalDateTime)currentTimeLocal, (LocalDateTime)updateTimeLocal);
            Integer updateHour = updateTimeLocal.getHour();
            Integer currentHour = currentTimeLocal.getHour();
            if (duration != null && updateHour != null && currentHour != null && duration.toMinutes() <= 3L && updateHour == currentHour) {
                ret = false;
            }
        }
        return ret;
    }

    public static Double getTimeRatio(String updateTime) {
        Double ret = null;
        LocalDateTime updatetimeLocal = LocalDateUtil.getLocalDateTime((String)updateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        if (updatetimeLocal != null) {
            Integer hour = updatetimeLocal.getHour();
            Integer minute = updatetimeLocal.getMinute();
            if (hour != null && minute != null) {
                double ratio1 = reqDist[hour];
                double ratio2 = (reqDist[hour + 1] - reqDist[hour]) * ((double)minute.intValue() + 1.0) / 61.0;
                ret = (ratio1 + ratio2) / 100.0;
            }
        }
        return DataUtil.formatDouble(ret, (int)5);
    }

    public static void main(String[] args) {
        BudgetInfo budget = new BudgetInfo();
        BudgetDo ad = new BudgetDo();
        ad.setBudget(200000L);
        ad.setConsumeTotal(109999L);
        ad.setPeriodId(null);
        ad.setTime("2018-12-10 16:36:46");
        budget.setAdvertBudgetInfo(ad);
        BudgetDo at = new BudgetDo();
        at.setBudget(10000L);
        at.setConsumeTotal(60L);
        at.setPeriodId(76497L);
        at.setTime("2018-12-10 16:37:20");
        at.setStartTime("16:00");
        at.setEndTime("16:59");
        budget.setOrientationAndTimeBudgetInfo(at);
        BudgetSmoothDo ret = BudgetSmooth.getRatio(budget);
        System.out.println("ret = " + JSON.toJSONString((Object)ret));
        BudgetInfo budgetInfo = new BudgetInfo();
        budgetInfo.setAdvertBudgetInfo((BudgetDo)JSON.parseObject((String)"{\"time\":\"2018-12-11 11:38:30\",\"type\":\"6\",\"advertId\":40037,\"budget\":200000,\"consumeTotal\":100375}", BudgetDo.class));
        budgetInfo.setOrientationBudgetInfo((BudgetDo)JSON.parseObject((String)"{\"planId\":77214,\"time\":\"2018-12-11 11:38:30\",\"type\":\"5\",\"advertId\":40037,\"budget\":100000,\"consumeTotal\":9460}", BudgetDo.class));
        budgetInfo.setOrientationAndTimeBudgetInfo((BudgetDo)JSON.parseObject((String)"{\"periodId\":201638,\"planId\":77214,\"startTime\":\"11:00\",\"time\":\"2018-12-11 11:36:16\",\"endTime\":\"11:59\",\"type\":\"3\",\"advertId\":40037,\"budget\":10000,\"consumeTotal\":1020}", BudgetDo.class));
        System.out.println(BudgetSmoothAlg.getBudgetRatio(budgetInfo).getRatio());
    }
}

