/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.budget;

import cn.com.duiba.nezha.alg.alg.alg.BudgetSmoothAlg;
import cn.com.duiba.nezha.alg.alg.vo.BudgetDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetInfo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SmoothResultDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import java.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudgetSmoothNew {
    private static final Logger logger = LoggerFactory.getLogger(BudgetSmoothNew.class);
    public static double[] reqDist = new double[]{3.0, 4.5, 5.5, 6.5, 7.5, 9.5, 13.0, 17.5, 22.0, 27.0, 32.0, 37.0, 43.0, 48.5, 53.5, 58.5, 63.5, 68.5, 74.0, 79.5, 85.5, 91.0, 96.0, 100.0};
    public static Double retDistWeightSum = null;

    public static BudgetSmoothDo getRatio(BudgetDo budgetDo, BudgetSmoothDo lastBudgetSmoothDo) {
        BudgetSmoothDo ret = null;
        if (!BudgetSmoothNew.isValid(budgetDo).booleanValue()) {
            budgetDo = null;
            logger.warn("BudgetSmoothNew.getRatio(BudgetDo budgetDo, BudgetSmoothDo lastBudgetSmoothDo) input invalid");
        }
        BudgetDo lastBudgetDo = null;
        if (budgetDo != null && lastBudgetSmoothDo != null) {
            lastBudgetDo = BudgetSmoothNew.getLastBudgetDo(budgetDo, lastBudgetSmoothDo.getBudgetDo());
        }
        ret = BudgetSmoothNew.getBudgetSmooth(budgetDo, lastBudgetDo);
        Double smoothFactor = BudgetSmoothNew.updateSmoothFactor(ret);
        ret.setSmoothFactor(smoothFactor);
        return ret;
    }

    public static BudgetDo getLastBudgetDo(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        BudgetDo ret = null;
        if (BudgetSmoothNew.lastResultValid(budgetDo, lastBudgetDo).booleanValue()) {
            ret = lastBudgetDo;
        }
        return ret;
    }

    public static Boolean lastResultValid(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        Boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{budgetDo, lastBudgetDo})) {
            System.out.println("1");
            return false;
        }
        if (!BudgetSmoothNew.isValid(lastBudgetDo).booleanValue()) {
            System.out.println("2");
            return false;
        }
        if (!budgetDo.getTimeType().equals(lastBudgetDo.getTimeType())) {
            System.out.println("3");
            return false;
        }
        if (!budgetDo.getBudgetType().equals(lastBudgetDo.getBudgetType())) {
            System.out.println("4");
            return false;
        }
        if (!budgetDo.getBudget().equals(lastBudgetDo.getBudget())) {
            System.out.println("5");
            return false;
        }
        if (!budgetDo.getTimeType().equals(3L)) {
            if (!budgetDo.getStartTime().equals(lastBudgetDo.getStartTime())) {
                System.out.println("6");
                return false;
            }
            if (!budgetDo.getEndTime().equals(lastBudgetDo.getEndTime())) {
                System.out.println("7");
                return false;
            }
        }
        return ret;
    }

    public static Boolean isValid(BudgetDo advertDo) {
        Boolean ret = true;
        if (advertDo == null || AssertUtil.isAnyEmpty((Object[])new Object[]{advertDo.getBudgetType(), advertDo.getBudget(), advertDo.getTime(), advertDo.getTimeType()})) {
            return false;
        }
        if (advertDo.getBudget() == null || advertDo.getBudget() < 2000L) {
            return false;
        }
        if (advertDo.getBudgetType().equals(4L) || advertDo.getBudgetType().equals(5L)) {
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertDo.getStartTime(), advertDo.getEndTime()})) {
                return false;
            }
            if (advertDo.getTimeType().equals(3L)) {
                return false;
            }
        }
        if ((advertDo.getTimeType().equals(1L) || advertDo.getTimeType().equals(2L)) && AssertUtil.isAnyEmpty((Object[])new Object[]{advertDo.getStartTime(), advertDo.getEndTime()})) {
            return false;
        }
        return ret;
    }

    public static BudgetSmoothDo getBudgetSmooth(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        BudgetSmoothDo ret = new BudgetSmoothDo();
        Long budgetType = null;
        Long timeType = null;
        Double ratio = null;
        Double timeRatio = null;
        Double budgetRatio = null;
        Double currentRatio = null;
        Double currentTimeRatio = null;
        Double currentBudgetRatio = null;
        Boolean currentValid = false;
        Boolean isSmooth = false;
        if (budgetDo != null) {
            budgetType = budgetDo.getBudgetType();
            timeType = budgetDo.getTimeType();
            timeRatio = timeType.equals(3L) ? BudgetSmoothNew.getTimeRatio(budgetDo.getTime()) : BudgetSmoothNew.getTimeRatio(budgetDo.getTime(), budgetDo.getStartTime(), budgetDo.getEndTime());
            budgetRatio = BudgetSmoothNew.getBudgetRatio(budgetDo.getBudget(), budgetDo.getConsumeTotal());
            ratio = BudgetSmoothNew.getRatio(budgetRatio, timeRatio);
            if (lastBudgetDo != null) {
                Double lastTimeRatio = null;
                lastTimeRatio = timeType.equals(3L) ? BudgetSmoothNew.getTimeRatio(lastBudgetDo.getTime()) : BudgetSmoothNew.getTimeRatio(lastBudgetDo.getTime(), lastBudgetDo.getStartTime(), lastBudgetDo.getEndTime());
                Double lastBudgetRatio = BudgetSmoothNew.getBudgetRatio(lastBudgetDo.getBudget(), lastBudgetDo.getConsumeTotal());
                currentTimeRatio = DataUtil.addDouble((Double)timeRatio, (Double)(-1.0 * lastTimeRatio), (int)7);
                currentBudgetRatio = DataUtil.addDouble((Double)budgetRatio, (Double)(-1.0 * lastBudgetRatio), (int)7);
                currentRatio = BudgetSmoothNew.getRatio(currentBudgetRatio, currentTimeRatio);
                if (currentTimeRatio > 0.0) {
                    currentValid = true;
                }
            }
            if (!BudgetSmoothNew.isTimeValid(budgetDo.getTime(), budgetDo.getStartTime(), budgetDo.getEndTime(), timeRatio, timeType)) {
                ratio = null;
                currentRatio = null;
                isSmooth = false;
            } else {
                isSmooth = true;
            }
        }
        ret.setBudgetDo(budgetDo);
        ret.setBudgetRatio(budgetRatio);
        ret.setTimeRatio(timeRatio);
        ret.setCurrentBudgetRatio(currentBudgetRatio);
        ret.setCurrentTimeRatio(currentTimeRatio);
        ret.setTimeType(timeType);
        ret.setBudgetType(budgetType);
        ret.setRatio(ratio);
        ret.setCurrentValid(currentValid);
        ret.setCurrentRatio(currentRatio);
        ret.setNeedSmooth(isSmooth);
        return ret;
    }

    public static Double getRatio(Double budgetRatio, Double timeRatio) {
        Double ret = null;
        if (budgetRatio != null && timeRatio != null && timeRatio > 0.0 && budgetRatio > 0.0) {
            ret = DataUtil.division((Double)budgetRatio, (Double)timeRatio, (int)5);
        }
        return ret;
    }

    public static Double getBudgetRatio(Long budget, Long consumeTotal) {
        Double ret = null;
        if (budget != null && consumeTotal != null && budget > 10L) {
            Long consume = Math.max(1L, consumeTotal);
            ret = DataUtil.division((Long)consume, (Long)budget, (int)5);
            ret = Math.min(ret, 1.0);
        }
        return ret;
    }

    public static Double getTimeRatio(String updateTime) {
        return BudgetSmoothNew.getTimeRatio(updateTime, "00:00", "23:59");
    }

    public static Double getTimeRatio(String updateTime, String startTime, String endTime) {
        Double ret = null;
        if (endTime != null && endTime.equals("24:00")) {
            endTime = "23:59";
        }
        Double timeRatioS2E = BudgetSmoothNew.getTimeRatio(startTime, endTime);
        Double timeRatioS2U = BudgetSmoothNew.getTimeRatio(startTime, updateTime);
        if (timeRatioS2E != null && timeRatioS2U != null && (ret = DataUtil.division((Double)timeRatioS2U, (Double)timeRatioS2E, (int)5)) != null && ret > 1.01) {
            ret = null;
        }
        return ret;
    }

    public static Double getTimeRatio(String startTime, String endTime) {
        Double ret = null;
        LocalTime startTimeLT = LocalDateUtil.getLocalTime((String)startTime, (String)DateStyle.HH_MM.getValue());
        LocalTime endTimeLT = LocalDateUtil.getLocalTime((String)endTime, (String)DateStyle.HH_MM.getValue());
        if (startTimeLT != null && endTimeLT != null && endTimeLT.isAfter(startTimeLT)) {
            Double startRatio = BudgetSmoothNew.getTimeRatio(startTimeLT.getHour(), startTimeLT.getMinute());
            Double endRatio = BudgetSmoothNew.getTimeRatio(endTimeLT.getHour(), endTimeLT.getMinute());
            ret = DataUtil.addDouble((Double)endRatio, (Double)(-1.0 * startRatio), (int)5);
        }
        return ret;
    }

    public static Double getTimeRatio(int hour, int minute) {
        Double ret = null;
        double hourWeight = 0.0;
        double minuteWeight = 0.0;
        for (int i = 0; i < hour; ++i) {
            hourWeight += reqDist[i];
        }
        if (hour < 24) {
            minuteWeight = reqDist[hour] * ((double)minute + 0.0) / 60.0;
        }
        ret = DataUtil.division((Double)(hourWeight + minuteWeight), (Double)retDistWeightSum);
        return DataUtil.formatDouble((Double)ret, (int)5);
    }

    public static boolean isTimeValid(String updateTime, String startTime, String endTime, Double timeRatio, Long timeType) {
        boolean ret = true;
        LocalTime updateTimeLocal = LocalDateUtil.getLocalTime((String)updateTime, (String)DateStyle.HH_MM.getValue());
        LocalTime startTimeLocal = LocalDateUtil.getLocalTime((String)startTime, (String)DateStyle.HH_MM.getValue());
        LocalTime endTimeLocal = LocalDateUtil.getLocalTime((String)endTime, (String)DateStyle.HH_MM.getValue());
        LocalTime currentTimeLocal = LocalTime.now();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{updateTimeLocal, startTimeLocal, endTimeLocal, timeType, timeRatio})) {
            return false;
        }
        if (currentTimeLocal.isAfter(endTimeLocal) || currentTimeLocal.isBefore(startTimeLocal)) {
            return false;
        }
        if (timeType.equals(3L) && timeRatio > 0.95) {
            return false;
        }
        if (timeType.equals(2L) && timeRatio > 0.9) {
            return false;
        }
        if (timeType.equals(1L) && timeRatio > 0.9) {
            return false;
        }
        if (LocalDateUtil.getBetweenSeconds((LocalTime)updateTimeLocal, (LocalTime)currentTimeLocal) > 600L) {
            return false;
        }
        return ret;
    }

    public static Boolean equals(Long a, Long b) {
        Boolean ret = false;
        if (AssertUtil.isAllEmpty((Object[])new Object[]{a, b})) {
            ret = true;
        } else if (AssertUtil.isAnyEmpty((Object[])new Object[]{a, b})) {
            ret = false;
        } else if (a.equals(b)) {
            ret = true;
        }
        return ret;
    }

    public static Double updateSmoothFactor(BudgetSmoothDo budgetSmoothDo) {
        Double ret = 1.0;
        if (budgetSmoothDo == null) {
            return 1.0;
        }
        Double smoothFactor = budgetSmoothDo.getSmoothFactor();
        if (smoothFactor == null) {
            smoothFactor = 1.0;
        }
        if (budgetSmoothDo.getNeedSmooth().booleanValue() && budgetSmoothDo.getRatio() != null && budgetSmoothDo.getRatio() > 1.1) {
            Double currentFactor = 1.0;
            Double totalFactor = 1.0;
            if (budgetSmoothDo.getCurrentValid().booleanValue() && budgetSmoothDo.getCurrentRatio() != null) {
                currentFactor = 0.8 + 0.2 * (1.0 / (budgetSmoothDo.getCurrentRatio() + 1.0E-6));
            }
            totalFactor = 0.7 + 0.3 * (1.0 / (budgetSmoothDo.getRatio() + 1.0E-6));
            smoothFactor = smoothFactor * Math.min(currentFactor, 3.0) * Math.min(totalFactor, 2.0);
        }
        smoothFactor = BudgetSmoothNew.noiseSmoother(smoothFactor, 0.1, 1.0);
        ret = DataUtil.formatDouble((Double)smoothFactor, (int)5);
        return ret;
    }

    public static Double noiseSmoother(Double point, Double lowerLimit, Double upperLimit) {
        Double ret = point;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{upperLimit, lowerLimit})) {
            return ret;
        }
        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }
        return ret;
    }

    public static SmoothResultDo getSmooth(BudgetSmoothDo budgetSmoothDo) {
        SmoothResultDo ret = new SmoothResultDo();
        ret.setGiveUp(false);
        if (budgetSmoothDo != null) {
            Double smoothFactor = budgetSmoothDo.getSmoothFactor();
            if (smoothFactor != null && smoothFactor < 1.0 && Math.random() > smoothFactor) {
                ret.setGiveUp(true);
            }
            ret.setSmmothFactor(smoothFactor);
            ret.setBudgetType(budgetSmoothDo.getBudgetType());
            ret.setTimeType(budgetSmoothDo.getTimeType());
        }
        return ret;
    }

    public static void main(String[] args) {
        BudgetInfo budget = new BudgetInfo();
        BudgetDo ad = new BudgetDo();
        ad.setBudget(200000L);
        ad.setConsumeTotal(100000L);
        ad.setPeriodId(null);
        ad.setStartTime("00:00");
        ad.setEndTime("22:00");
        ad.setBudgetType(3L);
        ad.setTimeType(3L);
        ad.setTime("18:21");
        budget.setOrientationBudgetInfo(ad);
        BudgetDo last = new BudgetDo();
        last.setBudget(200000L);
        last.setConsumeTotal(99000L);
        last.setPeriodId(null);
        last.setStartTime("00:00");
        last.setEndTime("23:00");
        last.setBudgetType(3L);
        last.setTimeType(3L);
        last.setTime("18:11");
        BudgetSmoothDo budgetSmoothDo = new BudgetSmoothDo();
        budgetSmoothDo.setBudgetDo(last);
        System.out.println(JSON.toJSONString((Object)BudgetSmoothAlg.getBudgetRatio(ad, budgetSmoothDo)));
    }

    static {
        Double hourWeightSum = 0.0;
        for (int i = 0; i < reqDist.length; ++i) {
            hourWeightSum = hourWeightSum + reqDist[i];
        }
        retDistWeightSum = hourWeightSum;
    }
}

