package cn.com.duiba.nezha.alg.alg.adx.algplus;

import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdDecisionRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdDecisionResultDo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxAlg {

    private static final Logger logger = LoggerFactory.getLogger(AdxAlg.class);


    /**
     * 创意推荐
     *
     * @param rcmdRequestDo
     * @return
     */
    public static AdxIdeaRcmdResultDo ideaRcmdAlg(AdxIdeaRcmdRequestDo rcmdRequestDo) {
        AdxIdeaRcmdResultDo ret = null;

        try {

            ret = IdeaRcmdAlg.getIdeaRcmd(rcmdRequestDo);

        } catch (Exception e) {

            logger.error("AdxAlg.ideaRcmdAlg error", e);
        }
        return ret;
    }



    /**
     *  PD决策
     *
     * @param decisionRequestDo
     * @return
     */
    public static AdxPdDecisionResultDo pdDecisionAlg(AdxPdDecisionRequestDo decisionRequestDo) {
        AdxPdDecisionResultDo ret = null;

        try {

            ret = PdDecisionAlg.getPdDecision(decisionRequestDo);

        } catch (Exception e) {

            logger.error("AdxAlg.pdDecisionAlg error", e);
        }
        return ret;
    }

}
