package cn.com.duiba.nezha.alg.alg.vo.adx.pd;

import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;

import java.util.List;
import java.util.Map;


/**
 * 创意推荐入参对象
 */
public class AdxIdeaRcmdRequestDo {

    /**
     * 点击率预估模型
     */
    private FM fmModel;

    /**
     * 编码器模型
     */
    private CODER coderModel;

    /**
     * TF模型
     */
    private LocalTFModel ltfModel;

    /**
     * 可投放创意特征对象List
     *
     * 限定有效创意，拼接创意特征
     */
    private List<AdxIdeaFeatureDo> ideaFeatureList;

    /**
     * 非创意特征对象(静态特征对象)
     */
    private AdxFeatureDo adxFeatureDo;

    /**
     * 可投放创意统计数据(key:创意id)
     */
    private Map<Long, AdxStatsDo> ideaStatsList;

    /**
     * 所属资源位统计数据
     */
    private AdxStatsDo resoStats;



    public FM getFmModel() {
        return fmModel;
    }

    public void setFmModel(FM fmModel) {
        this.fmModel = fmModel;
    }

    public CODER getCoderModel() {
        return coderModel;
    }

    public void setCoderModel(CODER coderModel) {
        this.coderModel = coderModel;
    }

    public LocalTFModel getLtfModel() {
        return ltfModel;
    }

    public void setLtfModel(LocalTFModel ltfModel) {
        this.ltfModel = ltfModel;
    }

    public List<AdxIdeaFeatureDo> getIdeaFeatureList() {
        return ideaFeatureList;
    }

    public void setIdeaFeatureList(List<AdxIdeaFeatureDo> ideaFeatureList) {
        this.ideaFeatureList = ideaFeatureList;
    }

    public AdxFeatureDo getAdxFeatureDo() {
        return adxFeatureDo;
    }

    public void setAdxFeatureDo(AdxFeatureDo adxFeatureDo) {
        this.adxFeatureDo = adxFeatureDo;
    }

    public Map<Long, AdxStatsDo> getIdeaStatsList() {
        return ideaStatsList;
    }

    public void setIdeaStatsList(Map<Long, AdxStatsDo> ideaStatsList) {
        this.ideaStatsList = ideaStatsList;
    }

    public AdxStatsDo getResoStats() {
        return resoStats;
    }

    public void setResoStats(AdxStatsDo resoStats) {
        this.resoStats = resoStats;
    }
}
