package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class AdxFilterTask {

    /**
     * 算法接口2-流量预过滤定时任务
     * (根据缓存数据，调用频率：30min调用1次）
     *
     * @param directlyIdeaDoInfo   直投创意信息
     * @param lastFilterInfo 上一次出参（定时任务）
     * @return
     */

    private static final Logger logger = LoggerFactory.getLogger(AdxFilterTask.class);

    public static AdxFilterInfoDo getFilterInfo(AdxFlowInfoDo flowInfo,
                                                AdxFilterInfoDo lastFilterInfo) {

        AdxFilterInfoDo ret = new AdxFilterInfoDo();

        try {

            Integer preIntervalSize = 6;           // ctr预估区间个数(划分：0.002, 0.003, 0.005, 0.007, 0.01)
            Double minRoi = 1.0;                   // 默认设置ROI
            Double defaultRate = 0.0;              // 默认过滤比例(小数)
            Double filterRate = 0.9;               // 过滤比例(小数)
            boolean dayConfident = false;          // 当天创意统计指标是否置信

            Map<Integer, Double> filterMap = new HashMap<>(preIntervalSize);
            Map<Integer, Double> roiDayMap = new HashMap<>(preIntervalSize);
            Map<Integer, Double> roiHourMap = new HashMap<>(preIntervalSize);
            Map<Integer, Double> ctrDayMap = new HashMap<>(preIntervalSize);
            Map<Integer, Double> ctrHourMap = new HashMap<>(preIntervalSize);
            Double roiDay = null, roiHour = null, ctrDay = null, ctrHour = null;

            Map<Integer, AdxIndexStatDo> intervalDayStats = new HashMap<>(preIntervalSize);
            Map<Integer, AdxIndexStatDo> intervalHourStats = new HashMap<>(preIntervalSize);


            //1.获取统计数据
            if (AssertUtil.isNotEmpty(flowInfo)) {

                Long groupId = flowInfo.getGroupId(); //推广组ID
                minRoi = AdxStatData.nullToMinDefault(flowInfo.getMinRoi(), 1.0); //设置ROI

                //创意维度
                AdxIndexStatDo ideaDayStats = flowInfo.getIdeaDayStats();
                AdxIndexStatDo ideaHourStats = flowInfo.getIdeaHourStats();
                AdxIndexStatsDo ideaDayComputes = AdxStatData.adxIndexCompute(ideaDayStats);
                AdxIndexStatsDo ideaHourComputes = AdxStatData.adxIndexCompute(ideaHourStats);
                dayConfident = ideaDayComputes.getConfident();
                roiDay = ideaDayComputes.getRoi();
                roiHour = ideaHourComputes.getRoi();
                ctrDay = ideaDayComputes.getCtr();
                ctrHour = ideaHourComputes.getCtr();


                //分区间维度
                intervalDayStats = flowInfo.getPreIntervalDayStats();
                intervalHourStats = flowInfo.getPreIntervalHourStats();

            }

            //2.获取数据信息
            Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HHmm"));
            Double lastMinRoi = minRoi;  //上一次设置ROI
            if (AssertUtil.isNotEmpty(lastFilterInfo)) {
                lastMinRoi = AdxStatData.nullToDefault(lastFilterInfo.getCurrentMinRoi(), 1.0);
            }



            //3.判断过滤比例
            for (int key = 1; key <= preIntervalSize; ++key) {

                //分区间维度 roi和ctr
                AdxIndexStatDo intervalHour = new AdxIndexStatDo();
                AdxIndexStatDo intervalDay = new AdxIndexStatDo();
                if (AssertUtil.isAllNotEmpty(intervalHourStats, intervalDayStats)) {
                    intervalHour = intervalHourStats.get(key);
                    intervalDay = intervalDayStats.get(key);
                }

                AdxIndexStatsDo intervalHourComputes = AdxStatData.adxIndexCompute(intervalHour);
                AdxIndexStatsDo intervalDayComputes = AdxStatData.adxIndexCompute(intervalDay);
                Double roiIntervalHour = intervalHourComputes.getRoi();
                Double roiIntervalDay = intervalDayComputes.getRoi();
                Double ctrIntervalHour = intervalHourComputes.getCtr();
                Double ctrIntervalDay = intervalDayComputes.getCtr();

                //实时数据不置信，采用融合roi
                if (AssertUtil.isEmpty(roiIntervalHour)) {
                    roiIntervalHour = AdxStatData.getConRoi(intervalHourComputes, intervalDayComputes);
                }

                roiHourMap.put(key, roiIntervalHour);
                roiDayMap.put(key, roiIntervalDay);
                ctrHourMap.put(key, ctrIntervalHour);
                ctrDayMap.put(key, ctrIntervalDay);

                filterMap.put(key, defaultRate);
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null
                        || (currentTime >= 0L && currentTime < 30L)
                        || dayConfident == false) {

                    //重置：不过滤--设置ROI与上一次ROI不相同; 更新时间为00:00:00-00:30:00;当天创意统计指标不置信;
                    filterMap.put(key, defaultRate);

                } else {

                    //预估区间6：[0.01,1) 不过滤
                    if (key == 6) {
                        filterMap.put(key, defaultRate);

                    } else {

                        //根据分区间实时ROI判断过滤比例（ROI<0.85，过滤90%）
                        if (roiIntervalHour != null &&
                                (roiIntervalHour < 0.85 )) {
                            filterMap.put(key, filterRate);
                        }

                    }
                }

            }

            ret.setFilterMap(filterMap);
            ret.setCurrentMinRoi(minRoi);
            ret.setDayConfident(dayConfident);

            ret.setRoiDay(roiDay);
            ret.setRoiHour(roiHour);
            ret.setCtrDay(ctrDay);
            ret.setCtrHour(ctrHour);
            ret.setRoiDayInterval(roiDayMap);
            ret.setRoiHourInterval(roiHourMap);
            ret.setCtrDayInterval(ctrDayMap);
            ret.setCtrHourInterval(ctrHourMap);



        } catch (Exception e) {
            logger.error("AdxFilterTask.getFilterInfo error:" + e);

        }

        return ret;

    }

}
