/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.algplus;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdeaRcmdAlg {
    private static final Logger logger = LoggerFactory.getLogger(IdeaRcmdAlg.class);
    static double[] weight = new double[]{100.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5};

    public static AdxIdeaRcmdResultDo getIdeaRcmd(AdxIdeaRcmdRequestDo rcmdRequestDo) {
        AdxIdeaRcmdResultDo ret = new AdxIdeaRcmdResultDo();
        try {
            Long ideaId;
            Double preWeight = 0.1;
            Long giveUpType = IdeaRcmdAlg.getGiveUpType(rcmdRequestDo);
            HashMap<Long, Double> preCtrMap = new HashMap<Long, Double>();
            Map preClickValueMap = new HashMap();
            HashMap<Long, Double> statCtrMap = new HashMap<Long, Double>();
            HashMap<Long, Double> statClickValueMap = new HashMap<Long, Double>();
            HashMap<Long, Double> statDayCtrMap = new HashMap<Long, Double>();
            HashMap<Long, Double> statDayClickValueMap = new HashMap<Long, Double>();
            Double statCtrResource = null;
            Double statClickValueResource = null;
            HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
            if (AssertUtil.isEmpty((Object)giveUpType)) {
                FM fmModel = rcmdRequestDo.getFmModel();
                CODER coderModel = rcmdRequestDo.getCoderModel();
                LocalTFModel ltfModel = rcmdRequestDo.getLtfModel();
                AdxFeatureDo adxFeatureDo = rcmdRequestDo.getAdxFeatureDo();
                List<AdxIdeaFeatureDo> ideaList = rcmdRequestDo.getIdeaFeatureList();
                Map staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
                for (AdxIdeaFeatureDo ideaDo : ideaList) {
                    Long ideaId2 = ideaDo.getIdeaId();
                    AdxFeatureDo dynamicDo = new AdxFeatureDo();
                    dynamicDo.setIdeaId(ideaId2);
                    dynamicDo.setButtonText(ideaDo.getButtonText());
                    dynamicDo.setIconH(ideaDo.getIconH());
                    dynamicDo.setIconW(ideaDo.getIconW());
                    dynamicDo.setMjPicType(ideaDo.getMjPicType());
                    dynamicDo.setIdeaPicH1(ideaDo.getIdeaPicH1());
                    dynamicDo.setIdeaPicW1(ideaDo.getIdeaPicW1());
                    dynamicDo.setIdeaPicH2(ideaDo.getIdeaPicH2());
                    dynamicDo.setIdeaPicW2(ideaDo.getIdeaPicW2());
                    dynamicDo.setIdeaPicH3(ideaDo.getIdeaPicH3());
                    dynamicDo.setIdeaPicW3(ideaDo.getIdeaPicW3());
                    dynamicDo.setIdeaPicNum(ideaDo.getIdeaPicNum());
                    dynamicDo.setStyleStandard(ideaDo.getStyleStandard());
                    Map dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic((AdxFeatureDo)dynamicDo, (AdxFeatureDo)adxFeatureDo);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
                    featureMapDo.setStaticFeatureMap(staticFeatureMap);
                    featureMap.put(ideaId2, featureMapDo);
                    Double pCtr = fmModel.predict(featureMapDo);
                    preCtrMap.put(ideaId2, pCtr);
                }
                preClickValueMap = coderModel.predictWithLocalTFNew(featureMap, ltfModel);
            }
            if (AssertUtil.isNotEmpty((Object)rcmdRequestDo)) {
                AdxStatsDo resoStats = rcmdRequestDo.getResoStats();
                AdxIndexStatDo resoLast20MinStat = null;
                if (AssertUtil.isNotEmpty((Object)resoStats)) {
                    resoLast20MinStat = resoStats.getLast20MinStat();
                }
                AdxIndexStatsDo resoStatsMin = AdxStatData.adxIndexCompute(resoLast20MinStat);
                statCtrResource = resoStatsMin.getCtr();
                statClickValueResource = resoStatsMin.getClickValue();
                Map<Long, AdxStatsDo> ideaStatsList = rcmdRequestDo.getIdeaStatsList();
                if (AssertUtil.isNotEmpty(ideaStatsList)) {
                    for (Map.Entry<Long, AdxStatsDo> entry : ideaStatsList.entrySet()) {
                        ideaId = entry.getKey();
                        AdxStatsDo ideaStats = entry.getValue();
                        AdxIndexStatDo ideaLast20MinStat = ideaStats.getLast20MinStat();
                        AdxIndexStatDo ideaLast1DayStat = ideaStats.getLast1DayStat();
                        AdxIndexStatsDo ideaStatsMin = AdxStatData.adxIndexCompute(ideaLast20MinStat);
                        AdxIndexStatsDo ideaStatsDay = AdxStatData.adxIndexCompute(ideaLast1DayStat);
                        statCtrMap.put(ideaId, ideaStatsMin.getCtr());
                        statClickValueMap.put(ideaId, ideaStatsMin.getClickValue());
                        statDayCtrMap.put(ideaId, ideaStatsDay.getCtr());
                        statDayClickValueMap.put(ideaId, ideaStatsDay.getClickValue());
                    }
                }
            }
            Long bestIdeaId = null;
            if (AssertUtil.isNotEmpty((Object)rcmdRequestDo)) {
                Long manualIdeaId = rcmdRequestDo.getManualIdeaId();
                if (AssertUtil.isNotEmpty((Object)manualIdeaId)) {
                    bestIdeaId = manualIdeaId;
                } else {
                    HashMap<Long, Double> preExpValueMap = new HashMap<Long, Double>();
                    List<AdxIdeaFeatureDo> ideaList = rcmdRequestDo.getIdeaFeatureList();
                    if (AssertUtil.isNotEmpty(ideaList)) {
                        for (AdxIdeaFeatureDo ideaDo : ideaList) {
                            ideaId = ideaDo.getIdeaId();
                            Double pCtr = (Double)preCtrMap.get(ideaId);
                            Double sCtr = AdxStatData.nullToDefault((Double)statCtrMap.get(ideaId), statCtrResource);
                            sCtr = AdxStatData.nullToDefault(sCtr, (Double)statDayCtrMap.get(ideaId));
                            Double conCtr = AdxStatData.getConCtr(pCtr, sCtr, preWeight);
                            Double pClickValue = (Double)preClickValueMap.get(ideaId);
                            Double sClickValue = AdxStatData.nullToDefault((Double)statClickValueMap.get(ideaId), statClickValueResource);
                            sClickValue = AdxStatData.nullToDefault(sClickValue, (Double)statDayClickValueMap.get(ideaId));
                            Double conClickValue = AdxStatData.getConClickValue(pClickValue, sClickValue, preWeight);
                            Double preExpValue = AdxStatData.nullToMinDefault(conCtr * conClickValue, 0.0);
                            preExpValueMap.put(ideaId, preExpValue);
                        }
                        bestIdeaId = IdeaRcmdAlg.getBestIdeaId(ideaList, preExpValueMap);
                    }
                }
            }
            HashMap<String, String> combineFeatureMap = new HashMap<String, String>();
            FeatureMapDo bestFeatureMap = (FeatureMapDo)featureMap.get(bestIdeaId);
            if (AssertUtil.isNotEmpty((Object)bestFeatureMap) && AssertUtil.isNotEmpty((Map)bestFeatureMap.getStaticFeatureMap()) && AssertUtil.isNotEmpty((Map)bestFeatureMap.getDynamicFeatureMap())) {
                combineFeatureMap.putAll(bestFeatureMap.getStaticFeatureMap());
                combineFeatureMap.putAll(bestFeatureMap.getDynamicFeatureMap());
            }
            ret.setIdeaFeatureMap(combineFeatureMap);
            ret.setIdeaId(bestIdeaId);
            ret.setGiveUpType(giveUpType);
            ret.setPreCtr((Double)preCtrMap.get(bestIdeaId));
            ret.setStatCtr((Double)statCtrMap.get(bestIdeaId));
            ret.setPreClickValue((Double)preClickValueMap.get(bestIdeaId));
            ret.setStatClickValue((Double)statClickValueMap.get(bestIdeaId));
            ret.setStatCtrResource(statCtrResource);
            ret.setStatClickValueResource(statClickValueResource);
        }
        catch (Exception e) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd error", (Throwable)e);
        }
        return ret;
    }

    private static Long getGiveUpType(AdxIdeaRcmdRequestDo rcmdRequestDo) {
        Long ret = null;
        if (rcmdRequestDo == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid , params adxIdeaRcmdRequestDo is null");
            return 1L;
        }
        if (rcmdRequestDo.getFmModel() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid , params fmModel is null");
            return 2L;
        }
        if (rcmdRequestDo.getCoderModel() == null) {
            logger.warn("IdeaRcmdAlg.getIdeaRcmd() input params valid ,params coderModel is null");
            return 3L;
        }
        if (rcmdRequestDo.getLtfModel() == null) {
            logger.warn("IdeaRcmdAlg.getIdeaRcmd() input params valid ,params ltfModel is null");
            return 4L;
        }
        if (AssertUtil.isEmpty(rcmdRequestDo.getIdeaFeatureList())) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid ,params ideaFeatureList is empty");
            return 5L;
        }
        if (rcmdRequestDo.getAdxFeatureDo() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid ,params adxFeatureDo is null");
            return 6L;
        }
        return ret;
    }

    public static Long getBestIdeaId(List<AdxIdeaFeatureDo> ideaList, Map<Long, Double> valueMap) {
        Long ret = null;
        if (AssertUtil.isNotEmpty(ideaList)) {
            int size = ideaList.size();
            if (size == 1) {
                AdxIdeaFeatureDo bestIdeaDo = ideaList.get(0);
                ret = bestIdeaDo.getIdeaId();
            } else {
                ArrayList<Double> flowRateList = new ArrayList<Double>(size);
                if (AssertUtil.isNotEmpty(valueMap) && !valueMap.isEmpty()) {
                    Map<Long, Double> sortedMap = AdxStatData.sortMapByValueDescend(valueMap);
                    ArrayList<Long> sortedKeyList = new ArrayList<Long>(sortedMap.keySet());
                    ArrayList<Double> sortedValueList = new ArrayList<Double>(sortedMap.values());
                    Double maxExpValue = (Double)sortedValueList.get(0);
                    Double minExpValue = (Double)sortedValueList.get(size - 1);
                    for (int ind = 0; ind < size; ++ind) {
                        if (maxExpValue.equals(minExpValue)) {
                            flowRateList.add(weight[0]);
                            continue;
                        }
                        if (ind < weight.length) {
                            flowRateList.add(weight[ind]);
                            continue;
                        }
                        flowRateList.add(weight[weight.length - 1]);
                    }
                    Integer retIndex = AdxStatData.flowSplit(flowRateList);
                    ret = (Long)sortedKeyList.get(retIndex);
                }
            }
        }
        return ret;
    }
}

