/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AdxStatData {
    private static long ADX_MULTIPLIER = 10000000L;

    public static Map<String, Long> getStrategyStatData(String strategy, ArrayList<AdxStrategyDo> strategyDoList) {
        HashMap<String, Long> retMap = new HashMap<String, Long>();
        Long defaultCnt = 0L;
        Long defaultConsume = 0L;
        Long bidCnt = defaultCnt;
        Long sucCnt = defaultCnt;
        Long expCnt = defaultCnt;
        Long clickCnt = defaultCnt;
        Long adxConsume = defaultConsume;
        Long advertConsume = defaultConsume;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{strategy, strategyDoList})) {
            List<AdxLevelDo> strategyDo = StrategyBid.getStrategyInfo(strategyDoList, strategy);
            bidCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID.getCode(), defaultCnt);
            sucCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID_SUC.getCode(), defaultCnt);
            expCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.EXP.getCode(), defaultCnt);
            clickCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.CLICK.getCode(), defaultCnt);
            adxConsume = DataUtil.double2Long((double)(StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADX_CONSUME.getCode(), defaultConsume) / ADX_MULTIPLIER), (Long)1L);
            advertConsume = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
        }
        retMap.put(AdxIndex.BID.getCode(), bidCnt);
        retMap.put(AdxIndex.BID_SUC.getCode(), sucCnt);
        retMap.put(AdxIndex.EXP.getCode(), expCnt);
        retMap.put(AdxIndex.CLICK.getCode(), clickCnt);
        retMap.put(AdxIndex.ADX_CONSUME.getCode(), adxConsume);
        retMap.put(AdxIndex.ADVERT_CONSUME.getCode(), advertConsume);
        return retMap;
    }

    public static Map<String, Long> getlevelIndexStat(String strategy, String indexLabel, ArrayList<AdxStrategyDo> strategyDoList) {
        HashMap<String, Long> retMap = new HashMap();
        Long defaultValue = 0L;
        List<AdxLevelDo> strategyDo = StrategyBid.getStrategyInfo(strategyDoList, strategy);
        retMap = StrategyBid.getLevelIndex(strategyDo, indexLabel, defaultValue);
        if (indexLabel.equals(AdxIndex.ADX_CONSUME.getCode())) {
            retMap.replaceAll((k, v) -> DataUtil.double2Long((Double)DataUtil.division((Long)v, (Long)ADX_MULTIPLIER)));
        }
        return retMap;
    }

    public static Double getRoi(Map<String, Long> mapInfo, Double targetRoi) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultAdxConsume = 50L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long adxConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            Long advertConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);
            ret = adxConsume >= defaultAdxConsume ? DataUtil.division((Long)advertConsume, (Long)adxConsume, (int)6) : DataUtil.division((Double)((double)advertConsume.longValue() + (double)defaultAdxConsume.longValue() * targetRoi), (Long)(adxConsume + defaultAdxConsume), (int)6);
        }
        return ret;
    }

    public static Map<String, Double> getLevelRoi(Map<String, Long> adxMap, Map<String, Long> advertMap, Double targetRoi) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double ret = 0.0;
        Long defaultAdxConsume = 25L;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxMap, advertMap})) {
                if (adxMap.get(key) >= defaultAdxConsume) {
                    ret = DataUtil.division((Long)advertMap.get(key), (Long)adxMap.get(key), (int)6);
                    retMap.put(key, ret);
                    continue;
                }
                ret = DataUtil.division((Double)((double)advertMap.get(key).longValue() + (double)defaultAdxConsume.longValue() * targetRoi), (Long)(adxMap.get(key) + defaultAdxConsume), (int)6);
                retMap.put(key, ret);
                continue;
            }
            retMap.put(key, 0.0);
        }
        return retMap;
    }

    public static Map<String, Double> getRoiFactorRectify(Map<String, Double> roiMap, Map<String, Long> adxConsumeLevelMs, AdxDirectlyFactorDo directlyFactorDoInfo) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Long adxConsumeLimit = 50L;
        Long adxConsumeBaseLimit = 25L;
        Double baseRoi = AdxStatData.nullToMinDefault(roiMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()), 0.0);
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            retMap.put(key, roiMap.get(key));
        }
        if (AssertUtil.isNotEmpty((Object)directlyFactorDoInfo)) {
            Map<String, Double> factorMap = directlyFactorDoInfo.getFactorExploreMap();
            Double baseFactor = 1.0;
            if (AssertUtil.isNotEmpty(factorMap)) {
                baseFactor = AdxStatData.nullToMinDefault(factorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()), 1.0);
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode()) || !AssertUtil.isNotEmpty(adxConsumeLevelMs) || adxConsumeLevelMs.get(key) >= adxConsumeLimit || adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < adxConsumeBaseLimit) continue;
                Double diff = DataUtil.division((Double)factorMap.get(key), (Double)baseFactor);
                Double roi = baseRoi * diff;
                retMap.put(key, DataUtil.formatDouble((Double)roi, (int)6));
            }
        }
        return retMap;
    }

    public static Double getSucRate(Map<String, Long> mapInfo, Long defaultCnt) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long bidCnt = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.BID.getCode()), defaultValue);
            Long sucCnt = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.BID_SUC.getCode()), defaultValue);
            if (bidCnt >= defaultCnt) {
                ret = AdxStatData.getNormalValue(DataUtil.division((Long)sucCnt, (Long)bidCnt, (int)6), 0.0, 0.0, 1.0);
            }
        }
        return ret;
    }

    public static Map<String, Double> getLevelSucRate(Map<String, Long> bidCntMap, Map<String, Long> sucCntMap) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double ret = 0.0;
        Long defaultCnt = 10L;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{bidCntMap, sucCntMap})) {
                if (bidCntMap.get(key) >= defaultCnt) {
                    ret = AdxStatData.getNormalValue(DataUtil.division((Long)sucCntMap.get(key), (Long)bidCntMap.get(key), (int)6), 0.0, 0.0, 1.0);
                    retMap.put(key, ret);
                    continue;
                }
                retMap.put(key, 0.0);
                continue;
            }
            retMap.put(key, 0.0);
        }
        return retMap;
    }

    public static Map<String, Double> getFlowRateAdjust(Map<String, Double> flowRateMap, Integer ind, Double step) {
        Double defaultFlowRate;
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double firFlowRate = defaultFlowRate = Double.valueOf(0.33);
        Double secFlowRate = defaultFlowRate;
        Double thiFlowRate = defaultFlowRate;
        if (AssertUtil.isNotEmpty(flowRateMap)) {
            firFlowRate = AdxStatData.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_FIR.getCode()), defaultFlowRate, 0.1, 0.8);
            secFlowRate = AdxStatData.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_SEC.getCode()), defaultFlowRate, 0.1, 0.8);
            thiFlowRate = AdxStatData.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_THI.getCode()), defaultFlowRate, 0.1, 0.8);
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ind, step})) {
            if (ind == 1) {
                firFlowRate = firFlowRate + step;
            } else if (ind == 2) {
                secFlowRate = secFlowRate + step;
            } else if (ind == 3) {
                thiFlowRate = thiFlowRate + step;
            }
        }
        retMap.put(AdxStrategy.ADX_STRATEGY_FIR.getCode(), firFlowRate);
        retMap.put(AdxStrategy.ADX_STRATEGY_SEC.getCode(), secFlowRate);
        retMap.put(AdxStrategy.ADX_STRATEGY_THI.getCode(), thiFlowRate);
        return retMap;
    }

    public static Double nullToDefault(Double value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static Long nullToDefault(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static Double nullToMinDefault(Double value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Long nullToMinDefault(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Double getNormalValue(Double value, Double defaultValue, Double lower, Double upper) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value < lower ? lower : (value > upper ? upper : value);
        }
        return ret;
    }

    public static Long getNormalValue(Long value, Long defaultValue, Long lower, Long upper) {
        Long ret = defaultValue;
        if (value != null) {
            ret = value < lower ? lower : (value > upper ? upper : value);
        }
        return ret;
    }

    public static boolean isLarger(Long value1, Long value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }
        return ret;
    }

    public static boolean isLarger(Double value1, Double value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }
        return ret;
    }

    public static boolean isEqual(Long value1, Long value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1.equals(value2)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isEqual(Double value1, Double value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1.equals(value2)) {
            ret = true;
        }
        return ret;
    }

    public static Double getFlowRateScore(Map<String, Long> mapInfo) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long bidCntLimit = 20L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long bidCnt = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.BID.getCode()), defaultValue);
            Long adxConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            Long advertConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);
            if (bidCnt >= bidCntLimit) {
                ret = DataUtil.division((Double)((double)advertConsume.longValue() / 1.15 - (double)adxConsume.longValue()), (Long)bidCnt) * 1000.0;
            }
        }
        return DataUtil.formatDouble((Double)ret, (int)3);
    }

    public static Double getTryFlowRate(Double roiMsDiff, Long adxConsumeTryMs, AdxDirectlyFactorDo directlyFactorDoInfo) {
        Map<String, Double> flowRateMap;
        Double ret = 0.2;
        Double lastRate = 0.2;
        if (AssertUtil.isNotEmpty((Object)directlyFactorDoInfo) && AssertUtil.isNotEmpty(flowRateMap = directlyFactorDoInfo.getFactorFlowRateMap())) {
            lastRate = AdxStatData.getNormalValue(flowRateMap.get(AdxLevel.ADX_LEVEL_ONE.getCode()), lastRate, 0.02, 1.0);
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{roiMsDiff, adxConsumeTryMs})) {
            Long adxConsumeMs = AdxStatData.nullToDefault(adxConsumeTryMs, 0L);
            Double baseRate = AdxStatData.getNormalValue(DataUtil.division((Double)100.0, (Long)adxConsumeMs) * lastRate, lastRate, 0.02, 0.8);
            ret = roiMsDiff > 0.98 ? Double.valueOf(baseRate + Math.min(DataUtil.division((Double)roiMsDiff, (Double)0.98) - 1.0, 1.0) * (1.0 - baseRate)) : (adxConsumeMs < 100L ? baseRate : (adxConsumeMs > 1000L ? Double.valueOf(baseRate * 1.5) : Double.valueOf(baseRate * 1.2)));
        }
        return AdxStatData.getNormalValue(ret, 0.2, 0.02, 1.0);
    }

    public static Double getConfidentAdxConsume(Double roi) {
        Double ret = 100.0;
        if (AssertUtil.isNotEmpty((Object)roi)) {
            ret = 100.0 + DataUtil.division((Double)(roi - 1.0), (Double)0.1499999999999999) * 100.0;
        }
        return AdxStatData.getNormalValue(ret, 100.0, 100.0, 200.0);
    }

    public static Double getTryUppStepCon(Long adxConsume, Double roi, Double limit) {
        Double ret = 0.0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxConsume, roi, limit})) {
            Double confidentConsume = AdxStatData.getConfidentAdxConsume(roi);
            ret = (double)adxConsume.longValue() <= confidentConsume ? Double.valueOf((1.0 - DataUtil.division((Long)adxConsume, (Double)confidentConsume)) * limit) : Double.valueOf(Math.max(1.0 - DataUtil.division((Long)adxConsume, (Double)confidentConsume), -1.0) * limit);
        }
        return DataUtil.formatDouble((Double)AdxStatData.getNormalValue(ret, 0.0, -limit.doubleValue(), limit), (int)3);
    }

    public static String selectBestLevel(Map<String, Long> bidMap, Map<String, Long> adxMap, Map<String, Long> advertMap) {
        String ret = AdxLevel.ADX_LEVEL_TWO.getCode();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{bidMap, adxMap, advertMap})) {
            Double tmpRpm = -1000000.0;
            for (AdxLevel adxLevel : AdxLevel.values()) {
                Double profit;
                Double rpm;
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                Long bid = AdxStatData.nullToMinDefault(bidMap.get((Object)adxLevel), 0L);
                Long adx = AdxStatData.nullToMinDefault(adxMap.get((Object)adxLevel), 0L);
                Long advert = AdxStatData.nullToMinDefault(advertMap.get((Object)adxLevel), 0L);
                if (!AdxStatData.isLarger(bid, 10L) || !AdxStatData.isLarger(adx, 25L) || !AdxStatData.isLarger(advert, 25L) || !((rpm = MathUtil.division((Double)((profit = Double.valueOf((double)advert.longValue() / 1.15 - (double)adx.longValue())) * 1000.0), (Long)bid, (int)6)) > tmpRpm)) continue;
                ret = key;
                tmpRpm = rpm;
            }
        }
        return ret;
    }

    public static AdxIndexStatsDo indexStatCompute(Map<String, Long> indexStatInfo) {
        AdxIndexStatsDo ret = new AdxIndexStatsDo();
        boolean isConfident = false;
        Long bidCnt = 0L;
        Long sucCnt = 0L;
        Long expCnt = 0L;
        Long clickCnt = 0L;
        Long adxConsume = 0L;
        Long advertConsume = 0L;
        if (AssertUtil.isNotEmpty(indexStatInfo)) {
            bidCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.BID.getCode()), 0L);
            sucCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.BID_SUC.getCode()), 0L);
            expCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.EXP.getCode()), 0L);
            clickCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.CLICK.getCode()), 0L);
            adxConsume = DataUtil.double2Long((double)(AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.ADX_CONSUME.getCode()), 0L) / ADX_MULTIPLIER), (Long)1L);
            advertConsume = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), 0L);
            if (AdxStatData.isLarger(bidCnt, 50L) && AdxStatData.isLarger(sucCnt, 20L) && AdxStatData.isLarger(expCnt, 10L) && AdxStatData.isLarger(clickCnt, 2L) && AdxStatData.isLarger(adxConsume, 50L) && AdxStatData.isLarger(advertConsume, 50L)) {
                isConfident = true;
            }
            if (isConfident) {
                Double roi = MathUtil.division((Long)advertConsume, (Long)adxConsume, (int)6);
                Double sucRate = MathUtil.division((Long)sucCnt, (Long)bidCnt, (int)6);
                Double ctr = MathUtil.division((Long)clickCnt, (Long)expCnt, (int)6);
                Double profit = (double)advertConsume.longValue() / 1.15 - (double)adxConsume.longValue();
                Double rpm = MathUtil.division((Double)(profit * 1000.0), (Long)bidCnt, (int)6);
                ret.setRoi(roi);
                ret.setSucRate(sucRate);
                ret.setCtr(ctr);
                ret.setRpm(rpm);
            }
        }
        ret.setConfident(isConfident);
        ret.setBidCnt(bidCnt);
        ret.setSucCnt(sucCnt);
        ret.setExpCnt(expCnt);
        ret.setClickCnt(clickCnt);
        ret.setAdxConsume(adxConsume);
        ret.setAdvertConsume(advertConsume);
        return ret;
    }

    public static Integer getPreInterval(Double preValue) {
        Integer ret = null;
        Double[] preList = new Double[]{0.002, 0.003, 0.005, 0.007, 0.01};
        if (AssertUtil.isNotEmpty((Object)preValue) && preValue >= 0.0) {
            ret = preValue < preList[0] ? 1 : (preValue < preList[1] ? 2 : (preValue < preList[2] ? 3 : (preValue < preList[3] ? 4 : (preValue < preList[4] ? 5 : 6))));
        }
        return ret;
    }

    public static AdxIndexStatsDo adxIndexCompute(AdxIndexStatDo adxIndexStats) {
        AdxIndexStatsDo ret = new AdxIndexStatsDo();
        boolean isConfident = false;
        Long bidCnt = 0L;
        Long sucCnt = 0L;
        Long expCnt = 0L;
        Long clickCnt = 0L;
        Long adxConsume = 0L;
        Long advertConsume = 0L;
        Long advertLaunch = 0L;
        Long advertClick = 0L;
        Double preClickValueSum = 0.0;
        if (AssertUtil.isNotEmpty((Object)adxIndexStats)) {
            bidCnt = AdxStatData.nullToMinDefault(adxIndexStats.getBid(), 0L);
            sucCnt = AdxStatData.nullToMinDefault(adxIndexStats.getBidSuc(), 0L);
            expCnt = AdxStatData.nullToMinDefault(adxIndexStats.getExp(), 0L);
            clickCnt = AdxStatData.nullToMinDefault(adxIndexStats.getClick(), 0L);
            adxConsume = DataUtil.double2Long((double)(AdxStatData.nullToMinDefault(adxIndexStats.getAdxConsume(), 0L) / ADX_MULTIPLIER), (Long)1L);
            advertConsume = AdxStatData.nullToMinDefault(adxIndexStats.getAdvertConsume(), 0L);
            advertLaunch = AdxStatData.nullToMinDefault(adxIndexStats.getAdvertLaunch(), 0L);
            advertClick = AdxStatData.nullToMinDefault(adxIndexStats.getAdvertClick(), 0L);
            preClickValueSum = AdxStatData.nullToMinDefault(adxIndexStats.getPreClickValue(), 0.0);
            if (AdxStatData.isLarger(bidCnt, 50L) && AdxStatData.isLarger(sucCnt, 20L) && AdxStatData.isLarger(expCnt, 10L) && AdxStatData.isLarger(clickCnt, 2L) && AdxStatData.isLarger(adxConsume, 50L) && AdxStatData.isLarger(advertConsume, 50L)) {
                isConfident = true;
            }
            if (isConfident) {
                Double roi = MathUtil.division((Long)advertConsume, (Long)adxConsume, (int)6);
                Double sucRate = MathUtil.division((Long)sucCnt, (Long)bidCnt, (int)6);
                Double ctr = MathUtil.division((Long)clickCnt, (Long)expCnt, (int)6);
                Double profit = (double)advertConsume.longValue() / 1.15 - (double)adxConsume.longValue();
                Double rpm = MathUtil.division((Double)(profit * 1000.0), (Long)bidCnt, (int)6);
                Double clickValue = MathUtil.division((Long)advertConsume, (Long)clickCnt, (int)6);
                ret.setRoi(AdxStatData.nullToMinDefault(roi, 0.0));
                ret.setSucRate(AdxStatData.getNormalValue(sucRate, 0.0, 0.0, 1.0));
                ret.setCtr(AdxStatData.getNormalValue(ctr, 0.0, 0.0, 1.0));
                ret.setRpm(rpm);
                ret.setClickValue(AdxStatData.nullToMinDefault(clickValue, 0.0));
            }
        }
        ret.setConfident(isConfident);
        ret.setBidCnt(bidCnt);
        ret.setSucCnt(sucCnt);
        ret.setExpCnt(expCnt);
        ret.setClickCnt(clickCnt);
        ret.setAdxConsume(adxConsume);
        ret.setAdvertConsume(advertConsume);
        ret.setAdvertLaunch(advertLaunch);
        ret.setAdvertClick(advertClick);
        ret.setPreClickValueSum(preClickValueSum);
        return ret;
    }

    public static Map<Integer, AdxIndexStatsDo> intervalIndexCompute(Map<Integer, AdxIndexStatDo> intervalStats) {
        Integer preIntervalSize = 5;
        HashMap<Integer, AdxIndexStatsDo> retMap = new HashMap<Integer, AdxIndexStatsDo>(preIntervalSize);
        boolean isConfident = false;
        Long bidCnt = 0L;
        Long sucCnt = 0L;
        Long expCnt = 0L;
        Long clickCnt = 0L;
        Long adxConsume = 0L;
        Long advertConsume = 0L;
        for (int key = 1; key <= preIntervalSize; ++key) {
            AdxIndexStatDo intervalInfo;
            AdxIndexStatsDo ret = new AdxIndexStatsDo();
            if (AssertUtil.isNotEmpty(intervalStats) && AssertUtil.isNotEmpty((Object)(intervalInfo = intervalStats.get(key)))) {
                ret = AdxStatData.adxIndexCompute(intervalInfo);
            }
            ret.setConfident(isConfident);
            ret.setBidCnt(bidCnt);
            ret.setSucCnt(sucCnt);
            ret.setExpCnt(expCnt);
            ret.setClickCnt(clickCnt);
            ret.setAdxConsume(adxConsume);
            ret.setAdvertConsume(advertConsume);
            retMap.put(key, ret);
        }
        return retMap;
    }

    public static Double getConRoi(AdxIndexStatsDo hourDo, AdxIndexStatsDo dayDo) {
        Double ret = null;
        Double conWeight = 0.5;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{hourDo, dayDo})) {
            Long hourAdx = AdxStatData.nullToMinDefault(hourDo.getAdxConsume(), 0L);
            Long hourAdvert = AdxStatData.nullToMinDefault(hourDo.getAdvertConsume(), 0L);
            Long dayAdx = AdxStatData.nullToMinDefault(dayDo.getAdxConsume(), 0L);
            Long dayAdvert = AdxStatData.nullToMinDefault(dayDo.getAdvertConsume(), 0L);
            Double conAdx = conWeight * (double)hourAdx.longValue() + (1.0 - conWeight) * (double)dayAdx.longValue();
            Double conAdvert = conWeight * (double)hourAdvert.longValue() + (1.0 - conWeight) * (double)dayAdvert.longValue();
            if (AdxStatData.isLarger(conAdx, 25.0) && AdxStatData.isLarger(conAdvert, 25.0)) {
                ret = MathUtil.division((Double)conAdvert, (Double)conAdx, (int)6);
            }
        }
        return ret;
    }

    public static Long multiply(Long v1, Double v2) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{v1, v2})) {
            ret = DataUtil.double2Long((Double)((double)v1.longValue() * v2));
        }
        return ret;
    }

    public static Double getConCtr(Double preValue, Double statValue, Double preWeight) {
        Double fUpperLimit = 2.0;
        Double fLowerLimit = 0.0;
        Double vUpperLimit = 0.9999;
        Double vLowerLimit = 0.0;
        Double defaultValue = 0.001;
        Double ret = (preValue = AdxStatData.getNormalValue(preValue, statValue = AdxStatData.getNormalValue(statValue, defaultValue, vLowerLimit, vUpperLimit), statValue * fLowerLimit, statValue * fUpperLimit)) * preWeight + statValue * (1.0 - preWeight);
        ret = ret < vLowerLimit ? vLowerLimit : (ret > vUpperLimit ? vUpperLimit : ret);
        return ret;
    }

    public static Double getConClickValue(Double preValue, Double statValue, Double preWeight) {
        Double fUpperLimit = 2.0;
        Double fLowerLimit = 0.0;
        Double defaultValue = 1.0;
        statValue = AdxStatData.nullToDefault(statValue, defaultValue);
        preValue = AdxStatData.getNormalValue(preValue, statValue, statValue * fLowerLimit, statValue * fUpperLimit);
        Double ret = preValue * preWeight + statValue * (1.0 - preWeight);
        return ret;
    }

    public static Integer bucket(Double value, int[] bucketList) {
        Integer ret = 0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{value, bucketList}) && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (!(value < (double)bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Integer bucket(Double value, double[] bucketList) {
        Integer ret = 0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{value, bucketList}) && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value < bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Integer flowSplit(List<Double> flowRateList) {
        Integer ret = 0;
        Double sumRate = 0.0;
        if (AssertUtil.isNotEmpty(flowRateList)) {
            int size = flowRateList.size();
            Double[] sumRateList = new Double[size];
            for (int ind = 0; ind < size; ++ind) {
                sumRateList[ind] = sumRate = Double.valueOf(sumRate + AdxStatData.nullToDefault(flowRateList.get(ind), 0.0));
            }
            double random = Math.random();
            for (int ind = 0; ind < size; ++ind) {
                double bound = DataUtil.division((Double)sumRateList[ind], (Double)sumRateList[size - 1]);
                if (!(random <= bound)) continue;
                ret = ind;
                break;
            }
        }
        return ret;
    }

    public static Integer getFlowSplit(List<Long> flowRateList) {
        Integer ret = 0;
        Long sumRate = 0L;
        if (AssertUtil.isNotEmpty(flowRateList)) {
            int size = flowRateList.size();
            Long[] sumRateList = new Long[size];
            for (int ind = 0; ind < size; ++ind) {
                sumRateList[ind] = sumRate = Long.valueOf(sumRate + AdxStatData.nullToDefault(flowRateList.get(ind), 0L));
            }
            double random = Math.random();
            for (int ind = 0; ind < size; ++ind) {
                double bound = DataUtil.division((Long)sumRateList[ind], (Long)sumRateList[size - 1]);
                if (!(random <= bound)) continue;
                ret = ind;
                break;
            }
        }
        return ret;
    }

    public static Double getRectifyFactor(Long clickCnt, Long adConsume, Double preClickValueSum) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{clickCnt, adConsume, preClickValueSum}) && AdxStatData.isLarger(clickCnt, 10L) && AdxStatData.isLarger(adConsume, 100L) && AdxStatData.isLarger(preClickValueSum, 0.0)) {
            ret = DataUtil.division((Double)preClickValueSum, (Long)adConsume, (int)6);
            ret = AdxStatData.getNormalValue(ret, 1.0, 0.5, 1.5);
        }
        return ret;
    }

    public static Double getConRectifyFactor(AdxIndexStatsDo hourDo, AdxIndexStatsDo dayDo) {
        Double ret = null;
        Double conWeight = 0.5;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{hourDo, dayDo})) {
            Long hourClick = hourDo.getClickCnt();
            Long hourAdvert = hourDo.getAdvertConsume();
            Double hourPreClickValueSum = hourDo.getPreClickValueSum();
            Double hourFactor = AdxStatData.getRectifyFactor(hourClick, hourAdvert, hourPreClickValueSum);
            Long dayClick = dayDo.getClickCnt();
            Long dayAdvert = dayDo.getAdvertConsume();
            Double dayPreClickValueSum = dayDo.getPreClickValueSum();
            Double dayFactor = AdxStatData.getRectifyFactor(dayClick, dayAdvert, dayPreClickValueSum);
            Long conClick = DataUtil.double2Long((Double)(conWeight * (double)hourClick.longValue() + (1.0 - conWeight) * (double)dayClick.longValue()));
            Long conAdvert = DataUtil.double2Long((Double)(conWeight * (double)hourAdvert.longValue() + (1.0 - conWeight) * (double)dayAdvert.longValue()));
            Double conPreClickValueSum = conWeight * hourPreClickValueSum + (1.0 - conWeight) * dayPreClickValueSum;
            Double conFactor = AdxStatData.getRectifyFactor(conClick, conAdvert, conPreClickValueSum);
            ret = hourFactor;
            if (AssertUtil.isEmpty((Object)hourFactor)) {
                ret = conFactor;
                if (AssertUtil.isEmpty((Object)conFactor)) {
                    ret = dayFactor;
                }
            }
        }
        return ret;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortMapByValueDescend(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                int compare = ((Comparable)o1.getValue()).compareTo(o2.getValue());
                return -compare;
            }
        });
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortMapByValueAscend(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                int compare = ((Comparable)o1.getValue()).compareTo(o2.getValue());
                return compare;
            }
        });
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }
}

