package cn.com.duiba.nezha.alg.alg.vo.adx.pd;


import java.io.Serializable;
import java.security.acl.LastOwnerException;
import java.util.Map;

/**
 * 创意点击价值纠偏对象
 */
public class ClickValueRectifyDo implements Serializable {

    private static final long serialVersionUID = 2986197209612357577L;

    /**
     * 纠偏因子表({clickValueLevel：小数})
     */
    private Map<Integer, Double> rectifyFactorMap;

    /**
     * 资源位实时点击量级
     */
    private Map<Integer, Long> resoClickCntHour;

    /**
     * 资源位当天点击量级
     */
    private Map<Integer, Long> resoClickCntDay;

    /**
     * 资源位实时广告消耗
     */
    private Map<Integer, Long> resoAdConsumeHour;

    /**
     * 资源位当天广告消耗
     */
    private Map<Integer, Long> resoAdConsumeDay;

    /**
     * 资源位实时预估点击价值总和
     */
    private Map<Integer, Double> resoPreClickValueHour;

    /**
     * 资源位当天预估点击价值总和
     */
    private Map<Integer, Double> resoPreClickValueDay;

    /**
     * 数据指标是否置信
     */
    private boolean isConfident;



    public Map<Integer, Double> getRectifyFactorMap() {
        return rectifyFactorMap;
    }

    public void setRectifyFactorMap(Map<Integer, Double> rectifyFactorMap) {
        this.rectifyFactorMap = rectifyFactorMap;
    }

    public Map<Integer, Long> getResoClickCntHour() { return resoClickCntHour; }

    public void setResoClickCntHour(Map<Integer, Long> resoClickCntHour) { this.resoClickCntHour = resoClickCntHour; }

    public Map<Integer, Long> getResoClickCntDay() { return resoClickCntDay; }

    public void setResoClickCntDay(Map<Integer, Long> resoClickCntDay) { this.resoClickCntDay = resoClickCntDay; }

    public Map<Integer, Long> getResoAdConsumeHour() { return resoAdConsumeHour; }

    public void setResoAdConsumeHour(Map<Integer, Long> resoAdConsumeHour) { this.resoAdConsumeHour = resoAdConsumeHour; }

    public Map<Integer, Long> getResoAdConsumeDay() { return resoAdConsumeDay; }

    public void setResoAdConsumeDay(Map<Integer, Long> resoAdConsumeDay) { this.resoAdConsumeDay = resoAdConsumeDay; }

    public Map<Integer, Double> getResoPreClickValueHour() { return resoPreClickValueHour; }

    public void setResoPreClickValueHour(Map<Integer, Double> resoPreClickValueHour) { this.resoPreClickValueHour = resoPreClickValueHour; }

    public Map<Integer, Double> getResoPreClickValueDay() { return resoPreClickValueDay; }

    public void setResoPreClickValueDay(Map<Integer, Double> resoPreClickValueDay) { this.resoPreClickValueDay = resoPreClickValueDay; }

    public boolean isConfident() { return isConfident; }

    public void setConfident(boolean confident) { isConfident = confident; }
}
