package cn.com.duiba.nezha.alg.alg.vo.adx.pd;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;


/**
 * 创意推荐出参对象
 */

@Data
public class AdxIdeaRcmdResultDo implements Serializable {

    private static final long serialVersionUID = -1648953353569010809L;

    /**
     * 推荐创意
     */
    private Long ideaId;

    /**
     * 创意点击率-预估
     */
    private Double preCtr;

    /**
     * 创意点击率-统计(近20min)
     */
    private Double statCtr;

    /**
     * 创意点击价值-预估
     */
    private Double preClickValue;

    /**
     * 创意点击价值-统计(近20min，分/单次点击)
     */
    private Double statClickValue;

    /**
     * 资源位统计CTR(近20min)
     */
    private Double statCtrResource;

    /**
     * 资源位统计点击价值(近20min，分/单次点击)
     */
    private Double statClickValueResource;

    /**
     * 创意特征字段
     */
    private Map<String,String> ideaFeatureMap;

    /**
     * 候选创意得分集合
     */
    private Map<String,String> ideaScoreMap;

    /**
     * 放弃原因类型
     */
    private Long giveUpType;

}
