package cn.com.duiba.nezha.alg.alg.adx.pddecision;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.predict.AdxClickValuePredict;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickAndJoinDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPredAdDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public class PdDecisionAlg {

    private static final Logger logger = LoggerFactory.getLogger(PdDecisionAlg.class);

    private static long ADX_MULTIPLIER = 10000000;
    private static int[] CLICK_VALUE_BUCKET = {1, 2, 3, 5, 7, 10, 20, 50, 100};

    /**
     *  PD决策
     *
     * @param decisionRequestDo
     * @return
     */
    public static AdxPdDecisionResultDo getPdDecision(AdxPdDecisionRequestDo decisionRequestDo) {

        AdxPdDecisionResultDo ret = new AdxPdDecisionResultDo();

        /**
         *
         * 步骤：
         * 步骤1、点击价值预估-预发券
         * 步骤2、点击价值分层纠偏融合
         * 步骤3、创意点击率融合
         * 步骤4、曝光价值预估
         * 步骤5、互动-PD决策
         *
         */

        try {

            //模型预估权重
            Double preCtrWeight = 0.8;
            Double preCvaWeight = 0.5;

            //预发券权重
            Double preAdWeight = 0.1;

            //判断异常原因
            Long giveUpType = getGiveUpType(decisionRequestDo);

            Integer isGiveUp = 0;                                       //是否放弃(0:不放弃,1:放弃)
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();   //策略
            String level = AdxLevel.ADX_LEVEL_ONE.getCode();            //level

            Double rectifyFactor = 1.0;                                 //点击价值纠偏因子
            Double controlFactor = 1.0;                                 //决策控制因子
            Double lowerLimit = 0.5;                                    //决策控制因子下限
            Double upperLimit = 1.5;                                    //决策控制因子上限
            Double giveUpRate = 0.9;                                    //低质流量放弃比例
            Integer warnLabel = 0;                                      //数据是否异常告警


            if (AssertUtil.isNotEmpty(decisionRequestDo)) {

                //创意推荐结果
                Long ideaId = null;
                Double preCtr = null, statCtr = null, statCtrDay = null, resoStatCtr = null;
                Double preClickValue = null, statClickValue = null, statClickValueDay = null, resoStatClickValue = null;
                AdxIdeaRcmdResultDo ideaRcmdResult = decisionRequestDo.getIdeaRcmdResult();
                if (AssertUtil.isNotEmpty(ideaRcmdResult)) {
                    ideaId = ideaRcmdResult.getIdeaId();
                    preCtr = ideaRcmdResult.getPreCtr();
                    statCtr = ideaRcmdResult.getStatCtr();
                    resoStatCtr = ideaRcmdResult.getStatCtrResource();
                    preClickValue = ideaRcmdResult.getPreClickValue();
                    statClickValue = ideaRcmdResult.getStatClickValue();
                    resoStatClickValue = ideaRcmdResult.getStatClickValueResource();
                    giveUpType = ideaRcmdResult.getGiveUpType();
                }

                //统计指标计算
                boolean isConfident = false;
                Long ideaAdxCostDay = 0L, ideaAdConsumeDay = 0L;
                AdxStatsDo ideaStats = decisionRequestDo.getIdeaStats();
                if (AssertUtil.isNotEmpty(ideaStats)) {
                    AdxIndexStatDo last1DayStat = ideaStats.getLast1DayStat();
                    AdxIndexStatDo last20MinStat = ideaStats.getLast20MinStat();
                    AdxIndexStatsDo ideaStatsDay = AdxStatData.adxIndexCompute(last1DayStat);
                    AdxIndexStatsDo ideaStatsMin = AdxStatData.adxIndexCompute(last20MinStat);
                    ideaAdxCostDay = ideaStatsDay.getAdxConsume();
                    ideaAdConsumeDay = ideaStatsDay.getAdvertConsume();
                    statCtr = AdxStatData.nullToDefault(statCtr, ideaStatsMin.getCtr());
                    statClickValue = AdxStatData.nullToDefault(statClickValue, ideaStatsMin.getClickValue());
                    statCtrDay = ideaStatsDay.getCtr();
                    statClickValueDay= ideaStatsDay.getClickValue();

                    //置信判断：创意整体当天/实时维度数据置信
                    if (ideaStatsDay.getConfident() && ideaStatsMin.getConfident()) {
                        isConfident = true;
                    }
                }

                //数据异常监控告警（adx成本<=0 && 广告消耗>500分）
                if (ideaAdxCostDay <= 0L && ideaAdConsumeDay > 500L) {
                    warnLabel = 1;
                    logger.warn(String.format("AdxPdAlgo AdxConsume Exception Logging, " +
                                    "DealId: %s; IdeaId: %s]; " +
                                    "IdeaAdxConsumeDay: %s; IdeaAdvertConsumeDay: %s;",
                            JSONObject.toJSONString(decisionRequestDo.getDealId()),
                            JSONObject.toJSONString(ideaId),
                            JSONObject.toJSONString(ideaAdxCostDay),
                            JSONObject.toJSONString(ideaAdConsumeDay)));
                }



                /* 步骤1、点击价值预估-预发券 */
                AdxClickAndJoinDo mergeAdxClickAndJoinDo = decisionRequestDo.getMergeAdxClickAndJoinDo();
                List<AdxPredAdDo> adxPredAdDoList = decisionRequestDo.getAdxPredAdDoList();
                Double preAdClickValue = AdxClickValuePredict.getPredClickValue(mergeAdxClickAndJoinDo, adxPredAdDoList);



                /* 步骤2、点击价值分层纠偏融合 */
                // 2.1 分层
                Integer clickValueLevel = AdxStatData.bucket(preClickValue, CLICK_VALUE_BUCKET);

                // 2.2 纠偏(纠偏因子=预估值/实际值)
                ClickValueRectifyDo clickValueRectify = decisionRequestDo.getClickValueRectify();
                rectifyFactor = AdxStatData.getClickValueRectifyFactor(clickValueLevel, clickValueRectify);
                Double statConClickValue = AdxStatData.nullToDefault(resoStatClickValue, statClickValueDay);
                statConClickValue = AdxStatData.nullToDefault(statClickValue, statConClickValue);
                Double recPreClickValue = statConClickValue;
                if (AssertUtil.isNotEmpty(preClickValue)) {
                    recPreClickValue = DataUtil.division(preClickValue, rectifyFactor);
                }

                // 2.3 融合
                Double conPreAdClickValue = AdxStatData.getConClickValue(preAdClickValue, statConClickValue, preAdWeight);
                Double conClickValue = AdxStatData.getConClickValue(recPreClickValue, statConClickValue, preCvaWeight);



                /* 步骤3、创意点击率融合 */
                Double statConCtr = AdxStatData.nullToDefault(resoStatCtr, statCtrDay);
                statConCtr = AdxStatData.nullToDefault(statCtr, statConCtr);
                Double conCtr = AdxStatData.getConCtr(preCtr, statConCtr, preCtrWeight);



                /* 步骤4、曝光价值预估 */
                Double expConsume = conClickValue * conCtr;



                /* 步骤5、互动-PD决策 */
                // 5.1 获取低质流量放弃比例和控制因子
                Double targetRoi = AdxStatData.nullToMinDefault(decisionRequestDo.getTargetRoi(),1.1501);
                AdxPdControlDo adxPdControlInfo = decisionRequestDo.getAdxPdControlInfo();
                if (AssertUtil.isNotEmpty(adxPdControlInfo)) {
                    giveUpRate = AdxStatData.nullToDefault(adxPdControlInfo.getGiveUpRate(), giveUpRate);
                    controlFactor = AdxStatData.getNormalValue(adxPdControlInfo.getControlFactor(), controlFactor, lowerLimit, upperLimit);
                }

                // 5.2 计算预估曝光价值，预估roi
                Long price = decisionRequestDo.getPrice(); //deal出价(分/cpm*10000)
                Double expCost = DataUtil.division(AdxStatData.nullToDefault(price, 0L), ADX_MULTIPLIER);//曝光成本(分/单次曝光)
                Double pRoi1 = DataUtil.division(expConsume, expCost,6);
                Double pRoi2 = DataUtil.division(expConsume, (expCost * controlFactor),6);

                // 5.3 判断流量是否放弃(前提：数据置信)
                if (isConfident) {
                    double random = Math.random();

                    //预估ROI<1.0: 完全放弃0.98；预估ROI<1.15: 放弃比例*1.0；
                    if (pRoi1 < 1.0 || pRoi2 < 1.0) {

                        if (random < 0.98) {
                            isGiveUp = 1;
                            giveUpType = 10L;
                        }

                    } else if (pRoi1 < 1.15 || pRoi2 < 1.15) {

                        if (random < giveUpRate) {
                            isGiveUp = 1;
                            giveUpType = 10L;
                        }
                    }

                }



                ret.setIdeaId(ideaId);
                ret.setPreCtr(preCtr);
                ret.setStatCtr(statCtr);
                ret.setStatCtrResource(resoStatCtr);
                ret.setPreClickValue(preClickValue);
                ret.setPredClickValue(preAdClickValue);
                ret.setStatClickValue(statClickValue);
                ret.setStatClickValueResource(resoStatClickValue);
                ret.setClickValueLevel(clickValueLevel);
            }

            ret.setIsGiveUp(isGiveUp);
            ret.setStrategy(strategy);
            ret.setLevel(level);
            ret.setClickValueRectifyFactor(rectifyFactor);
            ret.setGiveUpType(giveUpType);


        } catch (Exception e) {

            logger.error("PdDecisionAlg.getPdDecision error", e);
        }
        return ret;
    }




    /**
     * 校验基础信息是否合法
     *
     * @param decisionRequestDo
     * @return
     */
    private static Long getGiveUpType(AdxPdDecisionRequestDo decisionRequestDo) {

        Long ret = null;

        if (decisionRequestDo == null) {
            logger.error("PdDecisionAlg.getPdDecision() input params valid , params decisionRequestDo is null");
            return 11L;
        }

        if (decisionRequestDo.getIdeaRcmdResult() == null) {
            logger.error("PdDecisionAlg.getPdDecision() input params valid , params ideaRcmdResult is null");
            return 12L;
        }

        return ret;
    }

}
