package cn.com.duiba.nezha.alg.alg.vo.adx.pd;

import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxResourceRcmdDo;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


/**
 * 创意推荐入参对象
 */

@Data
public class AdxIdeaRcmdRequestDo implements Serializable {

    private static final long serialVersionUID = -8343027904367459748L;

    /**
     * 点击率预估模型
     */
    private FM fmModel;

    /**
     * 编码器模型
     */
    private CODER coderModel;

    /**
     * TF模型
     */
    private LocalTFModel ltfModel;

    /**
     * 更新的时候的模型，临时模型，用于预热
     */
    private LocalTFModel ltfModelTemp;

    /**
     * 可投放创意特征对象List
     *
     * 限定有效创意，拼接创意特征
     */
    private List<AdxIdeaFeatureDo> ideaFeatureList;

    /**
     * 非创意特征对象(静态特征对象)
     */
    private AdxFeatureDo adxFeatureDo;

    /**
     * 可投放创意统计数据(key:创意id)
     */
    private Map<Long, AdxStatsDo> ideaStatsList;

    /**
     * 所属资源位统计数据
     */
    private AdxStatsDo resoStats;

    /**
     * 人工投放选择的创意id
     */
    private Long manualIdeaId;

    /**
     * 投放方式(0=依次, 1=比例, 2=算法1.0, 3=算法2.0)
     */
    private Integer putType;

    /**
     * 投放方式
     */
    private AdxResourceRcmdDo adxResourceRcmdDo;

    /**
     * 模型融合收益
     */
    private Double mergeRpm;

    /**
     * 模型预估收益
     */
    private Double pRpm;

    /**
     * 统计收益
     */
    private Double sRpm;

}
