package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.params.AdxIdeaRcmdParam;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.*;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IdeaRcmdAlg {

    private static final Logger logger = LoggerFactory.getLogger(IdeaRcmdAlg.class);

    static double[] weight = {100, 20, 10, 5, 2, 1, 0.5};


    /**
     * 创意推荐
     *
     * @param rcmdRequestDo
     * @return
     */
    public static AdxIdeaRcmdResultDo getIdeaRcmd(AdxIdeaRcmdRequestDo rcmdRequestDo) {

        AdxIdeaRcmdResultDo ret = new AdxIdeaRcmdResultDo();

        /**
         *
         * 步骤：
         * 步骤1、统计创意CTR，点击价值
         * 步骤2、预估创意CTR，点击价值
         * 步骤3、创意挑选
         *
         * 备注：putType = 0依次, 1比例, 2算法1.0, 3算法2.0，4算法3.0
         *
         */

        try {


            //判断异常原因
            Long giveUpType = getGiveUpType(rcmdRequestDo);
            rcmdRequestDo = Optional.ofNullable(rcmdRequestDo).orElse(new AdxIdeaRcmdRequestDo());
            Integer putType = Optional.ofNullable(rcmdRequestDo.getPutType()).orElse(3);


            /* 步骤1、统计创意CTR，点击价值 */
            //1.1 创意维度
            Map<Long, AdxStatsDo> ideaStatsList = Optional.ofNullable(rcmdRequestDo.getIdeaStatsList()).orElse(new HashMap<>());
            Map<Long, Double> ideaStatCtrMap = new HashMap<>(), ideaStatDayCtrMap = new HashMap<>();
            Map<Long, Double> ideaStatCvaMap = new HashMap<>(), ideaStatDayCvaMap = new HashMap<>();
            ideaStatsList.forEach((k, v) -> {
                AdxStatsDo ideaStats = Optional.ofNullable(v).orElse(new AdxStatsDo());
                AdxIndexStatsDo idea20MinInfo = AdxStatData.getAdxTimeIndex(ideaStats, "20min");
                AdxIndexStatsDo idea1DayInfo = AdxStatData.getAdxTimeIndex(ideaStats, "1day");
                ideaStatCtrMap.put(k, idea20MinInfo.getCtr());
                ideaStatDayCtrMap.put(k, idea1DayInfo.getCtr());
                ideaStatCvaMap.put(k, idea20MinInfo.getClickValue());
                ideaStatDayCvaMap.put(k, idea1DayInfo.getClickValue());
            });

            //1.2 资源位维度
            AdxStatsDo resoStats = Optional.ofNullable(rcmdRequestDo.getResoStats()).orElse(new AdxStatsDo());
            AdxIndexStatsDo reso20MinInfo = AdxStatData.getAdxTimeIndex(resoStats, "20min");
            Double resoStatCtr = reso20MinInfo.getCtr();
            Double resoStatCva = reso20MinInfo.getClickValue();



            /* 步骤2、预估创意CTR，点击价值 */
            List<AdxIdeaFeatureDo> ideaList = new ArrayList<>();
            List<AdxIdeaMaterialDo> ideaMaList = new ArrayList<>();
            Map<AdxIdeaMaterialDo, FeatureMapDo> featureMap = new HashMap<>();
            Map<AdxIdeaMaterialDo, Double> preCtrMap = new HashMap<>();
            Map<AdxIdeaMaterialDo, Double> preCvaMap = new HashMap<>();
            if (AssertUtil.isEmpty(giveUpType)) {

                //2.1 特征解析
                ideaList = putType.equals(4) ?
                        getIdeaList(rcmdRequestDo.getStaticIdeaFeatureList(), rcmdRequestDo.getDynamicIdeaFeatureList())
                        : getIdeaList(rcmdRequestDo.getStaticIdeaFeatureList(), null);
                featureMap = getFeatureMap(rcmdRequestDo.getAdxFeatureDo(), ideaList);
                ideaMaList = new ArrayList<>(featureMap.keySet());

                //2.2 预估创意ctr
                FM fmModel = rcmdRequestDo.getFmModel();
                preCtrMap = fmModel.predictsNew(featureMap);

                //2.3 预估创意点击价值(创意推荐1.0)
                if (putType.equals(2)) {
                    CODER2 coderModel = rcmdRequestDo.getCoderModel();
                    LocalTFModel ltfModel = rcmdRequestDo.getLtfModel();
                    if (AssertUtil.isAllNotEmpty(coderModel, ltfModel)) {
                        preCvaMap = coderModel.predictWithLocalTFNew(featureMap, ltfModel);
                    }
                }
            }



            /* 步骤3、创意挑选 */
            Long bestIdeaId = null, bestMaterialId = null;
            if (putType.equals(0) || putType.equals(1)) {
                //按依次/比例投放
                bestIdeaId = rcmdRequestDo.getManualIdeaId();


            } else if (putType.equals(2)) {
                //按创意推荐1.0投放
                Map<Long, Double> preExpValueMap = getPreExpValue(ideaMaList, resoStatCtr, resoStatCva, preCtrMap, preCvaMap,
                        ideaStatCtrMap, ideaStatDayCtrMap, ideaStatCvaMap, ideaStatDayCvaMap);
                bestIdeaId = getBestIdeaId(ideaMaList, preExpValueMap);
                ret.setIdeaScoreMap(JSONObject.toJSONString(preExpValueMap));


            } else if (putType.equals(3)) {
                //按创意推荐2.0投放
                AdxIdeaRcmdParam adxIdeaRcmdParam = new AdxIdeaRcmdParam();
                adxIdeaRcmdParam.setIdeaFeatureList(rcmdRequestDo.getStaticIdeaFeatureList());
                adxIdeaRcmdParam.setAdxFeatureDo(rcmdRequestDo.getAdxFeatureDo());
                adxIdeaRcmdParam.setAdxResourceRcmdDo(rcmdRequestDo.getAdxResourceRcmdDo());
                AdxIdeaFeatureDo result = AdxIdeaRcmdAlg.ideaRcmd(adxIdeaRcmdParam);
                if (AssertUtil.isNotEmpty(result)) {
                    bestIdeaId = result.getIdeaId();
                    Double mergeRpm = result.getMergeRpm(), pRpm = result.getPRpm(), sRpm = result.getSRpm();
                    ret.setMergeRpm(mergeRpm); ret.setPRpm(pRpm); ret.setSRpm(sRpm);
                    //创意推荐2.0不推荐
                    if (AssertUtil.isAllEmpty(giveUpType, bestIdeaId)) {
                        giveUpType = 7L;
                    }
                }


            } else if (putType.equals(4)) {
                //按创意推荐3.0投放
                Map<AdxIdeaMaterialDo, AdxStatsDo> ideaMaStatsList = Optional.ofNullable(rcmdRequestDo.getIdeaMaterialStatInfo()).orElse(new HashMap<>());
                Map<Long, AdxStatsDo> resoMaStatInfo = Optional.ofNullable(rcmdRequestDo.getResoMaterialStatInfo()).orElse(new HashMap<>());
                Map<Long, AdxStatsDo> userResoMaStatInfo = Optional.ofNullable(rcmdRequestDo.getUserResoMaterialStatInfo()).orElse(new HashMap<>());

                AdxMaterialRecallDo maRecallInfo = rcmdRequestDo.getMaterialRecallList();
                List<AdxIdeaMaterialDo> candidateList = getCandidateList(ideaMaList, maRecallInfo);

                AdxIdeaMaterialDo rankResult = getRank(candidateList, preCtrMap, ideaMaStatsList, resoMaStatInfo, userResoMaStatInfo);
                List<AdxIdeaMaterialDo> rawList = getRawList(ideaList, resoMaStatInfo);
                AdxIdeaMaterialDo bestResult = getBestIdeaMaterial(ideaList, rankResult, rawList);

                bestIdeaId = bestResult.getIdeaId();
                bestMaterialId = bestResult.getMaterialId();
            }


            //组装推荐结果相关信息
            Map<String, String> combineFeatureMap = new HashMap<String, String>();
            AdxIdeaMaterialDo bestIdeaMaterial = new AdxIdeaMaterialDo(bestIdeaId, bestMaterialId);
            FeatureMapDo bestFeature = featureMap.get(bestIdeaMaterial);
            if (AssertUtil.isNotEmpty(bestFeature) && AssertUtil.isAllNotEmpty(bestFeature.getStaticFeatureMap(), bestFeature.getDynamicFeatureMap())) {
                combineFeatureMap.putAll(bestFeature.getStaticFeatureMap());
                combineFeatureMap.putAll(bestFeature.getDynamicFeatureMap());
            }

            ret.setIdeaId(bestIdeaId);
            ret.setMaterialId(bestMaterialId);
            ret.setGiveUpType(giveUpType);
            ret.setIdeaFeatureMap(combineFeatureMap);

            ret.setPreCtr(preCtrMap.get(bestIdeaMaterial));
            ret.setPreClickValue(preCvaMap.get(bestIdeaMaterial));
            ret.setStatCtr(ideaStatCtrMap.get(bestIdeaId));
            ret.setStatClickValue(ideaStatCvaMap.get(bestIdeaId));
            ret.setStatCtrResource(resoStatCtr);
            ret.setStatClickValueResource(resoStatCva);


        } catch (Exception e) {

            logger.error("IdeaRcmdAlg.getIdeaRcmd error", e);
        }
        return ret;
    }


    /**
     * 校验基础信息是否合法
     *
     * @param rcmdRequestDo
     * @return
     */
    private static Long getGiveUpType(AdxIdeaRcmdRequestDo rcmdRequestDo) {

        Long ret = null;

        if (rcmdRequestDo == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params adxIdeaRcmdRequestDo is null");
            return 1L;
        }

        if (rcmdRequestDo.getPutType() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is null");
            return 1L;
        }

        if (rcmdRequestDo.getFmModel() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params fmModel is null");
            return 2L;
        }

        if (rcmdRequestDo.getPutType() == 2 && rcmdRequestDo.getCoderModel() == null) {
            logger.warn("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is 2, params coderModel is null");
            return null;
        }

        if (rcmdRequestDo.getPutType() == 2 && rcmdRequestDo.getLtfModel() == null) {
            logger.warn("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is 2, params ltfModel is null");
            return null;
        }

        if (rcmdRequestDo.getPutType() != 4 && (rcmdRequestDo.getStaticIdeaFeatureList() == null || rcmdRequestDo.getStaticIdeaFeatureList().size() == 0)) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is %s, params staticIdeaFeatureList is empty", rcmdRequestDo.getPutType());
            return 5L;
        }

        if (rcmdRequestDo.getPutType() == 4 && (
                (rcmdRequestDo.getStaticIdeaFeatureList() == null && rcmdRequestDo.getDynamicIdeaFeatureList() == null)
                        ||  (rcmdRequestDo.getStaticIdeaFeatureList().size() == 0 && rcmdRequestDo.getDynamicIdeaFeatureList().size() == 0)
        )) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is %s, params staticIdeaFeatureList and dynamicIdeaFeatureList are empty", rcmdRequestDo.getPutType());
            return 5L;
        }

        if (rcmdRequestDo.getAdxFeatureDo() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params adxFeatureDo is null");
            return 6L;
        }

        return ret;
    }


    /**
     * 预估曝光价值-创意推荐1.0
     *
     * @param
     * @return
     */
    public static Map<Long, Double> getPreExpValue(List<AdxIdeaMaterialDo> ideaMaList, Double resoStatCtr, Double resoStatCva,
                                                   Map<AdxIdeaMaterialDo, Double> preCtrMap, Map<AdxIdeaMaterialDo, Double> preCvaMap,
                                                   Map<Long, Double> ideaStatCtrMap, Map<Long, Double> ideaStatDayCtrMap,
                                                   Map<Long, Double> ideaStatCvaMap, Map<Long, Double> ideaStatDayCvaMap) {

        double preCtrWeight = 0.8, preCvaWeight = 0.2; //模型预估权重

        Map<Long, Double> preExpValueMap = new HashMap<>();
        if (AssertUtil.isEmpty(ideaMaList) || ideaMaList.size() == 0) {
            return preExpValueMap;
        }

        for (AdxIdeaMaterialDo key : ideaMaList) {
            Long ideaId = key.getIdeaId();

            Double pCtr = preCtrMap.get(key);
            Double sCtr = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ideaStatCtrMap.get(ideaId), ideaStatDayCtrMap.get(ideaId)), resoStatCtr);
            Double conCtr = AdxStatData.getConCtr(pCtr, sCtr, preCtrWeight, 0.0, 4.0, 0.01);

            Double pCva = preCvaMap.get(key);
            Double sCva = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ideaStatCvaMap.get(ideaId), ideaStatDayCvaMap.get(ideaId)), resoStatCva);
            Double conCva = AdxStatData.getConValue(pCva, sCva, preCvaWeight, 0.0, 2.0, 1.0);

            //预估创意曝光价值
            Double preExpValue = AdxStatData.nullToMinDefault(conCtr * conCva, 0.0);
            preExpValueMap.put(ideaId, DataUtil.formatDouble(preExpValue, 6));
        }

        return preExpValueMap;
    }


    /**
     * 选择最优创意-创意推荐1.0
     *
     * @param valueMap
     * @return
     */
    public static Long getBestIdeaId(List<AdxIdeaMaterialDo> ideaMaList, Map<Long, Double> valueMap) {

        Long ret = null;
        if (AssertUtil.isEmpty(ideaMaList)) {
            return ret;
        }

        if (ideaMaList.size() == 1) {
            ret = ideaMaList.get(0).getIdeaId();

        } else {

            if (AssertUtil.isNotEmpty(valueMap) && !valueMap.isEmpty()) {

                //按降序排列
                Map<Long, Double> sortedMap = AdxStatData.sortMapByValueDescend(valueMap);
                List<Long> sortedKeyList = new ArrayList<>(sortedMap.keySet());
                List<Double> sortedValueList = new ArrayList<>(sortedMap.values());

                List<Double> flowRateList = new ArrayList<>(ideaMaList.size());
                Double maxExpValue = sortedValueList.get(0);
                Double minExpValue = sortedValueList.get(ideaMaList.size() - 1);
                for (int ind = 0; ind < ideaMaList.size(); ind++) {

                    if (maxExpValue.equals(minExpValue)) {
                        flowRateList.add(weight[0]);

                    } else {

                        if (ind < weight.length) {
                            flowRateList.add(weight[ind]);
                        } else {
                            flowRateList.add(weight[weight.length - 1]);
                        }

                        if (ind >= 1 && sortedValueList.get(ind).equals(sortedValueList.get(ind - 1))) {
                            flowRateList.set(ind, flowRateList.get(ind - 1));
                        }
                    }
                }

                Integer retIndex = AdxStatData.flowSplit(flowRateList);
                ret = sortedKeyList.get(retIndex);
            }
        }

        return ret;
    }


    /**
     * 获取可投放创意素材集合
     *
     * @param staticIdeaList  静态创意素材
     * @param dynamicIdeaList 动态创意素材
     * @return
     */
    public static List<AdxIdeaFeatureDo> getIdeaList(List<AdxIdeaFeatureDo> staticIdeaList,
                                                     List<AdxIdeaFeatureDo> dynamicIdeaList) {

        List<AdxIdeaFeatureDo> ret = new ArrayList<>();
        if (AssertUtil.isNotEmpty(staticIdeaList) && staticIdeaList.size() > 0) {
            ret = staticIdeaList;
        }
        if (AssertUtil.isNotEmpty(dynamicIdeaList) && dynamicIdeaList.size() > 0) {
            ret = Stream.of(ret, dynamicIdeaList).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }

        return ret;

    }


    /**
     * 解析特征map
     *
     * @param adxFeatureDo 静态特征
     * @param ideaList     动态特征
     * @return
     */
    public static Map<AdxIdeaMaterialDo, FeatureMapDo> getFeatureMap(AdxFeatureDo adxFeatureDo,
                                                                     List<AdxIdeaFeatureDo> ideaList) {

        Map<AdxIdeaMaterialDo, FeatureMapDo> featureMap = new HashMap<>();

        //1 非创意特征：静态特征解析
        Map<String, String> staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo);

        //2 创意特征：动态特征解析
        if (AssertUtil.isEmpty(ideaList)) {
            return featureMap;
        }
        for (AdxIdeaFeatureDo ideaDo : ideaList) {
            Long ideaId = ideaDo.getIdeaId();
            Long materialId = ideaDo.getMaterialId();
            AdxIdeaMaterialDo ideaMaterial = new AdxIdeaMaterialDo(ideaId, materialId);

            AdxFeatureDo dynamicDo = new AdxFeatureDo();
            dynamicDo.setIdeaId(ideaId); // 创意ID f3010010
            dynamicDo.setButtonText(ideaDo.getButtonText()); // 按钮文字 f3010020
            dynamicDo.setIconH(ideaDo.getIconH()); // 创意图标高 f3010030
            dynamicDo.setIconW(ideaDo.getIconW()); // 创意图标宽 f3010040
            dynamicDo.setMjPicType(ideaDo.getMjPicType()); // 规格类型 f3010050
            dynamicDo.setIdeaPicH1(ideaDo.getIdeaPicH1()); // 创意图片高1 f3010060
            dynamicDo.setIdeaPicW1(ideaDo.getIdeaPicW1()); // 创意图片宽1 f3010070
            dynamicDo.setIdeaPicH2(ideaDo.getIdeaPicH2()); // 创意图片高2 f3010080
            dynamicDo.setIdeaPicW2(ideaDo.getIdeaPicW2()); // 创意图片宽2 f3010090
            dynamicDo.setIdeaPicH3(ideaDo.getIdeaPicH3()); // 创意图片高3 f3010100
            dynamicDo.setIdeaPicW3(ideaDo.getIdeaPicW3()); // 创意图片宽3 f3010110
            dynamicDo.setIdeaPicNum(ideaDo.getIdeaPicNum()); // 创意图片个数 f3010120
            dynamicDo.setStyleStandard(ideaDo.getStyleStandard()); // 广告样式规格 f3010130
            dynamicDo.setIdeaType(ideaDo.getIdeaType()); // 互动创意类型 f3010140
            dynamicDo.setPictureType(ideaDo.getPictureType()); //素材图片类型（1=图片 3=视频）f3030000
            dynamicDo.setMaterialId(materialId);
            dynamicDo.setPictureMaterialDo(ideaDo.getPictureMaterialDo()); //创意图片素材特征
            dynamicDo.setVideoMaterialDo(ideaDo.getVideoMaterialDo()); //创意视频素材特征
            Map<String, String> dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic(dynamicDo, adxFeatureDo);

            //3 封装创意素材特征集合
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(ideaMaterial, featureMapDo);
        }

        return featureMap;
    }


    /**
     * 根据召回素材集，取交集后的候选集
     *
     * @param
     * @return
     */
    public static List<AdxIdeaMaterialDo> getCandidateList(List<AdxIdeaMaterialDo> ideaMaList,
                                                           AdxMaterialRecallDo recallInfo) {

        if (AssertUtil.isEmpty(ideaMaList) || ideaMaList.size() == 0) {
            return null;
        }

        if (AssertUtil.isEmpty(recallInfo) || AssertUtil.isEmpty(recallInfo.getRecallList())
                || recallInfo.getRecallList().size() == 0) {
            return ideaMaList;
        }

        List<AdxIdeaMaterialDo> ret = new ArrayList<>();
        Set<Long> maRecallList = recallInfo.getRecallList();
        ideaMaList.forEach(ideaMaterial -> {
            boolean isPresent = maRecallList.stream().
                    anyMatch(materialId -> materialId.equals(ideaMaterial.getMaterialId()));
            if (isPresent) {
                ret.add(ideaMaterial);
            }
        });

        return ret;
    }


    /**
     * 创意素材排序-创意推荐3.0
     *
     * @param
     * @return
     */
    public static AdxIdeaMaterialDo getRank(List<AdxIdeaMaterialDo> ideaMaterialList,
                                            Map<AdxIdeaMaterialDo, Double> preCtrMap,
                                            Map<AdxIdeaMaterialDo, AdxStatsDo> ideaMaStatsList,
                                            Map<Long, AdxStatsDo> resoMaStatInfo,
                                            Map<Long, AdxStatsDo> userResoMaStatInfo) {
        AdxIdeaMaterialDo ret = null;

        double preWeight = 0.8; //模型预估权重
        double ctrWeight = 0.8; //ctr得分占比
        long expLimit = 10L; //用户+资源位+素材 当天曝光阈值

        double tmpScore = -1000000.0;
        for (AdxIdeaMaterialDo ideaMaterial : ideaMaterialList) {

            Long materialId = ideaMaterial.getMaterialId();

            AdxStatsDo ideaMaStats = Optional.ofNullable(ideaMaStatsList.get(ideaMaterial)).orElse(new AdxStatsDo());
            AdxIndexStatsDo ma20MinInfo = AdxStatData.getAdxTimeIndex(ideaMaStats, "20min");
            AdxIndexStatsDo ma1DayInfo = AdxStatData.getAdxTimeIndex(ideaMaStats, "1day");

            AdxStatsDo resoMaStats = Optional.ofNullable(resoMaStatInfo.get(materialId)).orElse(new AdxStatsDo());
            AdxIndexStatsDo resoMa20MinInfo = AdxStatData.getAdxTimeIndex(resoMaStats, "20min");

            AdxStatsDo userResoMaStats = Optional.ofNullable(userResoMaStatInfo.get(materialId)).orElse(new AdxStatsDo());
            AdxIndexStatsDo userResoMa1DayInfo = AdxStatData.getAdxTimeIndex(userResoMaStats, "1day");

            Double pCtr = preCtrMap.get(ideaMaterial);
            Double sCtr = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ma20MinInfo.getCtr(), ma1DayInfo.getCtr()), resoMa20MinInfo.getCtr());
            Double ctrScore = AdxStatData.getConCtr(pCtr, sCtr, preWeight, 0.0, 4.0, 0.01);
            Double rpmScore = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ma20MinInfo.getRpm(), ma1DayInfo.getRpm()), resoMa20MinInfo.getRpm());

            // ctr与rpm融合
            Double conScore = ctrWeight * ctrScore + (1 - ctrWeight) * rpmScore;

            // 多次曝光降权
            Double score = conScore * DataUtil.division(expLimit, (expLimit + userResoMa1DayInfo.getExpCnt()));


            if (score > tmpScore) {
                tmpScore = score;
                ret = ideaMaterial;
            }
        }

        return ret;
    }


    /**
     * 新创意素材试投池-创意推荐3.0
     *
     * @param
     * @return
     */
    public static List<AdxIdeaMaterialDo> getRawList(List<AdxIdeaFeatureDo> ideaList,
                                                     Map<Long, AdxStatsDo> resoMaStatInfo) {
        List<AdxIdeaMaterialDo> rawList = null;
        long expLimit = 200L; //资源位+素材 近3天曝光阈值

        ideaList.forEach(ideaDo -> {
            Long ideaId = ideaDo.getIdeaId();
            Long materialId = ideaDo.getMaterialId();
            AdxIdeaMaterialDo ideaMaterial = new AdxIdeaMaterialDo(ideaId, materialId);
            AdxStatsDo resoMaStats = Optional.ofNullable(resoMaStatInfo.get(materialId)).orElse(new AdxStatsDo());
            AdxIndexStatsDo resoMa3DayInfo = AdxStatData.getAdxTimeIndex(resoMaStats, "3day");
            if (resoMa3DayInfo.getExpCnt() < expLimit) {
                rawList.add(ideaMaterial);
            }
        });

        return rawList;
    }


    /**
     * 获取推荐结果-创意推荐3.0
     *
     * @param
     * @return
     */
    public static AdxIdeaMaterialDo getBestIdeaMaterial(List<AdxIdeaFeatureDo> ideaList,
                                                        AdxIdeaMaterialDo rankResult,
                                                        List<AdxIdeaMaterialDo> rawList) {
        AdxIdeaMaterialDo ret = null;
        double rawRate = 0.02; //试投比例

        if (AssertUtil.isNotEmpty(rawList) && rawList.size() > 0) {
            Random random = new Random();
            int n = random.nextInt(rawList.size());
            ret = Math.random() < rawRate ? rawList.get(n) : rankResult;
        } else {
            ret = rankResult;
        }

        if (AssertUtil.isEmpty(ret)) {
            ret = new AdxIdeaMaterialDo(ideaList.get(0).getIdeaId(), ideaList.get(0).getMaterialId());
        }

        return ret;
    }
}
