package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDircetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecrtlyPriceReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorSubDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class AdxDirectlyBidding {


    /**
     * 算法接口2-直投算法出价
     *
     * @param directlyIdeaDoInfo 直投创意信息
     * @param directlyFactorInfo 直投ROI维稳因子试探表
     * @return
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyBidding.class);

    /**
     *
     * @param adxDirecrtlyPriceReqDo
     * @return
     */
    public static List<AdxDirecetlyPriceDo> getAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        List<AdxDirecetlyPriceDo> ret = new ArrayList<>();

        try {

            //出价阈值，当出价低于该值且竞价成功率过低时，需要适当加价
            Double priceThreshold = 60.;

            Long slotId = adxDirecrtlyPriceReqDo.getSlotId();
            Double floorPrice = adxDirecrtlyPriceReqDo.getFloorPrice();
            Integer advertCnt = adxDirecrtlyPriceReqDo.getAdvertCnt();
            Double slotShareRate = adxDirecrtlyPriceReqDo.getSlotShareRate();
            if (slotShareRate == null) {
                slotShareRate = 1.;
            }
            List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = adxDirecrtlyPriceReqDo.getAdxDirecetlyPriceDos();

            //维稳因子对象
            AdxMeiTuanFactorDo adxMeiTuanFactorDo = adxDirecrtlyPriceReqDo.getAdxMeiTuanFactorDo();

            //广告位维度维稳因子
            AdxMeiTuanFactorSubDo slotFactorDo = adxMeiTuanFactorDo.getSlotFactorDo();
            Double slotFactor = slotFactorDo.getRoiFactor();

            //竞价成功率调节因子
            Double sucFactor = slotFactorDo.getSucFactor();
            if(sucFactor == null) {
                sucFactor = 0.;
            }

            //计划维度维稳因子
            AdxMeiTuanFactorSubDo advFactorDo = new AdxMeiTuanFactorSubDo();
            Double advFactor = 1.0;

            //计划上设置的分成比例
            Double advShareRate = null;

            if(advertCnt == null) {
                advertCnt = 5;
            }

            int count = 0;

            for(AdxDirecetlyPriceDo adxDirecetlyPriceDo : adxDirecetlyPriceDos) {

                if(count >= advertCnt) {
                    break;
                }

                Long advertId = adxDirecetlyPriceDo.getAdvertId();
                advShareRate = adxDirecetlyPriceDo.getAdvShareRate();
                //nezha发券价格
                Double advPrice = adxDirecetlyPriceDo.getAdvPrice();
                System.out.println(advPrice);
                //底价过滤
                if(advPrice == null) {
                    continue;
                }

                //计划维度上的维稳因子
                advFactorDo = AdxMeiTuanFactorDo.getAdvFactorSubDo(adxMeiTuanFactorDo, advertId);
                if(advFactorDo != null) {
                    advFactor = advFactorDo.getRoiFactor();

                }

                //如果计划维度未设置分成比例，或者维稳因子不置信，则使用广告位维度
                if(advShareRate == null || !advFactorDo.getConfident()) {
                    advShareRate = slotShareRate;
                    advFactor = slotFactor;
                }

                if (advShareRate == null) {advShareRate = 1.;}
                if (advFactor == null) {advFactor = 1.;}

                Double price = advPrice * advShareRate * advFactor;

                //控制竞价成功率，过低时需要适当加价
                if(price <= priceThreshold) {
                    price = price + (priceThreshold - price) * sucFactor;
                }

                //出价低于底价，一定的概率提升出价
                if(price < floorPrice * 0.9) {
                    continue;
                }else if(price >= floorPrice * 0.9 && advFactor > 1. && Math.random() > 0.9) {
                    price = Math.max(price, floorPrice);
                }

                price = MathUtil.stdwithBoundary(price, floorPrice, advPrice);

                adxDirecetlyPriceDo.setAdxPrice(price);
                ret.add(adxDirecetlyPriceDo);

                count++;
                System.out.println(count);
            }

        } catch (Exception e) {
            logger.error("Meituan AdxDirectlyBidding.getAlgoPrice error" + e);
        }
        System.out.println(JSON.toJSONString(ret));
        return ret;
    }

    public static Double getFactor() {
        return null;
    }

    public static AdxDircetlyPriceDo getAlgoPrice(AdxDirectlyIdeaDo directlyIdeaInfo,
                                                  AdxDirectlyFactorDo directlyFactorInfo) {

        AdxDircetlyPriceDo ret = new AdxDircetlyPriceDo();

        try {

            // 1.设置默认值
            Double roiFactor = 1.0;            // ROI调节因子
            Double lowerLimit = 0.3;           // ROI调节因子下限
            Double upperLimit = 1.7;           // ROI调节因子上限

            Long algoPrice = 0L;
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_TWO.getCode();


            // 2.获取统计信息
            Long ideaBidCntMs = 0L;
            if (AssertUtil.isAllNotEmpty(directlyIdeaInfo)) {
                AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(directlyIdeaInfo.getIdeaIndexMap());
                ideaBidCntMs = AdxStatData.nullToMinDefault(interIndexStatMs.getBidCnt(),0L);
            }


            // 3.获取level和调节因子
            if (AssertUtil.isNotEmpty(directlyFactorInfo) && ideaBidCntMs != 0L) {

                Map<String, Double> factorMap = directlyFactorInfo.getFactorExploreMap();
                Map<String, Double> FlowRateMap = directlyFactorInfo.getFactorFlowRateMap();
                Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, factorMap, 1.0);

                level = result.get("level");
                roiFactor = AdxStatData.getNormalValue(DataUtil.string2Double(result.get("factor")), 1.0, lowerLimit, upperLimit);

            }


            // 3.计算出价
            if (AssertUtil.isNotEmpty(directlyIdeaInfo)) {

                Double minRoi = AdxStatData.nullToMinDefault(directlyIdeaInfo.getMinRoi(), 1.0);
                Double cpcPrice = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyCpcPrice(), 0.0);
                Double preCtr = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyPreCtr(), 0.0);

                // 出价 = 广告计划CPC出价(分) * 直投CTR预估 * 1000 /（设置ROI * ROI调节因子）
                algoPrice = Math.round(Math.floor(DataUtil.division(cpcPrice * preCtr * 1000L, minRoi * roiFactor)));

            }

            ret.setAdxAlgoPrice(algoPrice);
            ret.setStrategy(strategy);
            ret.setLevel(level);


        } catch(Exception e){
            logger.error("AdxDirectlyBidding.getAlgoPrice error:" + e);

        }

        return ret;
    }

}
