package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowFilterAlg {

    /**
     * 流量过滤
     *
     * @param flowFilterRequestDo
     * @return
     */

    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFilterAlg.class);

    public static FlowFilterResultDo adxFlowFiltering(FlowFilterRequestDo flowFilterRequestDo) {

        FlowFilterResultDo ret = new FlowFilterResultDo();

        try {

            if (valid(flowFilterRequestDo)) {

                //【流量预过滤--ctr&roi过滤】
                ret = AdxFlowFiltering.getFlowFiltering(flowFilterRequestDo);
                Integer flowFilterLabel = ret.getFlowFilterLabel();


                Integer flowGroup = AdxStatData.nullToDefault(flowFilterRequestDo.getFlowGroup(), 1);
                Integer baseFilterFlag = AdxStatData.nullToDefault(flowFilterRequestDo.getBaseFilterFlag(), 0);

                if(AssertUtil.isNotEmpty(flowFilterLabel) && flowFilterLabel.equals(0)){

                    if ( (flowGroup.equals(1) && baseFilterFlag.equals(1)) || flowGroup.equals(3)) {
                        //【每pv发券过滤】
                        FlowFilterResultDo launchPvRet= LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
                        ret.setFlowFilterLabel(launchPvRet.getFlowFilterLabel());
                        ret.setFilterType(launchPvRet.getFilterType());
                        ret.setPreLaunchPv(launchPvRet.getPreLaunchPv());

                    } else if (flowGroup.equals(4)) {
                        //【每pv点券过滤】
                        FlowFilterResultDo chargePvRet= ChargePvFiltering.getChargePvFiltering(flowFilterRequestDo);
                        ret.setFlowFilterLabel(chargePvRet.getFlowFilterLabel());
                        ret.setFilterType(chargePvRet.getFilterType());
                        ret.setPreChargePv(chargePvRet.getPreChargePv());

                    }

                }
            }

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering error:" + e);

        }

        return ret;
    }


    /**
     * 流量预过滤1.0定时任务
     * (根据缓存数据，调用频率：30min调用1次）
     *
     * @param flowInfo   adx流量信息
     * @param lastFilterInfo 上一次出参（定时任务）
     * @return
     */
    public static AdxFilterInfoDo adxFilterTask(AdxFlowInfoDo flowInfo,
                                                AdxFilterInfoDo lastFilterInfo) {

        AdxFilterInfoDo ret = null;

        try {
            ret = AdxFilterTask.getFilterInfo(flowInfo, lastFilterInfo);

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTask error " + e);

        }

        return ret;
    }



    /**
     * 流量预过滤2.0定时任务
     * (根据缓存数据，调用频率：30min调用1次）
     *
     * @param flowInfo   adx流量信息
     * @param lastFilterInfo 上一次出参（定时任务）
     * @return
     */
    public static AdxFilterInfoDo adxFilterTaskPlus(AdxFlowInfoDo flowInfo,
                                                    AdxFilterInfoDo lastFilterInfo) {

        AdxFilterInfoDo ret = null;

        try {
            ret = AdxFilterTaskPlus.getFilterInfo(flowInfo, lastFilterInfo);

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTaskPlus error " + e);

        }

        return ret;
    }


    /**
     * 校验基础信息是否合法
     *
     * @param flowFilterRequestDo
     * @return
     */
    private static Boolean valid(FlowFilterRequestDo flowFilterRequestDo) {

        Boolean ret = true;

        if (flowFilterRequestDo == null) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering() input params valid , params flowFilterRequestDo is null");
            return false;
        }

        return ret;
    }

}
