package cn.com.duiba.nezha.alg.alg.plugins;

import cn.com.duiba.nezha.alg.alg.vo.plug.PreSelectActResPlugDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class ActPlugInRcmdAlg {

    private static final Logger logger = LoggerFactory.getLogger(ActPlugInRcmdAlg.class);


    /**
     *响应插件推荐2.0
     *
     * @param plugList  插件集合(统计数据，日粒度)
     * @param actFeatureDo 特征，封装
     *
     * @param coderModel  编码器模型 redis获取
     *
     * @param ltfModel  本地深度模型
     *
     * @param preSelectActResPlugIndexDoList  海选的插件次序对象
     *
     * @param preSelectActResPlugIdDoList  海选的插件ID对象
     *
     *
     * @return
     */
    public static ResPlugInRcmdDo rcmd3(List<ResPlugInRcmdDo> plugList,
                                        ActFeatureDo actFeatureDo,
                                        CODER coderModel,
                                        LocalTFModel ltfModel,
                                        List<PreSelectActResPlugDo> preSelectActResPlugIndexDoList,
                                        List<PreSelectActResPlugDo> preSelectActResPlugIdDoList
                                        ) {
        ResPlugInRcmdDo ret = null;
        try {
            ret = ActPlugInDQNRcmder2.rcmd3(plugList, actFeatureDo, coderModel, ltfModel,preSelectActResPlugIndexDoList,preSelectActResPlugIdDoList);
        } catch (Exception e) {
            logger.error("ActPlugInRcmdAlg.rcmd3 error" ,e);
        }
        return ret;


    }

    /**
     *响应插件推荐2.0
     *
     * @param plugList  插件集合(统计数据，日粒度)
     * @param actFeatureDo 特征，封装
     *
     * @param coderModel  编码器模型 redis获取
     *
     * @param ltfModel  本地深度模型
     *
     * @return
     */
    public static ResPlugInRcmdDo rcmd2(List<ResPlugInRcmdDo> plugList,
                                       ActFeatureDo actFeatureDo,
                                       CODER coderModel,
                                       LocalTFModel ltfModel) {
        ResPlugInRcmdDo ret = null;
        try {
            ret = ActPlugInDQNRcmder.rcmd2(plugList, actFeatureDo, coderModel, ltfModel);
        } catch (Exception e) {
            logger.error("ActPlugInRcmdAlg.rcmd error" ,e);
        }
        return ret;
    }


    /**
     *响应插件推荐
     *
     * @param plugList  插件集合
     * @param actFeatureDo 特征，封装
     *
     * @param coderModel  编码器模型 redis获取
     *
     * @param ltfModel  本地深度模型
     *
     * @return
     */
    public static ResPlugInRcmdDo rcmd(List<ResPlugInRcmdDo> plugList,
                                       ActFeatureDo actFeatureDo,
                                       CODER coderModel,
                                       LocalTFModel ltfModel) {
        ResPlugInRcmdDo ret = null;
        try {
            ret = ActPlugInDQNRcmder.rcmd(plugList, actFeatureDo, coderModel, ltfModel);
        } catch (Exception e) {
            logger.error("ActPlugInRcmdAlg.rcmd error" , e);
        }
        return ret;
    }


}
