/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rtbbid;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxStrategyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.CpcControlDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.CpcControlReqDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpcControlTask {
    private static final Logger logger = LoggerFactory.getLogger(CpcControlTask.class);

    public static CpcControlDo getCpcControl(CpcControlReqDo cpcControlReqDo) {
        CpcControlDo ret = new CpcControlDo();
        try {
            Double defaultFactor = 1.0;
            Double lowerFactor = 0.1;
            Double upperFactor = 1.9;
            Double targetCpc = 1.0;
            Integer tryLabel = 0;
            Double baseValue = defaultFactor;
            Double[] stepList = new Double[]{-0.05, 0.0, 0.05};
            Double[] flowRateList = new Double[]{0.2, 0.6, 0.2};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3};
            Integer len = AdxLevel.values().length - 1;
            HashMap<String, Double> factorMap = new HashMap<String, Double>(len);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(len);
            Map<String, Double> cpcMap = new HashMap<String, Double>(len);
            HashMap sucRateMap = new HashMap(len);
            Long bidCntMin = 0L;
            Long sucCntMin = 0L;
            Long clickCntMin = 0L;
            Long adxCostMin = 0L;
            Long adConsumeMin = 0L;
            Long bidCntDay = 0L;
            Long sucCntDay = 0L;
            Long clickCntDay = 0L;
            Long adxCostDay = 0L;
            Long adConsumeDay = 0L;
            Double cpcMin = null;
            Double sucMin = null;
            Double cpcDay = null;
            Double sucDay = null;
            Double conCpcMin = null;
            if (AssertUtil.isNotEmpty((Object)cpcControlReqDo)) {
                AdxStatsDo resoStats = Optional.ofNullable(cpcControlReqDo.getResoStats()).orElse(new AdxStatsDo());
                AdxIndexStatsDo resoStatsMin = AdxStatData.getAdxTimeIndex(resoStats, "20min");
                AdxStatsDo ideaStats = Optional.ofNullable(cpcControlReqDo.getIdeaStats()).orElse(new AdxStatsDo());
                AdxIndexStatsDo ideaMinStats = AdxStatData.getAdxTimeIndex(ideaStats, "20min");
                AdxIndexStatsDo ideaDayStats = AdxStatData.getAdxTimeIndex(ideaStats, "1day");
                Map<String, AdxStrategyDo> strategyInfo = cpcControlReqDo.getStrategyLevelStats();
                List<AdxLevelDo> firStrategyInfo = AdxStatData.getStrategyInfo(strategyInfo, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                AdxIndexStatsDo strategyMinStats = AdxStatData.getStrategyIndex(firStrategyInfo, "20min");
                AdxIndexStatsDo strategyDayStats = AdxStatData.getStrategyIndex(firStrategyInfo, "1day");
                Map<String, Long> bidCntMinLevel = AdxStatData.getLevelIndex(firStrategyInfo, AdxIndex.BID.getCode(), "20min", 1L);
                Map<String, Long> clickCntMinLevel = AdxStatData.getLevelIndex(firStrategyInfo, AdxIndex.CLICK.getCode(), "20min", 1L);
                Map<String, Long> adxCostMinLevel = AdxStatData.getLevelIndex(firStrategyInfo, AdxIndex.ADX_CONSUME.getCode(), "20min", 1L);
                Map<String, Long> adConsumeMinLevel = AdxStatData.getLevelIndex(firStrategyInfo, AdxIndex.ADVERT_CONSUME.getCode(), "20min", 1L);
                Map<String, Double> sucRateMinLevel = AdxStatData.getLevelIndex(firStrategyInfo, "sucRate", "20min");
                Map<String, Double> cpcMinLevel = AdxStatData.getLevelIndex(firStrategyInfo, "cpc", "20min");
                targetCpc = AdxStatData.nullToDefault(cpcControlReqDo.getTargetCpc(), 1.0);
                tryLabel = CpcControlTask.getTryLabel(strategyMinStats.getBidCnt(), targetCpc, adxCostMinLevel, sucRateMinLevel, cpcMinLevel);
                Integer lastTryLabel = 0;
                Double lastTargetCpc = 1.0;
                Double lastBaseValue = defaultFactor;
                Double lastLowValue = defaultFactor + stepList[0];
                Double lastUppValue = defaultFactor + stepList[2];
                Map<Object, Object> lastFactorMap = new HashMap(len);
                HashMap<String, Double> lastFlowRateMap = new HashMap(len);
                String bestLevel = AdxLevel.ADX_LEVEL_TWO.getCode();
                CpcControlDo lastControlInfo = cpcControlReqDo.getCpcControlInfo();
                if (AssertUtil.isNotEmpty((Object)lastControlInfo)) {
                    lastTargetCpc = AdxStatData.nullToDefault(lastControlInfo.getTargetCpc(), 1.0);
                    lastTryLabel = AdxStatData.nullToDefault(lastControlInfo.getTryLabel(), 0);
                    lastFlowRateMap = lastControlInfo.getFlowRateMap();
                    lastFactorMap = lastControlInfo.getFactorMap();
                    if (AssertUtil.isNotEmpty(lastFactorMap)) {
                        lastBaseValue = (Double)lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                        lastLowValue = (Double)lastFactorMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                        lastUppValue = (Double)lastFactorMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                    }
                    bestLevel = AdxStatData.selectCpcBestLevel(bidCntMinLevel, clickCntMinLevel, adxCostMinLevel, targetCpc);
                }
                Double conCpc = AdxStatData.getConCpc(strategyMinStats, strategyDayStats, targetCpc, 0.7);
                Double conCpcDiff = DataUtil.division((Double)conCpc, (Double)targetCpc, (int)3);
                Map<String, Double> conCpcMinLevel = AdxStatData.getConCpcLevel(clickCntMinLevel, adxCostMinLevel, targetCpc);
                cpcMap = conCpcMinLevel;
                conCpcMin = conCpc;
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (targetCpc.compareTo(lastTargetCpc) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || !strategyDayStats.getConfident().booleanValue()) {
                    baseValue = defaultFactor;
                } else {
                    Double adjustCoeff = CpcControlTask.getAdjustCoeff(lastBaseValue, bestLevel, conCpcDiff, diffList, lastFactorMap, strategyMinStats.getSucRate());
                    baseValue = CpcControlTask.getBaseValue(tryLabel, lastTryLabel, adjustCoeff, lastBaseValue, lastUppValue, lowerFactor, upperFactor);
                }
                stepList = CpcControlTask.getStep(tryLabel, targetCpc, baseValue, lastLowValue, lastUppValue, conCpcDiff, conCpcMinLevel, strategyMinStats.getAdxConsume(), adxCostMinLevel);
                flowRateList = CpcControlTask.getFlowRate(tryLabel, targetCpc, conCpcDiff, conCpcMinLevel, adxCostMinLevel, lastFlowRateMap);
                bidCntMin = strategyMinStats.getBidCnt();
                sucCntMin = strategyMinStats.getSucCnt();
                clickCntMin = strategyMinStats.getClickCnt();
                adxCostMin = strategyMinStats.getAdxConsume();
                adConsumeMin = strategyMinStats.getAdvertConsume();
                sucMin = strategyMinStats.getSucRate();
                cpcMin = strategyMinStats.getCpc();
                bidCntDay = strategyDayStats.getBidCnt();
                sucCntDay = strategyDayStats.getSucCnt();
                clickCntDay = strategyDayStats.getClickCnt();
                adxCostDay = strategyDayStats.getAdxConsume();
                adConsumeDay = strategyDayStats.getAdvertConsume();
                sucDay = strategyDayStats.getSucRate();
                cpcDay = strategyDayStats.getCpc();
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = Integer.valueOf(key);
                Double factor = AdxStatData.getNormalValue(baseValue + stepList[i - 1], defaultFactor, lowerFactor, upperFactor, 6);
                Double flowRate = DataUtil.formatDouble((Double)flowRateList[i - 1], (int)3);
                factorMap.put(key, factor);
                flowRateMap.put(key, flowRate);
            }
            ret.setFactorMap(factorMap);
            ret.setFlowRateMap(flowRateMap);
            ret.setTryLabel(tryLabel);
            ret.setTargetCpc(targetCpc);
            ret.setCpcMap(cpcMap);
            ret.setConCpcMin(conCpcMin);
            ret.setBidCntMin(bidCntMin);
            ret.setSucCntMin(sucCntMin);
            ret.setClickCntMin(clickCntMin);
            ret.setAdxCostMin(adxCostMin);
            ret.setAdConsumeMin(adConsumeMin);
            ret.setSucMin(sucMin);
            ret.setCpcMin(cpcMin);
            ret.setBidCntDay(bidCntDay);
            ret.setSucCntDay(sucCntDay);
            ret.setClickCntDay(clickCntDay);
            ret.setAdxCostDay(adxCostDay);
            ret.setAdConsumeDay(adConsumeDay);
            ret.setSucDay(sucDay);
            ret.setCpcDay(cpcDay);
        }
        catch (Exception e) {
            logger.error("RtbBidAlg.getCpcControl error", (Throwable)e);
        }
        return ret;
    }

    private static Integer getTryLabel(Long bidCnt, Double targetCpc, Map<String, Long> adxCostLevel, Map<String, Double> sucRateLevel, Map<String, Double> cpcLevel) {
        Integer ret = 0;
        Long baseAdxCost = 0L;
        Long uppAdxCost = 0L;
        Double baseSucRate = null;
        Double uppSucRate = null;
        Double baseCpc = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{sucRateLevel, adxCostLevel, cpcLevel})) {
            baseAdxCost = AdxStatData.nullToDefault(adxCostLevel.get(AdxLevel.ADX_LEVEL_TWO.getCode()), 0L);
            uppAdxCost = AdxStatData.nullToDefault(adxCostLevel.get(AdxLevel.ADX_LEVEL_THR.getCode()), 0L);
            baseSucRate = sucRateLevel.get(AdxLevel.ADX_LEVEL_TWO.getCode());
            uppSucRate = sucRateLevel.get(AdxLevel.ADX_LEVEL_THR.getCode());
            baseCpc = cpcLevel.get(AdxLevel.ADX_LEVEL_TWO.getCode());
        }
        if (bidCnt.equals(0L)) {
            ret = 2;
        } else if ((AssertUtil.isEmpty(uppSucRate) || uppSucRate < 0.02) && uppAdxCost < 200L) {
            ret = 1;
        } else if ((AssertUtil.isEmpty(baseSucRate) || baseSucRate < 0.02) && baseAdxCost < 200L && (AssertUtil.isEmpty(baseCpc) || baseCpc > targetCpc * 1.05 || baseCpc < targetCpc * 0.95)) {
            ret = 1;
        }
        return ret;
    }

    private static Double getAdjustCoeff(Double lastBaseValue, String bestLevel, Double diff, Double[] diffList, Map<String, Double> lastFactorMap, Double sucRateMs) {
        Double ret = 1.0;
        lastFactorMap = Optional.ofNullable(lastFactorMap).orElse(new HashMap());
        Double lastBestValue = AdxStatData.nullToDefault((Double)lastFactorMap.get(bestLevel), lastBaseValue);
        Double incre1 = DataUtil.division((Double)lastBestValue, (Double)lastBaseValue, (int)3);
        incre1 = AdxStatData.getNormalValue(incre1, 1.0, 0.9, 1.1);
        Double weight1 = Math.abs(diff - 1.0) < 0.1 ? 1.0 : (Math.abs(diff - 1.0) < 0.2 ? 0.8 : (Math.abs(diff - 1.0) < 0.4 ? 0.5 : 0.0));
        if (AssertUtil.isEmpty((Object)sucRateMs) || sucRateMs < 0.02) {
            weight1 = 0.0;
        }
        Double incre2 = DataUtil.division((Double)0.98, (Double)diff, (int)3);
        Double remainStableLimit = diff < 0.9 ? 0.3 : (diff < 1.1 ? 0.2 : 0.3);
        incre2 = AdxStatData.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
        Double weight2 = 1.0;
        if (AssertUtil.isEmpty((Object)sucRateMs) || sucRateMs < 0.02) {
            weight2 = 0.0;
        }
        ret = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
        if (weight1 == 0.0) {
            ret = 1.0 + (incre2 - 1.0) * weight2;
        }
        Double range = AdxStatData.bucket((Double)Math.abs(diff - 1.0), diffList);
        ret = DataUtil.formatDouble((Double)AdxStatData.getNormalValue(ret, 1.0, 1.0 - range, 1.0 + range), (int)6);
        return ret;
    }

    private static Double getBaseValue(Integer tryLabel, Integer lastTryLabel, Double coeff, Double lastBaseValue, Double lastUppValue, Double lowerLimit, Double upperLimit) {
        Double defaultFactor;
        Double ret = defaultFactor = Double.valueOf(1.0);
        if (tryLabel.equals(2)) {
            ret = ret - (lastBaseValue - defaultFactor) * 0.2;
        } else if (tryLabel.equals(1)) {
            ret = lastBaseValue;
        } else if (tryLabel.equals(0)) {
            ret = lastTryLabel.equals(1) ? lastUppValue : Double.valueOf(lastBaseValue * coeff);
        }
        ret = AdxStatData.getNormalValue(ret, defaultFactor, lowerLimit, upperLimit, 6);
        return ret;
    }

    private static Double[] getStep(Integer tryLabel, Double targetCpc, Double baseValue, Double lastLowValue, Double lastUppValue, Double diff, Map<String, Double> cpcLevel, Long adxCostMin, Map<String, Long> adxCostLevel) {
        Double[] retList = new Double[]{-0.05, 0.0, 0.05};
        Double defaultFactor = 1.0;
        if (tryLabel.equals(2)) {
            Double uppDiff = lastUppValue - defaultFactor;
            retList[2] = lastUppValue - uppDiff * 0.2 - baseValue;
            Double lowDiff = lastLowValue - defaultFactor;
            retList[0] = lastLowValue - lowDiff * 0.2 - baseValue;
        } else if (tryLabel.equals(1)) {
            Double step1 = 0.0;
            Double step1Limit = 0.1;
            Long tryAdxCost = adxCostLevel.get(AdxLevel.ADX_LEVEL_THR.getCode());
            step1 = tryAdxCost <= 200L ? Double.valueOf((1.0 - DataUtil.division((Long)tryAdxCost, (Long)200L)) * step1Limit) : Double.valueOf(Math.max(1.0 - DataUtil.division((Long)tryAdxCost, (Long)200L), -1.0) * step1Limit);
            step1 = DataUtil.formatDouble((Double)AdxStatData.getNormalValue(step1, 0.0, -step1Limit.doubleValue(), step1Limit), (int)3);
            Double uppDiff = DataUtil.division((Double)cpcLevel.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)targetCpc, (int)3);
            Double step2 = uppDiff < 0.8 ? 0.1 : (uppDiff < 0.95 ? 0.07 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? -0.07 : -0.1)));
            if (adxCostMin.equals(0L)) {
                step1 = 0.1;
                step2 = 0.1;
            }
            retList[2] = Math.max(lastUppValue - baseValue + (0.4 * step1 + 0.6 * step2), 0.0);
            retList[0] = lastLowValue - baseValue;
        } else if (tryLabel.equals(0)) {
            Double[] doubleArray = retList;
            Double.valueOf(doubleArray[2] + (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
            doubleArray = retList;
            Double.valueOf(doubleArray[0] - (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
        }
        retList[2] = Math.max(retList[2], retList[1]);
        retList[0] = Math.min(retList[0], retList[1]);
        return retList;
    }

    private static Double[] getFlowRate(Integer tryLabel, Double targetCpc, Double diff, Map<String, Double> cpcLevel, Map<String, Long> adxCostLevel, Map<String, Double> lastFlowRateMap) {
        Double[] retList = new Double[3];
        retList[0] = 0.2;
        retList[2] = 0.2;
        Double tryDiff = 1.0;
        Double lastTryRate = 0.2;
        Long tryAdxCost = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{cpcLevel, adxCostLevel, lastFlowRateMap})) {
            tryDiff = AdxStatData.nullToDefault(DataUtil.division((Double)cpcLevel.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)targetCpc, (int)3), 1.0);
            tryAdxCost = AdxStatData.nullToDefault(adxCostLevel.get(AdxLevel.ADX_LEVEL_THR.getCode()), 0L);
            lastTryRate = AdxStatData.nullToDefault(lastFlowRateMap.get(AdxLevel.ADX_LEVEL_THR.getCode()), 0.2);
        }
        if (tryLabel.equals(2)) {
            retList[2] = 0.2;
            retList[0] = 0.2;
        } else if (tryLabel.equals(1)) {
            retList[2] = AdxStatData.getTryFlowRate(tryDiff, tryAdxCost, lastTryRate);
            retList[0] = retList[2] > 0.8 ? 0.0 : (retList[2] > 0.7 ? 0.1 : 0.2);
        } else if (tryLabel.equals(0) && AssertUtil.isNotEmpty((Object)diff)) {
            if (diff > 1.1) {
                retList[2] = 0.1;
                retList[0] = diff > 1.2 ? 0.3 : 0.2;
            } else if (diff < 0.9) {
                retList[2] = diff < 0.8 ? 0.3 : 0.2;
                retList[0] = 0.1;
            } else if (diff > 0.95 && diff < 1.05) {
                retList[2] = 0.1;
                retList[0] = 0.1;
            } else {
                retList[2] = 0.15;
                retList[0] = 0.15;
            }
        }
        retList[1] = DataUtil.formatDouble((Double)(1.0 - retList[0] - retList[2]), (int)3);
        return retList;
    }

    public static void main(String[] args) {
        try {
            System.out.println("getTryLabel:" + JSON.toJSONString((Object)CpcControlTask.getTryLabel(10L, 1.0, null, null, null)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

