package cn.com.duiba.nezha.alg.alg.adx.rtbbid;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxDo;

import java.util.HashMap;
import java.util.Map;



public class AdxBidding {

    /**
     * 出价
     *
     * @param adxDoInfo  统计数据 & 模型数据
     * @return (出价:分/cpm)
     */

    public static Long getAdxParPrice(AdxDo adxDoInfo,
                                      Double roiFactor,
                                      Map<String, Long> advertConsume) {


        /**
         *
         * 步骤：
         * 步骤1、设置默认值
         * 步骤2、当前对象是否合法
         * 步骤3、获取统计数据
         * 步骤4、ctr,点击价值(降级/融合)
         * 步骤5、计算出价
         *
         */


        //1、设置默认值
        Double defaultMinRoi = 1.0;              // 默认ROI
        Double defaultRoiFactor = 1.0;           // 默认ROI调节因子
        Double lowerLimit = 0.3;                 // ROI调节因子下限
        Double upperLimit = 1.7;                 // ROI调节因子上限
        Double defaultPreCtr  = 0.01;            // 默认ctr
        Double defaultClickValue = 0.05*100;     // 默认点击价值(分/单次点击)
        Long advertConsumeDayLimit = 5*100L;     // 创意当天广告消耗阈值（分）
        Long advertConsumeMsLimit = 5*100L;      // 创意实时广告消耗阈值（分）

        Long ret = Math.round(Math.floor(defaultPreCtr * defaultClickValue * 1000/(defaultMinRoi * defaultRoiFactor)));


        //2、当前对象是否合法
        if (AssertUtil.isNotEmpty(adxDoInfo)){

            //3、获取统计数据
            Double statCtr = adxDoInfo.getStatCtr();                               //统计ctr-创意维度
            Double statCtrResource = adxDoInfo.getStatCtrResource();               //统计ctr-资源位维度
            Double currentPreValue = adxDoInfo.getPreCtr();                        //模型ctr-创意维度
            Double ideaAppStatCtr = adxDoInfo.getIdeaAppStatCtr();                 //统计ctr-创意+百度app维度
            Double resoAppStatCtr = adxDoInfo.getResoAppStatCtr();                 //统计ctr-资源位+百度app维度

            Double statClickValue = adxDoInfo.getStatClickValue();                 //统计点击价值-创意维度
            Double statClickValueResource = adxDoInfo.getStatClickValueResource(); //统计点击价值-资源位维度
            Double preAdClickValue = adxDoInfo.getPredClickValue();                //预估点击价值-预发券
            Double recTfPreClickValue = adxDoInfo.getRecTfPreClickValue();         //预估点击价值-TF模型预估+纠偏
            Double ideaAppStatCva = adxDoInfo.getIdeaAppStatCva();                 //统计点击价值-创意+百度app维度
            Double resoAppStatCva = adxDoInfo.getResoAppStatCva();                 //统计点击价值-资源位+百度app维度

            //4、ctr,点击价值(降级/融合)
            if (statCtrResource == null || statCtrResource < 0.0) { statCtrResource = defaultPreCtr; }
            if (statCtr == null || statCtr < 0.0){ statCtr = statCtrResource; }
            if (statClickValueResource == null || statClickValueResource < 0.0) { statClickValueResource = defaultClickValue; }
            if (statClickValue == null || statClickValue < 0.0){ statClickValue = statClickValueResource; }

            Double statConCtr = statCtr;
            Double statConCva = statClickValue;

            if (AssertUtil.isNotEmpty(advertConsume)) {
                //创意维度-全天累计-广告消耗
                Long ideaAdvertConsumeDay = StrategyBid.nullToDefault(advertConsume.get("ideaDay"), 0L);
                //创意维度-实时-广告消耗
                Long ideaAdvertConsumeMs = StrategyBid.nullToDefault(advertConsume.get("ideaMs"), 0L);
                //资源维度-实时-广告消耗
                Long resoAdvertConsumeMs = StrategyBid.nullToDefault(advertConsume.get("resourceMs"), 0L);

                statConCtr = DataUtil.division((ideaAdvertConsumeMs * statCtr + advertConsumeMsLimit * statCtrResource), (ideaAdvertConsumeMs + advertConsumeMsLimit),6);
                statConCva = DataUtil.division((ideaAdvertConsumeMs * statClickValue + advertConsumeMsLimit * statClickValueResource), (ideaAdvertConsumeMs + advertConsumeMsLimit),6);

                if (ideaAdvertConsumeDay < advertConsumeDayLimit) {
                    statConCtr = statCtrResource;
                    statConCva = statClickValueResource; }
            }

            //百度app维度，范围：百度流量，测试组
            Long groupId = adxDoInfo.getGroupId();
            Integer groupTag = adxDoInfo.getGroupTag();
            if (AssertUtil.isAllNotEmpty(groupId, groupTag) && groupId.equals(129L) && groupTag.equals(2)) {
                Double[] ctrDefaultList = {resoAppStatCtr, statConCtr};
                statConCtr = AdxStatData.nullToDefaultList(ideaAppStatCtr, ctrDefaultList);
                Double[] cvaDefaultList = {resoAppStatCva, statConCva};
                statConCva = AdxStatData.nullToDefaultList(ideaAppStatCva, cvaDefaultList);
            }

            //预发券：点击价值(统计值的0~4倍)
            if (preAdClickValue != null && preAdClickValue >= 0.0) {
                statConCva = StrategyBid.getNormalValue(preAdClickValue, statConCva, (statConCva*0.0), (statConCva*4.0));
            }

            // 计算融合ctr，融合点击价值
            Double conCtr = AdxStatData.getConCtr(currentPreValue, statConCtr, 0.8, 0.0, 4.0, 0.02);

            // 计算融合点击价值
            Double preCvaWeight = 0.0;
            if (AssertUtil.isAllNotEmpty(groupId, groupTag) && groupId.equals(129L) && groupTag.equals(2)) { preCvaWeight = 0.2; }
            Double conCva = AdxStatData.getConValue(recTfPreClickValue, statConCva, preCvaWeight, 0.0, 2.0, 1.0);


            //5、计算出价 = 预估曝光价值 * 1000 /（设置ROI * ROI调节因子）
            roiFactor = StrategyBid.getNormalValue(roiFactor, defaultRoiFactor, lowerLimit, upperLimit);
            Double minRoi = StrategyBid.nullToDefault(adxDoInfo.getMinRoi(), defaultMinRoi);
            ret = Math.round(Math.floor(conCtr * conCva * 1000/(minRoi * roiFactor)));

        }

        return ret;
    }





    /**
     * 预估CTR
     *
     * @param statValue          统计ctr-创意维度
     * @param modelPreValue      模型ctr-创意维度
     * @return 融合ctr
     */
    public static Double getConCtr(Double statValue, Double modelPreValue) {

        Double preCtrFactor = 0.8;    // 预估CTR占比因子
        Double defaultCtr = 0.01;     // ctr默认值
        Double fUpperLimit = 4.0;     // 比例上限
        Double fLowerLimit = 0.0;     // 比例下限
        Double vUpperLimit = 0.9999;  // 点击率上限
        Double vLowerLimit = 0.0000;  // 点击率下限

        statValue = StrategyBid.getNormalValue(statValue, defaultCtr, vLowerLimit, vUpperLimit);

        modelPreValue = StrategyBid.getNormalValue(modelPreValue, statValue, (statValue * fLowerLimit), (statValue * fUpperLimit));

        Double ret = preCtrFactor * modelPreValue + (1 - preCtrFactor) * statValue;

        ret = ret < vLowerLimit ? vLowerLimit : (ret > vUpperLimit ? vUpperLimit : ret);

        return ret;
    }







    //单元测试
    public static void main(String[] args) {

        try {

            Map<String, Long> advertConsumeInfo = new HashMap<>();
            advertConsumeInfo.put("ideaDay", 20*100L);
            advertConsumeInfo.put("ideaMs", 20*100L);
            advertConsumeInfo.put("resourceMs", 20*100L);

            AdxDo adxDoInfo1 = new AdxDo();
            adxDoInfo1.setMinRoi(1.0);
            adxDoInfo1.setPreCtr(0.50164);
            adxDoInfo1.setStatCtr(0.953488372);
            adxDoInfo1.setStatClickValue(0.341463415);
            adxDoInfo1.setStatCtrResource(0.978723404);
            adxDoInfo1.setStatClickValueResource(0.25);
            adxDoInfo1.setPredClickValue(null);
            Double roiFactor = 1.00;

            Long testParPrice = AdxBidding.getAdxParPrice(adxDoInfo1, roiFactor, advertConsumeInfo);

            System.out.println("testGetAdxParPrice:" + JSON.toJSONString(testParPrice));

            System.out.println("getConCtr:" + JSON.toJSONString(getConCtr(0.6,0.1)));

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
