package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

@Data
public class OcpxControlParams {


    /**
     * 成本维稳控制参数
     */

//    private Double mFactor = 1.0;//预估值校准因子，旧 废弃

    private Integer resetType;// 维稳重置

    private Boolean cConf; //维稳置信
    private Double cFactor; //成本控制因子

    private Double pcFactor = 1.0; //预估值校准因子


    /**
     * 底价 控制参数
     */
    private Long fPriceThre;// 底价阈值
    private Double fGiveUpProb;// 放弃概率
    private Boolean fConf;// 底价置信


    /**
     * 出价保护 控制参数
     */
//    private Long pPriceThre; //出价保护阈值
//    private Boolean pConf; //出价保护置信


    /**
     * 探价控制参数
     */
    private Long ePriceThre; // 探价阈值

    private Double eRate; //探价概率

    private Boolean eConf;// 探价置信

    private String updateTime;// 更新时间


    /**
     * 深度 双出价 控制参数
     */

    private Double deepFactor; //深度目标调价因子


    /**
     * 获取维稳因子
     *
     * @param params
     * @return
     */
    public static Double getCostAtFactor(OcpxControlParams params) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                ret = params.getCFactor();

                if (params.getCFactor() != null && params.getPcFactor() != null) {
                    ret = Math.max(params.getCFactor(), params.getPcFactor());
                }
            }
        }

        return ret;
    }

    /**
     * 获取维稳因子 取 Max(预估纠偏因子,成本控制因子)
     *
     * @param params
     * @return
     */
    public static Double getCostFactor(OcpxControlParams params) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                ret =  params.getPcFactor();

            }
        }

        return ret;
    }

    /**
     * 获取深度调价因子
     *
     * @param params
     * @return
     */
    public static Double getDeepFactor(OcpxControlParams params) {

        Double ret = null;

        if (params != null) {

            ret = params.getDeepFactor();
        }

        return ret;
    }

    /**
     * 二价出价保护因子
     *
     * @param params
     * @return
     */
    public static Double getCostFactorWithProtect(OcpxControlParams params) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                if (params.getCFactor() != null) {
                    ret = params.getCFactor();
                }
            }
        }

        return ret;
    }


    /**
     * 获取重置状态
     *
     * @param ocpxControlParams
     * @return
     */

    public static Integer getResetType(OcpxControlParams ocpxControlParams) {

        if (ocpxControlParams != null) {
            return ocpxControlParams.getResetType();
        } else {
            return null;
        }
    }

    /**
     * 探价-调整出价
     */
    public static Long getExplorePrice(OcpxControlParams ocpxControlParams, Long fee) {
        Double adjustFee = fee.doubleValue();
        if (ocpxControlParams != null) {
            if (ocpxControlParams.getEConf() != null && ocpxControlParams.eConf) {
                Long ePriceThre = ocpxControlParams.getEPriceThre();
                if (ePriceThre != null && fee < ePriceThre) {
                    adjustFee = adjustFee + (ePriceThre - adjustFee) * 0.5;
                }
            }
        }
        return adjustFee.longValue();
    }

    /**
     * 探价-获取探价比例
     */
    public static Double getExploreRate(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null) {
            if (ocpxControlParams.getEConf() != null && ocpxControlParams.getEConf()) {
                return ocpxControlParams.getERate();
            }
        }
        return null;
    }


}

