package cn.com.duiba.nezha.alg.alg.adx.rtbbid2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxRtbBidRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidResultDo;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

public class RtbBidAlg {


    private static final Logger logger = LoggerFactory.getLogger(AdxRoiFactor.class);

    /**
     * 新增出价接口
     * 1.获取创意设置数据
     * 2.获取维稳因子
     * 3.计算出价
     *
     * @param bidRequestDo
     * @return
     */
    public static AdxRtbBidResultDo getRtbBidding(AdxRtbBidRequestDo bidRequestDo) {

        AdxRtbBidResultDo ret = new AdxRtbBidResultDo();

        if(!valid(bidRequestDo)) {
            logger.warn("bidRequestDo is not valid,bidRequestDo : {} ", JSON.toJSONString(bidRequestDo));
        }

        try{
            //流量参数
            Long resId = bidRequestDo.getResourceId();
            Long ideaId = bidRequestDo.getIdeaId();
            String appId = bidRequestDo.getAppId();
            Integer bidMode = bidRequestDo.getBidMode();
            Integer groupTag = bidRequestDo.getGroupTag();  //实验分组ID

            //维稳参数对象
            AdxFactorDo adxFactorDo = Optional.ofNullable(bidRequestDo.getAdxFactorDo()).orElse(new AdxFactorDo());    //不同的分组ID对应不同的维稳参数对象
            AdxFactorBaseDo factorBaseDo = adxFactorDo.getFactorBaseDo(resId, ideaId, appId);

            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(AdxConstant.DEFAULT_CPM);

            //创意参数
            Double preCtr = bidRequestDo.getPreCtr();
            Double statCtr = factorBaseDo.getStatCtr();
            Double ctr = MathUtil.mean(preCtr, statCtr, 0.9);
            ctr = Optional.ofNullable(ctr).orElse(AdxConstant.DEFAULT_CTR);

            Double preLaunchPv = bidRequestDo.getPreLaunchPv();
            Double statLaunchPv = factorBaseDo.getLaunchPv();
            Double launchPv = MathUtil.mean(preLaunchPv, statLaunchPv, 0.9);
            launchPv = Optional.ofNullable(launchPv).orElse(AdxConstant.DEFAULT_LAUNCHPV);

            Double arpu = factorBaseDo.getArpu();
            arpu = Optional.ofNullable(arpu).orElse(AdxConstant.DEFAULT_ARPU);

            Double clickValue = bidRequestDo.getClickValue();
            clickValue = Optional.ofNullable(clickValue).orElse(AdxConstant.DEFAULT_CLICKVALUE);


            Double cpc = bidRequestDo.getCpc();
            Double roi = bidRequestDo.getRoi() / 100;

            Double price = bidMode == 1 ?
                    getRoiPrice(groupTag, ctr, factor, launchPv, arpu, roi, clickValue) :
                    getCpcPrice(ctr, cpc, factor);

            price = Math.min(price, 3 * cpm);

            ret.setAdxAlgoPrice(Math.round(price));
            ret.setArpu(arpu);
            ret.setClickValue(clickValue);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
        }catch (Exception e) {
            logger.error("RtbBidAlg.getRtbBidding error", e);
        }
        return ret;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, Double factor) {
        Double price = ctr * cpc * factor * 1000;
        return price;
    }

    public static Double getRoiPrice(Integer groupTag, Double ctr, Double factor, Double launchPv, Double arpu, Double roi, Double clickValue) {
        Double price = null;
        if(groupTag == 3) {
            price = ctr * launchPv * arpu * factor / roi * 1000;
        }else{
            price = ctr * clickValue * factor / roi * 1000;
        }
        return price;
    }

    public static boolean valid(AdxRtbBidRequestDo bidRequestDo) {
        boolean ret = true;

        if(bidRequestDo == null || bidRequestDo.getBidMode() == null || bidRequestDo.getPreCtr() == null) {
            ret = false;
        }

        if(bidRequestDo.getBidMode() == 1 && (bidRequestDo.getRoi() == null || bidRequestDo.getPreLaunchPv() == null || bidRequestDo.getClickValue() == null)) {
            ret = false;
        }

        if(bidRequestDo.getBidMode() == 2 && bidRequestDo.getCpc() == null) {
            ret = false;
        }

        return ret;

    }






}
