package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxMaterialRecallReq;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxMaterialRecallRet;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class AdxMaterialRecall {

    private static final Logger logger = LoggerFactory.getLogger(AdxMaterialRecall.class);

    public static AdxMaterialRecallRet recall(AdxMaterialRecallReq adxMaterialRecallReq) {
        AdxMaterialRecallRet adxMaterialRecallRet = new AdxMaterialRecallRet();

        if(!valid(adxMaterialRecallReq)) {
            logger.warn("AdxMaterialRecall.recall params is invalid");
        }

        adxMaterialRecallReq.getResourceId();
        adxMaterialRecallReq.getAdxRatioType();
        adxMaterialRecallReq.getPictureType();
        List<Long> materialList = adxMaterialRecallReq.getMaterialList();

        return adxMaterialRecallRet;
    }

    public static boolean valid(AdxMaterialRecallReq adxMaterialRecallReq) {

        if(adxMaterialRecallReq == null) {
            return false;
        }

        if(AssertUtil.isAnyEmpty(adxMaterialRecallReq.getResourceId(), adxMaterialRecallReq.getAdxRatioType(), adxMaterialRecallReq.getMaterialList())) {
            return false;
        }

        return true;
    }
}
