package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;

import java.util.*;
import java.util.stream.Collectors;

public class AdxRecommend {


    /**
     * 0.输入可投计划列表
     */

    /**
     * 1.融合可投创意素材、优选素材、新素材
     * @param adIdeaDos 可投创意计划
     * @param recallSet 优选创意素材集
     * @param newSet    试投创意素材集
     */
    public static void needPreIdeaId(List<AdIdeaDo> adIdeaDos, Set<Long> recallSet, Set<Long> newSet) {
        Set<Long> recallNewSet = new HashSet<>();
        recallNewSet.addAll(newSet);
        recallNewSet.addAll(recallSet);

        for (AdIdeaDo adIdeaDo : adIdeaDos) {
            if(!adIdeaDo.isDpa()) {continue;}
            List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos().stream().filter(s -> recallNewSet.contains(s.getIdeaUnitId())).collect(Collectors.toList());
            adIdeaDo.setIdeaUnitDos(ideaUnitDos);
        }

    }

    /**
     * 2.特征生成，当前在algo-engine已存在特征生成逻辑，建议直接复用
     * cn.com.duiba.tuia.algo.engine.adx.builder.AdxBidBuilder#buildAdxIdeaFeatureDo
     * cn.com.duiba.tuia.algo.engine.adx.service.AdxRTBIdeaChoiceServiceImpl#getAdxFeatureDo
     *
     */
    public static Map<FeatureIndex, FeatureMapDo> getFeatureMap(List<AdIdeaDo> adIdeaDos ) {
        return null;
    }


    /**
     * 3.预估ctr、预估每pv发券
     */
    public static Map<FeatureIndex, Double> predict(Map<FeatureIndex, FeatureMapDo> featureMap,Model model, PredictType predictType) throws Exception {

        Map<FeatureIndex, Double> ret = new HashMap<>();

        if(predictType == PredictType.CTR) {
            ret = model.predictCtr(featureMap);
        }else if(predictType == PredictType.PVLAUNCH) {
            ret = model.predictLaunchPv(featureMap);
        }
        return ret;
    }

    /**
     * 4.粗排
     * 根据ctr排序，为每个计划选出TOP N创意
     * @param adIdeaDos
     * @param preCtrMap
     */
    public static void rawRank(List<AdIdeaDo> adIdeaDos, Map<FeatureIndex, Double> preCtrMap) {

        for(AdIdeaDo adIdeaDo : adIdeaDos) {
            Long adIdeaId = adIdeaDo.getAdIdeaId();
            List<IdeaUnitDo> ideaUnitDos =  adIdeaDo.getIdeaUnitDos()
                    .stream()
                    .sorted(Comparator.comparing(ideaUnitDo -> {
                        Long ideaUnitId = ((IdeaUnitDo)ideaUnitDo).getIdeaUnitId();
                        FeatureIndex featureIndex = new FeatureIndex(ideaUnitId, adIdeaId);
                        Double preCtr = preCtrMap.getOrDefault(featureIndex, 0D);
                        return preCtr;
                    }).reversed()).limit(1)
                    .collect(Collectors.toList());
            adIdeaDo.setIdeaUnitDos(ideaUnitDos);
        }
        return;
    }

    /**
     * 5.每pv发券预估,接口与第三步的预估ctr接口相同
     */

    /**
     * 6.出价
     */
    public static void bidding(List<AdIdeaDo> adIdeaDos, AdxFactorDo adxFactorDo, String appId) {

        for(AdIdeaDo adIdeaDo : adIdeaDos) {
            Long ideaId = adIdeaDo.getAdIdeaId();
            Long resId = adIdeaDo.getResId();
            List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();
            Integer bidMode = adIdeaDo.getBidMode();

            AdxFactorBaseDo factorBaseDo = adxFactorDo.getFactorBaseDo(resId, ideaId, appId);

            ideaUnitDos.stream().peek(IdeaUnitDo -> {

            });



        }


    }

    /**
     * 7.精排
     */
    public static List<IdeaUnitDo> fineRank(List<AdIdeaDo> ideas) {

        return ideas.stream().map(AdIdeaDo::getIdeaUnitDos).flatMap(Collection::stream)
                .sorted(Comparator.comparing(IdeaUnitDo::getPrice).reversed()).collect(Collectors.toList());
    }

    /**
     * 8.定时任务--离线召回
     * cn.com.duiba.nezha.alg.alg.adx.rcmd.AdxMaterialRecallAlg#adxMaterialRecall(cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxMaterialRecallReqDo)
     */

    /**
     * 9.定时任务--维稳
     * cn.com.duiba.nezha.alg.alg.adx.rtbbid2.AdxRoiFactor#run(cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorReqDo)
     */



}
