package cn.com.duiba.nezha.alg.alg.adx.rtbbid2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxRtbBidRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

public class RtbBidAlg {


    private static final Logger logger = LoggerFactory.getLogger(RtbBidAlg.class);

    /**
     * 新增出价接口
     * 1.获取创意设置数据
     * 2.获取维稳因子
     * 3.计算出价
     *
     * @param bidRequestDo
     * @return
     */
    public static AdxRtbBidResultDo getRtbBidding(AdxRtbBidRequestDo bidRequestDo) {

        AdxRtbBidResultDo ret = new AdxRtbBidResultDo();

        try{
            if(!valid(bidRequestDo) || (bidRequestDo.getPriceType() != null && bidRequestDo.getPriceType() == 2)) {
                printBidReq(bidRequestDo);
            }

            //流量参数
            Long resId = bidRequestDo.getResourceId();
            Long ideaId = bidRequestDo.getIdeaId();
            String appId = bidRequestDo.getAppId();
            Integer bidMode = bidRequestDo.getBidMode();
            Integer groupTag = bidRequestDo.getGroupTag();  //实验分组ID
            Integer priceType = Optional.ofNullable(bidRequestDo.getPriceType()).orElse(1);

            //维稳参数对象
            AdxFactorDo adxFactorDo = Optional.ofNullable(bidRequestDo.getAdxFactorDo()).orElse(new AdxFactorDo());    //不同的分组ID对应不同的维稳参数对象
            AdxFactorBaseDo factorBaseDo = adxFactorDo.getFactorBaseDo(resId, ideaId, appId);
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(AdxConstant.DEFAULT_CPM);

            //创意参数
            Double preCtr = bidRequestDo.getPreCtr();
            Double statCtr = factorBaseDo.getStatCtr();
            Double ctr = MathUtil.mean(preCtr, statCtr, 0.9);
            ctr = Optional.ofNullable(ctr).orElse(AdxConstant.DEFAULT_CTR);

            Double preLaunchPv = bidRequestDo.getPreLaunchPv();
            Double statLaunchPv = factorBaseDo.getLaunchPv();
            Double launchPv = MathUtil.mean(preLaunchPv, statLaunchPv, 0.9);
            launchPv = Optional.ofNullable(launchPv).orElse(AdxConstant.DEFAULT_LAUNCHPV);

            Double arpu = factorBaseDo.getArpu();
            arpu = Optional.ofNullable(arpu).orElse(AdxConstant.DEFAULT_ARPU);

            Double preClickValue = bidRequestDo.getClickValue();
            Double statClick = factorBaseDo.getClickValue();
            Double clickValue = MathUtil.mean(preClickValue, statClick, 0.9);
            clickValue = Optional.ofNullable(clickValue).orElse(AdxConstant.DEFAULT_CLICKVALUE);


            Double cpc = priceType == 1 ? bidRequestDo.getCpc() : bidRequestDo.getDirectCpc();
            Double roi = MathUtil.division(bidRequestDo.getRoi(), 100L, 3);

            Double price;
            if(priceType == 1) {    //互动出价
                price = bidMode == 1 ?
                        getRoiPrice(groupTag, ctr, factor, launchPv, arpu, roi, clickValue) :
                        getCpcPrice(ctr, cpc, factor);
            }else {
                price = getDirectPrice(ctr, cpc, factor, roi);  //直投出价
            }


            price = Math.min(price, 50 * cpm);

            ret.setAdxAlgoPrice(Math.round(price));
            ret.setArpu(arpu);
            ret.setClickValue(clickValue);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
        }catch (Exception e) {
            logger.error("RtbBidAlg.getRtbBidding error", e);
        }
        return ret;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor) {
        return ctr * cpc * factor * 1000 * 100;
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, double factor, Double roi) {
        return DataUtil.division(ctr * algoCpcPrice * factor * 1000, roi, 3);
    }

    public static Double getRoiPrice(Integer groupTag, Double ctr, double factor, Double launchPv, Double arpu, Double roi, Double clickValue) {
        Double price;
        if(groupTag == 3 || groupTag == 2) {
            price = ctr * launchPv * arpu * factor / roi * 1000;
        }else{
            price = ctr * clickValue * factor / roi * 1000;
        }
        return price;
    }

    public static boolean valid(AdxRtbBidRequestDo bidRequestDo) {
        boolean ret = true;

        if(AssertUtil.isAnyEmpty(bidRequestDo, bidRequestDo.getPreCtr(), bidRequestDo.getPriceType())) {
            return false;
        }
        if(bidRequestDo.getPriceType() == 1) {
            if (bidRequestDo.getBidMode() == null) {
                return false;
            }else if(bidRequestDo.getBidMode() == 1) {
                ret = bidRequestDo.getRoi() != null && bidRequestDo.getPreLaunchPv() != null;
            }else {
                ret = bidRequestDo.getCpc() == null ? false : true;
            }
        }else if(bidRequestDo.getPriceType() == 2) {
            ret = bidRequestDo.getDirectCpc() != null && bidRequestDo.getRoi() != null;
        }

        return ret;

    }

    public static void printBidReq(AdxRtbBidRequestDo bidRequestDo) {

        if(Math.random() < 0.1) {
            logger.info("bidRequestDo is not valid, groupTag{}, groupId{}, resourceId{}, ideaId{}, appId{}, priceType{}, bidMode{}, preCtr{}, roi{}, preLaunchPv{}, cpc{}, clickValue{}, directCpc:{}",
                    bidRequestDo.getGroupTag(), bidRequestDo.getGroupId(), bidRequestDo.getResourceId(), bidRequestDo.getIdeaId(), bidRequestDo.getAppId(), bidRequestDo.getPriceType(), bidRequestDo.getBidMode(), bidRequestDo.getPreCtr(), bidRequestDo.getRoi()
                    , bidRequestDo.getPreLaunchPv(), bidRequestDo.getCpc(), bidRequestDo.getClickValue(), bidRequestDo.getDirectCpc());
        }

    }







}
