package cn.com.duiba.nezha.alg.alg.coldstartandexplore;


import cn.com.duiba.nezha.alg.alg.vo.StrongOrientInfo;
import com.alibaba.fastjson.JSON;

import java.util.ArrayList;
import java.util.List;

public class StrongOrientFilter {
    /**
     * 定向过滤接口
     * @param orientInfoList
     * @return
     */
    public static List<StrongOrientInfo> strongOrientFilter(List<StrongOrientInfo> orientInfoList) {
        for(StrongOrientInfo orient : orientInfoList){
            orient.setIsRecom(false);
            if(orient.getIsStrongOrient()) {
                orient.setIsRecom(true);
            }
            if(orient.getReleaseTarget() != null && orient.getReleaseTarget() == 4){
                orient.setIsExplore(false);
            }else{
                orient.setIsExplore(true);
            }
        }
        return orientInfoList;
    }

    public static void main(String[] args) {
        List<StrongOrientInfo> orientInfoList = new ArrayList<>();
        StrongOrientInfo info = new StrongOrientInfo();
        info.setIsStrongOrient(false);
        info.setReleaseTarget(3);
        orientInfoList.add(info);

        System.out.println(JSON.toJSONString(strongOrientFilter(orientInfoList)));

    }
}
