package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import lombok.Data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

@Data
public class AdIdeaDo {

    /**
     * 创意计划ID
     */
    public Long adIdeaId;

    /**
     * 资源位ID
     */
    private Long resId;

    /**
     * 出价方式：1-roi出价、2-cpc出价
     */
    private Integer bidMode;

    /**
     * 目标roi
     */
    private Double roi;

    /**
     * 目标cpc
     */
    private Double cpc;

    /**
     * 直投cpc
     */
    private Double directCpc;

    /**
     * 创意计划类型 0-人工 1-算法 2-直投
     */
    private Integer priceType;

    /**
     * 是否dpa计划
     */
    private boolean isDpa;

    /**
     * 创意素材列表
     */
    private List<IdeaUnitDo> ideaUnitDos;

    public List<IdeaUnitDo> getIdeaUnitDos() {
        return Optional.ofNullable(ideaUnitDos).orElse(new ArrayList<>());
    }
}
