package cn.com.duiba.nezha.alg.alg.vo.adx.rtb2;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class AdxFactorSubDo {

    /**
     * 创意设置数据
     */
    private AdxIdeaDo adxIdeaDo;

    /**
     * 创意维度 维稳因子
     */
    private AdxFactorBaseDo factorBaseDo = new AdxFactorBaseDo();

    /**
     * 创意+APP 维度维稳因子
     */
    private Map<String, AdxFactorBaseDo> appFactorBaseDo = new HashMap<>();

    /**
     * 获取创意+APP 维度维稳因子
     * @param appId
     * @return
     */
    public AdxFactorBaseDo getAppFactor(String appId) {
        AdxFactorBaseDo ret = new AdxFactorBaseDo();
        if(appFactorBaseDo != null && appId != null) {
            ret = appFactorBaseDo.getOrDefault(appId,new AdxFactorBaseDo());
        }
        return ret;
    }

    /**
     * 更新创意+APP 维度维稳因子
     * @param appId
     * @param adxFactorBaseDo
     */
    public void putAppFactor(String appId, AdxFactorBaseDo adxFactorBaseDo) {
        if(AssertUtil.isAllNotEmpty(appId, adxFactorBaseDo)) {
            appFactorBaseDo.put(appId, adxFactorBaseDo);
        }
    }
}
