/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFilterTask;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFilterTaskPlus;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFlowFiltering;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.ChargePvFiltering;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.LaunchPvFiltering;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.CandidateActivityDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowFilterAlg {
    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFilterAlg.class);

    public static FlowFilterResultDo adxFlowFiltering(FlowFilterRequestDo flowFilterRequestDo) {
        FlowFilterResultDo ret = new FlowFilterResultDo();
        try {
            if (flowFilterRequestDo != null) {
                ret = AdxFlowFiltering.getFlowFiltering(flowFilterRequestDo);
                Integer flowFilterLabel = ret.getFlowFilterLabel();
                Integer flowGroup = AdxStatData.nullToDefault(flowFilterRequestDo.getFlowGroup(), 1);
                Integer baseFilterFlag = AdxStatData.nullToDefault(flowFilterRequestDo.getBaseFilterFlag(), 0);
                Integer groupTag = flowFilterRequestDo.getGroupTag();
                if (groupTag == null) {
                    groupTag = 0;
                }
                if (AdxFlowFilterAlg.valid(flowFilterRequestDo).booleanValue()) {
                    HashMap<Long, FeatureMapDo> featureMapDoMap = new HashMap<Long, FeatureMapDo>();
                    HashMap featureMap = new HashMap();
                    Long ideaId = flowFilterRequestDo.getFlowInfo().getIdeaId();
                    featureMapDoMap.put(ideaId, flowFilterRequestDo.getFeatureMapDo());
                    CODER launchPvCoderModel = flowFilterRequestDo.getLaunchPvCoderModel();
                    LocalTFModel launchPvLtfModel = flowFilterRequestDo.getLaunchPvLtfModel();
                    Map preValueMap1 = launchPvCoderModel.predictWithLocalTFNew(featureMapDoMap, launchPvLtfModel);
                    flowFilterRequestDo.setPreLaunchPv((Double)preValueMap1.get(ideaId));
                    if (flowGroup.equals(4)) {
                        CODER2 chargePvCoderModel = flowFilterRequestDo.getChargePvCoderModel();
                        LocalTFModel chargePvLtfModel = flowFilterRequestDo.getChargePvLtfModel();
                        Map preValueMap2 = chargePvCoderModel.predictWithLocalTFNew(featureMapDoMap, chargePvLtfModel);
                        flowFilterRequestDo.setPreChargePv((Double)preValueMap2.get(ideaId));
                    }
                }
                if (AssertUtil.isNotEmpty((Object)flowFilterLabel) && flowFilterLabel.equals(0)) {
                    if (flowGroup.equals(1) && baseFilterFlag.equals(1) || flowGroup.equals(3)) {
                        FlowFilterResultDo launchPvRet = LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
                        ret.setFlowFilterLabel(launchPvRet.getFlowFilterLabel());
                        ret.setFilterType(launchPvRet.getFilterType());
                    } else if (flowGroup.equals(4)) {
                        FlowFilterResultDo chargePvRet = ChargePvFiltering.getChargePvFiltering(flowFilterRequestDo);
                        ret.setFlowFilterLabel(chargePvRet.getFlowFilterLabel());
                        ret.setFilterType(chargePvRet.getFilterType());
                    }
                }
                ret.setPreLaunchPv(flowFilterRequestDo.getPreLaunchPv());
                ret.setBestActivityId(flowFilterRequestDo.getBestActivityId());
                ret.setPreChargePv(flowFilterRequestDo.getPreChargePv());
                logger.info("launchPvGroupTag{}, ret: {}", (Object)groupTag, (Object)ret);
            }
        }
        catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering error:" + e);
        }
        return ret;
    }

    private static List<Map.Entry<Long, Double>> mapValueSortDesc(Map<Long, Double> labelsMap) {
        ArrayList<Map.Entry<Long, Double>> list = new ArrayList<Map.Entry<Long, Double>>(labelsMap.entrySet());
        list.sort((o1, o2) -> ((Double)o2.getValue()).compareTo((Double)o1.getValue()));
        return list;
    }

    public static Map<Long, FeatureMapDo> createFeatureMap(FlowFilterRequestDo flowFilterRequestDo, List<CandidateActivityDo> candidateActivityDos) {
        HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
        Map staticFeatureMap = flowFilterRequestDo.getFeatureMapDo().getStaticFeatureMap();
        staticFeatureMap.putAll(flowFilterRequestDo.getFeatureMapDo().getDynamicFeatureMap());
        for (CandidateActivityDo activityDo : candidateActivityDos) {
            Long activityId = activityDo.getActivityId();
            Map dynamicFeatureMap = AdxFeatureParse.generateActivityFeatureMapDynamic((CandidateActivityDo)activityDo, (Map)staticFeatureMap);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(activityId, featureMapDo);
        }
        return featureMap;
    }

    public static Map<Long, FeatureMapDo> getFeatureMap(FlowFilterRequestDo flowFilterRequestDo) {
        AdxFeatureDo adxFeatureDo = flowFilterRequestDo.getAdxFeatureDo();
        Map staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
        Map dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic((AdxFeatureDo)adxFeatureDo, (AdxFeatureDo)adxFeatureDo);
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
        featureMapDo.setStaticFeatureMap(staticFeatureMap);
        HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
        Long ideaId = flowFilterRequestDo.getFlowInfo().getIdeaId();
        featureMap.put(ideaId, featureMapDo);
        return featureMap;
    }

    private static Boolean valid(FlowFilterRequestDo flowFilterRequestDo) {
        Boolean ret = true;
        if (flowFilterRequestDo == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid , params flowFilterRequestDo is null");
            return false;
        }
        if (flowFilterRequestDo.getLaunchPvLtfModel() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid , params launchPvLtfModel is null");
            return false;
        }
        if (flowFilterRequestDo.getLaunchPvCoderModel() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid , params launchPvCoderModel is null");
            return false;
        }
        if (flowFilterRequestDo.getAdxFeatureDo() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid ,params adxFeatureDo is null");
            return false;
        }
        if (flowFilterRequestDo.getFlowInfo() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid ,params flowInfo is null");
            return false;
        }
        return ret;
    }

    public static AdxFilterInfoDo adxFilterTask(AdxFlowInfoDo flowInfo, AdxFilterInfoDo lastFilterInfo) {
        AdxFilterInfoDo ret = null;
        try {
            ret = AdxFilterTask.getFilterInfo(flowInfo, lastFilterInfo);
        }
        catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTask error " + e);
        }
        return ret;
    }

    public static AdxFilterInfoDo adxFilterTaskPlus(AdxFlowInfoDo flowInfo, AdxFilterInfoDo lastFilterInfo) {
        AdxFilterInfoDo ret = null;
        try {
            ret = AdxFilterTaskPlus.getFilterInfo(flowInfo, lastFilterInfo);
        }
        catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTaskPlus error " + e);
        }
        return ret;
    }
}

