package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaMaterialId;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.*;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.CandidateActivityDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class AdxFlowFilterAlg {

    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFilterAlg.class);

    /**
     * 获取过滤结果
     * @param flowFilterRequestDo 流量过滤请求对象
     * @param candidateActivityDos 候选活动特征对象
     * @return
     */
    public static FlowFilterResultDo adxFlowFiltering(FlowFilterRequestDo flowFilterRequestDo,
                                                      List<CandidateActivityDo> candidateActivityDos) {

        FlowFilterResultDo ret = new FlowFilterResultDo();

        try {

            if (flowFilterRequestDo != null) {

                //【流量预过滤--ctr&roi过滤】
                ret = AdxFlowFiltering.getFlowFiltering(flowFilterRequestDo);
                Integer flowFilterLabel = ret.getFlowFilterLabel();


                Integer flowGroup = AdxStatData.nullToDefault(flowFilterRequestDo.getFlowGroup(), 1);
                Integer baseFilterFlag = AdxStatData.nullToDefault(flowFilterRequestDo.getBaseFilterFlag(), 0);

                // ab测试分流标记
                Integer groupTag = flowFilterRequestDo.getGroupTag();
                if (groupTag == null) {
                    groupTag = 0;
                }

                if(valid(flowFilterRequestDo)) {
                    /**
                     * 获取特征
                     */
                    Map<Long, FeatureMapDo> featureMapDoMap = new HashMap<>();
                    Map<Long, FeatureMapDo> featureMap = new HashMap<>();

                    Long ideaId = flowFilterRequestDo.getFlowInfo().getIdeaId(); //默认1个创意
                    featureMapDoMap.put(ideaId, flowFilterRequestDo.getFeatureMapDo());

                    // 如果走预出活动逻辑，则组装活动特征
                    if (groupTag == 7) {
                        if (AssertUtil.isEmpty(candidateActivityDos)) {
                            logger.info("LaunchPv candidateActivityDos isEmpty");
                        }
                        else {
                            featureMap = createFeatureMap(flowFilterRequestDo, candidateActivityDos);
                        }
                    }

                    /**
                     * 预估每pv发券
                     */
                    CODER launchPvCoderModel = flowFilterRequestDo.getLaunchPvCoderModel();
                    LocalTFModel launchPvLtfModel = flowFilterRequestDo.getLaunchPvLtfModel();

                    // 如果走预出活动逻辑，则调用预出活动模型预测，并返回最佳的活动ID及对应的LaunchPv值
                    if (groupTag == 7) {
                        Map<Long, Double> preValueMap1 = launchPvCoderModel.predictWithLocalTFNew(featureMap, launchPvLtfModel);
                        if (preValueMap1 == null) {
                            preValueMap1 = new HashMap<>();
                        }

                        List<Map.Entry<Long, Double>> activityListSort;

                        activityListSort = mapValueSortDesc(preValueMap1);
                        if (activityListSort.size() > 0) {
                            Long bestActivityId = activityListSort.get(0).getKey();
                            Double bestLaunchPv = activityListSort.get(0).getValue();
                            flowFilterRequestDo.setBestActivityId(bestActivityId);
                            flowFilterRequestDo.setPreLaunchPv(bestLaunchPv);
                        } else {
                            logger.info("LaunchPv preActivity error");
                        }
                    }
                    else {
                        Map<Long, Double> preValueMap1 = launchPvCoderModel.predictWithLocalTFNew(featureMapDoMap, launchPvLtfModel);
                        flowFilterRequestDo.setPreLaunchPv(preValueMap1.get(ideaId));
                    }


                    /**
                     * 预估每pv点券
                     */
                    if(flowGroup.equals(4)) {
                        CODER2 chargePvCoderModel = flowFilterRequestDo.getChargePvCoderModel();
                        LocalTFModel chargePvLtfModel = flowFilterRequestDo.getChargePvLtfModel();
                        Map<Long, Double> preValueMap2 =  chargePvCoderModel.predictWithLocalTFNew(featureMapDoMap, chargePvLtfModel);
                        flowFilterRequestDo.setPreChargePv(preValueMap2.get(ideaId));
                    }
                }


                /**
                 * 过滤
                 */
                if(AssertUtil.isNotEmpty(flowFilterLabel) && flowFilterLabel.equals(0)){

                    if ( (flowGroup.equals(1) && baseFilterFlag.equals(1)) || flowGroup.equals(3)) {
                        //【每pv发券过滤】
                        FlowFilterResultDo launchPvRet= LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
                        ret.setFlowFilterLabel(launchPvRet.getFlowFilterLabel());
                        ret.setFilterType(launchPvRet.getFilterType());

                    } else if (flowGroup.equals(4)) {
                        //【每pv点券过滤】
                        FlowFilterResultDo chargePvRet= ChargePvFiltering.getChargePvFiltering(flowFilterRequestDo);
                        ret.setFlowFilterLabel(chargePvRet.getFlowFilterLabel());
                        ret.setFilterType(chargePvRet.getFilterType());

                    }

                }
                ret.setPreLaunchPv(flowFilterRequestDo.getPreLaunchPv());
                ret.setBestActivityId(flowFilterRequestDo.getBestActivityId());
                ret.setPreChargePv(flowFilterRequestDo.getPreChargePv());

            }

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering error:", e);

        }

        return ret;
    }

    /**
     *  Map的value值降序排序
     */
    private static List<Map.Entry<Long, Double>> mapValueSortDesc(Map<Long, Double> labelsMap) {
        List<Map.Entry<Long, Double>> list = new ArrayList<>(labelsMap.entrySet());
        list.sort((o1, o2) -> o2.getValue().compareTo(o1.getValue()));
        return list;
    }


    public static Map<Long, FeatureMapDo> createFeatureMap(FlowFilterRequestDo flowFilterRequestDo,
                                                           List<CandidateActivityDo> candidateActivityDos) {

        Map<Long, FeatureMapDo> featureMap = new HashMap<>();

        //1 创意特征：静态特征解析
        Map<String, String> staticFeatureMap = flowFilterRequestDo.getFeatureMapDo().getStaticFeatureMap();
        staticFeatureMap.putAll(flowFilterRequestDo.getFeatureMapDo().getDynamicFeatureMap());

        //2 活动特征：动态特征解析
        for (CandidateActivityDo activityDo : candidateActivityDos) {
            Long activityId = activityDo.getActivityId();
            Map<String, String> dynamicFeatureMap = AdxFeatureParse.generateActivityFeatureMapDynamic(activityDo, staticFeatureMap);
            //3 封装活动特征集合
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(activityId, featureMapDo);
        }
        return featureMap;
    }


    /**
     * 获取特征
     * @param flowFilterRequestDo
     * @return
     */
    public static  Map<Long, FeatureMapDo> getFeatureMap(FlowFilterRequestDo flowFilterRequestDo) {

        AdxFeatureDo adxFeatureDo = flowFilterRequestDo.getAdxFeatureDo();
        Map<String, String> staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo);
        Map<String, String> dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic(adxFeatureDo, adxFeatureDo);
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
        featureMapDo.setStaticFeatureMap(staticFeatureMap);

        Map<Long, FeatureMapDo> featureMap = new HashMap<>();
        Long ideaId = flowFilterRequestDo.getFlowInfo().getIdeaId(); //默认1个创意
        featureMap.put(ideaId, featureMapDo);

        return featureMap;

    }

    /**
     * 校验基础信息是否合法
     *
     * @param flowFilterRequestDo
     * @return
     */
    private static Boolean valid(FlowFilterRequestDo flowFilterRequestDo) {

        Boolean ret = true;

        if (flowFilterRequestDo == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid , params flowFilterRequestDo is null");
            return false;
        }

        if (flowFilterRequestDo.getLaunchPvLtfModel() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid , params launchPvLtfModel is null");
            return false;
        }

        if (flowFilterRequestDo.getLaunchPvCoderModel() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid , params launchPvCoderModel is null");
            return false;
        }

        if (flowFilterRequestDo.getAdxFeatureDo() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid ,params adxFeatureDo is null");
            return false;
        }

        if (flowFilterRequestDo.getFlowInfo() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid ,params flowInfo is null");
            return false;
        }

        return ret;
    }

    /**
     * 流量预过滤1.0定时任务
     * (根据缓存数据，调用频率：30min调用1次）
     *
     * @param flowInfo   adx流量信息
     * @param lastFilterInfo 上一次出参（定时任务）
     * @return
     */
    public static AdxFilterInfoDo adxFilterTask(AdxFlowInfoDo flowInfo,
                                                AdxFilterInfoDo lastFilterInfo) {

        AdxFilterInfoDo ret = null;

        try {
            ret = AdxFilterTask.getFilterInfo(flowInfo, lastFilterInfo);

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTask error " + e);

        }

        return ret;
    }



    /**
     * 流量预过滤2.0定时任务
     * (根据缓存数据，调用频率：30min调用1次）
     *
     * @param flowInfo   adx流量信息
     * @param lastFilterInfo 上一次出参（定时任务）
     * @return
     */
    public static AdxFilterInfoDo adxFilterTaskPlus(AdxFlowInfoDo flowInfo,
                                                    AdxFilterInfoDo lastFilterInfo) {

        AdxFilterInfoDo ret = null;

        try {
            ret = AdxFilterTaskPlus.getFilterInfo(flowInfo, lastFilterInfo);

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTaskPlus error " + e);

        }

        return ret;
    }


}
