package cn.com.duiba.nezha.alg.alg.coldstartandexplore;


import cn.com.duiba.nezha.alg.alg.vo.StrongOrientInfo;
import com.alibaba.fastjson.JSON;

import java.util.ArrayList;
import java.util.List;

public class StrongOrientFilter {
    /**
     * 定向过滤接口
     * @param orientInfoList
     * @return
     */
    public static List<StrongOrientInfo> strongOrientFilter(List<StrongOrientInfo> orientInfoList) {

        List<StrongOrientInfo> res = new ArrayList<>(orientInfoList.size());
        if(orientInfoList.isEmpty()) {
            return res;
        }

        for(StrongOrientInfo orient : orientInfoList){
            if(orient.getChargeType().equals("CPC")) {      // 计费方式为CPC
                if(orient.getIsStrongOrient()) {
                    orient.setIsRecom(true);
                }else {
                    orient.setIsTrusteeship(true);
                }
            }else {                                         // 计费方式为oCPC(CPA)
                if(orient.getTargetAppLimit() != null && orient.getTargetAppLimit() == 3) {       //人工定向
                    if(orient.getIsStrongOrient()) {    //强定向直接参竞
                        orient.setIsRecom(true);
                    }else {                             //非强定向，分流量标识做过滤
                        if(orient.getExpIdentify().equals("expD") && !orient.getIsAdvertBlackList() && orient.getCanExplore()) {
                            orient.setIsExplore(true);
                        }else if(orient.getExpIdentify().equals("expB") && !orient.getIsAdvertBlackList() && orient.getCanExplore()) {
                            orient.setIsRecom(true);
                        }else{
                            if(!orient.getExistTargetAppOrSlot()){
                                orient.setIsTrusteeship(true);     // 对照组中非强定向走托管
                            }
                        }
                    }
                }else {         //托管
                    if(orient.getExpIdentify().equals("exp") || orient.getExpIdentify().equals("main")) {
                        orient.setIsTrusteeship(true);
                    }else if(orient.getExpIdentify().equals("expD")) {
                        orient.setIsExplore(true);
                    }else if(orient.getExpIdentify().equals("expB")) {
                        if(orient.getNewTrade().equals("保险")) {     //不可拓行业走原来托管接口
                            orient.setIsTrusteeship(true);
                        }else {                                      //可拓行业走拓量接口
                            orient.setIsExplore(true);
                        }
                    }
                }
            }

            res.add(orient);
        }

        return res;
    }

    public static void main(String[] args) {
        List<StrongOrientInfo> orientInfoList = new ArrayList<>();
        StrongOrientInfo info = new StrongOrientInfo();
        info.setAdvertId(123L);
        info.setOrientId(0L);
        info.setExpIdentify("expD");
        info.setIsStrongOrient(false);
//        info.setReleaseTarget(3);
        info.setCanExplore(false);
        info.setIsAdvertBlackList(false);
        info.setNewTrade("保险");
//        info.setNewTrade("会籍卡");
        orientInfoList.add(info);

        System.out.println(JSON.toJSONString(strongOrientFilter(orientInfoList)));

    }
}